/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.common.lucene.store;

import java.io.EOFException;
import java.io.IOException;
import org.apache.lucene.store.IndexInput;
import org.apache.lucene.store.RandomAccessInput;
import org.apache.lucene.util.BitUtil;
import org.elasticsearch.common.Strings;

public class ByteArrayIndexInput
extends IndexInput
implements RandomAccessInput {
    private final byte[] bytes;
    private int pos;
    private final int offset;
    private final int length;

    public ByteArrayIndexInput(String resourceDesc, byte[] bytes) {
        this(resourceDesc, bytes, 0, bytes.length);
    }

    public ByteArrayIndexInput(String resourceDesc, byte[] bytes, int offset, int length) {
        super(resourceDesc);
        this.bytes = bytes;
        this.offset = offset;
        this.pos = offset;
        this.length = length;
    }

    public void close() throws IOException {
    }

    public long getFilePointer() {
        return this.pos - this.offset;
    }

    public void seek(long l) throws IOException {
        this.pos = this.position(l);
    }

    private int position(long p) throws EOFException {
        if (p < 0L) {
            throw new IllegalArgumentException("Seeking to negative position: " + p);
        }
        if (p > (long)this.length) {
            throw new EOFException("seek past EOF");
        }
        return (int)p + this.offset;
    }

    public long length() {
        return this.length;
    }

    public byte readByte(long pos) throws IOException {
        return this.bytes[this.position(pos)];
    }

    public short readShort(long pos) throws IOException {
        return BitUtil.VH_LE_SHORT.get(this.bytes, this.position(pos));
    }

    public int readInt(long pos) throws IOException {
        return BitUtil.VH_LE_INT.get(this.bytes, this.position(pos));
    }

    public long readLong(long pos) throws IOException {
        return BitUtil.VH_LE_LONG.get(this.bytes, this.position(pos));
    }

    public IndexInput slice(String sliceDescription, long offset, long length) throws IOException {
        if (offset >= 0L && length >= 0L && offset + length <= (long)this.length) {
            return new ByteArrayIndexInput(sliceDescription, this.bytes, this.offset + (int)offset, (int)length);
        }
        throw new IllegalArgumentException(Strings.format("slice() %s out of bounds: offset=%d,length=%d,fileLength=%d: %s", new Object[]{sliceDescription, offset, length, this.length, this}));
    }

    public byte readByte() throws IOException {
        if (this.pos >= this.offset + this.length) {
            throw new EOFException("seek past EOF");
        }
        return this.bytes[this.pos++];
    }

    public void readBytes(byte[] b, int offset, int len) throws IOException {
        if (this.pos + len > this.offset + this.length) {
            throw new EOFException("seek past EOF");
        }
        System.arraycopy(this.bytes, this.pos, b, offset, len);
        this.pos += len;
    }

    public short readShort() throws IOException {
        try {
            short s = BitUtil.VH_LE_SHORT.get(this.bytes, this.pos);
            return s;
        }
        finally {
            this.pos += 2;
        }
    }

    public int readInt() throws IOException {
        try {
            int n = BitUtil.VH_LE_INT.get(this.bytes, this.pos);
            return n;
        }
        finally {
            this.pos += 4;
        }
    }

    public long readLong() throws IOException {
        try {
            long l = BitUtil.VH_LE_LONG.get(this.bytes, this.pos);
            return l;
        }
        finally {
            this.pos += 8;
        }
    }
}

