/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.action.admin.indices.cache.clear;

import java.io.IOException;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.ActionType;
import org.elasticsearch.action.admin.indices.cache.clear.ClearIndicesCacheRequest;
import org.elasticsearch.action.support.ActionFilters;
import org.elasticsearch.action.support.broadcast.BroadcastResponse;
import org.elasticsearch.action.support.broadcast.node.TransportBroadcastByNodeAction;
import org.elasticsearch.cluster.ClusterState;
import org.elasticsearch.cluster.block.ClusterBlockException;
import org.elasticsearch.cluster.block.ClusterBlockLevel;
import org.elasticsearch.cluster.metadata.IndexNameExpressionResolver;
import org.elasticsearch.cluster.project.ProjectResolver;
import org.elasticsearch.cluster.routing.ShardRouting;
import org.elasticsearch.cluster.routing.ShardsIterator;
import org.elasticsearch.cluster.service.ClusterService;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.indices.IndicesService;
import org.elasticsearch.injection.guice.Inject;
import org.elasticsearch.tasks.Task;
import org.elasticsearch.transport.TransportService;

public class TransportClearIndicesCacheAction
extends TransportBroadcastByNodeAction<ClearIndicesCacheRequest, BroadcastResponse, TransportBroadcastByNodeAction.EmptyResult> {
    public static final ActionType<BroadcastResponse> TYPE = new ActionType("indices:admin/cache/clear");
    private final IndicesService indicesService;
    private final ProjectResolver projectResolver;

    @Inject
    public TransportClearIndicesCacheAction(ClusterService clusterService, TransportService transportService, IndicesService indicesService, ActionFilters actionFilters, ProjectResolver projectResolver, IndexNameExpressionResolver indexNameExpressionResolver) {
        super(TYPE.name(), clusterService, transportService, actionFilters, indexNameExpressionResolver, ClearIndicesCacheRequest::new, transportService.getThreadPool().executor("management"), false);
        this.indicesService = indicesService;
        this.projectResolver = projectResolver;
    }

    @Override
    protected TransportBroadcastByNodeAction.EmptyResult readShardResult(StreamInput in) throws IOException {
        return TransportBroadcastByNodeAction.EmptyResult.INSTANCE;
    }

    @Override
    protected TransportBroadcastByNodeAction.ResponseFactory<BroadcastResponse, TransportBroadcastByNodeAction.EmptyResult> getResponseFactory(ClearIndicesCacheRequest request, ClusterState clusterState) {
        return (totalShards, successfulShards, failedShards, responses, shardFailures) -> new BroadcastResponse(totalShards, successfulShards, failedShards, shardFailures);
    }

    @Override
    protected ClearIndicesCacheRequest readRequestFrom(StreamInput in) throws IOException {
        return new ClearIndicesCacheRequest(in);
    }

    @Override
    protected void shardOperation(ClearIndicesCacheRequest request, ShardRouting shardRouting, Task task, ActionListener<TransportBroadcastByNodeAction.EmptyResult> listener) {
        ActionListener.completeWith(listener, () -> {
            this.indicesService.clearIndexShardCache(shardRouting.shardId(), request.queryCache(), request.fieldDataCache(), request.requestCache(), request.fields());
            return TransportBroadcastByNodeAction.EmptyResult.INSTANCE;
        });
    }

    @Override
    protected ShardsIterator shards(ClusterState clusterState, ClearIndicesCacheRequest request, String[] concreteIndices) {
        return clusterState.routingTable(this.projectResolver.getProjectId()).allShards(concreteIndices);
    }

    @Override
    protected ClusterBlockException checkGlobalBlock(ClusterState state, ClearIndicesCacheRequest request) {
        return state.blocks().globalBlockedException(ClusterBlockLevel.METADATA_WRITE);
    }

    @Override
    protected ClusterBlockException checkRequestBlock(ClusterState state, ClearIndicesCacheRequest request, String[] concreteIndices) {
        return state.blocks().indicesBlockedException(this.projectResolver.getProjectId(), ClusterBlockLevel.METADATA_WRITE, concreteIndices);
    }
}

