/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.core.security.authz.permission;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.atomic.AtomicReference;
import java.util.stream.Collectors;
import org.apache.lucene.util.automaton.Automaton;
import org.elasticsearch.TransportVersion;
import org.elasticsearch.cluster.metadata.ProjectMetadata;
import org.elasticsearch.common.bytes.BytesReference;
import org.elasticsearch.common.cache.Cache;
import org.elasticsearch.common.cache.CacheBuilder;
import org.elasticsearch.common.settings.Setting;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.core.Nullable;
import org.elasticsearch.transport.TransportRequest;
import org.elasticsearch.xpack.core.security.authc.Authentication;
import org.elasticsearch.xpack.core.security.authz.AuthorizationEngine;
import org.elasticsearch.xpack.core.security.authz.RoleDescriptor;
import org.elasticsearch.xpack.core.security.authz.RoleDescriptorsIntersection;
import org.elasticsearch.xpack.core.security.authz.accesscontrol.IndicesAccessControl;
import org.elasticsearch.xpack.core.security.authz.permission.ApplicationPermission;
import org.elasticsearch.xpack.core.security.authz.permission.ClusterPermission;
import org.elasticsearch.xpack.core.security.authz.permission.FieldPermissionsCache;
import org.elasticsearch.xpack.core.security.authz.permission.FieldPermissionsDefinition;
import org.elasticsearch.xpack.core.security.authz.permission.IndicesPermission;
import org.elasticsearch.xpack.core.security.authz.permission.RemoteClusterPermissions;
import org.elasticsearch.xpack.core.security.authz.permission.RemoteIndicesPermission;
import org.elasticsearch.xpack.core.security.authz.permission.ResourcePrivilegesMap;
import org.elasticsearch.xpack.core.security.authz.permission.Role;
import org.elasticsearch.xpack.core.security.authz.permission.RunAsPermission;
import org.elasticsearch.xpack.core.security.authz.privilege.ApplicationPrivilegeDescriptor;
import org.elasticsearch.xpack.core.security.authz.privilege.ClusterPrivilege;
import org.elasticsearch.xpack.core.security.authz.restriction.WorkflowsRestriction;

public class SimpleRole
implements Role {
    public static final Setting<Integer> CACHE_SIZE_SETTING = Setting.intSetting((String)"xpack.security.authz.store.roles.has_privileges.cache.max_size", (int)1000, (Setting.Property[])new Setting.Property[]{Setting.Property.NodeScope});
    private final String[] names;
    private final ClusterPermission cluster;
    private final IndicesPermission indices;
    private final ApplicationPermission application;
    private final RunAsPermission runAs;
    private final RemoteIndicesPermission remoteIndicesPermission;
    private final RemoteClusterPermissions remoteClusterPermissions;
    private final WorkflowsRestriction workflowsRestriction;
    private final AtomicReference<Cache<AuthorizationEngine.PrivilegesToCheck, AuthorizationEngine.PrivilegesCheckResult>> hasPrivilegesCacheReference = new AtomicReference();

    SimpleRole(String[] names, ClusterPermission cluster, IndicesPermission indices, ApplicationPermission application, RunAsPermission runAs, RemoteIndicesPermission remoteIndicesPermission, RemoteClusterPermissions remoteClusterPermissions, WorkflowsRestriction workflowsRestriction) {
        this.names = names;
        this.cluster = Objects.requireNonNull(cluster);
        this.indices = Objects.requireNonNull(indices);
        this.application = Objects.requireNonNull(application);
        this.runAs = Objects.requireNonNull(runAs);
        this.remoteIndicesPermission = Objects.requireNonNull(remoteIndicesPermission);
        this.remoteClusterPermissions = Objects.requireNonNull(remoteClusterPermissions);
        this.workflowsRestriction = Objects.requireNonNull(workflowsRestriction);
    }

    @Override
    public String[] names() {
        return this.names;
    }

    @Override
    public ClusterPermission cluster() {
        return this.cluster;
    }

    @Override
    public IndicesPermission indices() {
        return this.indices;
    }

    @Override
    public ApplicationPermission application() {
        return this.application;
    }

    @Override
    public RunAsPermission runAs() {
        return this.runAs;
    }

    @Override
    public RemoteIndicesPermission remoteIndices() {
        return this.remoteIndicesPermission;
    }

    @Override
    public RemoteClusterPermissions remoteCluster() {
        return this.remoteClusterPermissions;
    }

    @Override
    public boolean hasWorkflowsRestriction() {
        return this.workflowsRestriction.hasWorkflows();
    }

    @Override
    public Role forWorkflow(String workflow) {
        if (this.workflowsRestriction.isWorkflowAllowed(workflow)) {
            return this;
        }
        return EMPTY_RESTRICTED_BY_WORKFLOW;
    }

    @Override
    public boolean hasFieldOrDocumentLevelSecurity() {
        return this.indices.hasFieldOrDocumentLevelSecurity();
    }

    @Override
    public IndicesPermission.IsResourceAuthorizedPredicate allowedIndicesMatcher(String action) {
        return this.indices.allowedIndicesMatcher(action);
    }

    @Override
    public Automaton allowedActionsMatcher(String index) {
        return this.indices.allowedActionsMatcher(index);
    }

    @Override
    public boolean checkRunAs(String runAsName) {
        return this.runAs.check(runAsName);
    }

    @Override
    public boolean checkIndicesAction(String action) {
        return this.indices.check(action);
    }

    @Override
    public boolean checkIndicesPrivileges(Set<String> checkForIndexPatterns, boolean allowRestrictedIndices, Set<String> checkForPrivileges, @Nullable ResourcePrivilegesMap.Builder resourcePrivilegesMapBuilder) {
        return this.indices.checkResourcePrivileges(checkForIndexPatterns, allowRestrictedIndices, checkForPrivileges, resourcePrivilegesMapBuilder);
    }

    @Override
    public boolean checkClusterAction(String action, TransportRequest request, Authentication authentication) {
        return this.cluster.check(action, request, authentication);
    }

    @Override
    public boolean grants(ClusterPrivilege clusterPrivilege) {
        return this.cluster.implies(clusterPrivilege.buildPermission(ClusterPermission.builder()).build());
    }

    @Override
    public boolean checkApplicationResourcePrivileges(String applicationName, Set<String> checkForResources, Set<String> checkForPrivilegeNames, Collection<ApplicationPrivilegeDescriptor> storedPrivileges, @Nullable ResourcePrivilegesMap.Builder resourcePrivilegesMapBuilder) {
        return this.application.checkResourcePrivileges(applicationName, checkForResources, checkForPrivilegeNames, storedPrivileges, resourcePrivilegesMapBuilder);
    }

    @Override
    public IndicesAccessControl authorize(String action, Set<String> requestedIndicesOrAliases, ProjectMetadata metadata, FieldPermissionsCache fieldPermissionsCache) {
        return this.indices.authorize(action, requestedIndicesOrAliases, metadata, fieldPermissionsCache);
    }

    @Override
    public RoleDescriptorsIntersection getRoleDescriptorsIntersectionForRemoteCluster(String remoteClusterAlias, TransportVersion remoteClusterVersion) {
        RemoteIndicesPermission remoteIndicesPermission = this.remoteIndicesPermission.forCluster(remoteClusterAlias);
        if (remoteIndicesPermission.remoteIndicesGroups().isEmpty() && !this.remoteClusterPermissions.hasAnyPrivileges(remoteClusterAlias)) {
            return RoleDescriptorsIntersection.EMPTY;
        }
        ArrayList<RoleDescriptor.IndicesPrivileges> indicesPrivileges = new ArrayList<RoleDescriptor.IndicesPrivileges>();
        for (RemoteIndicesPermission.RemoteIndicesGroup remoteIndicesGroup : remoteIndicesPermission.remoteIndicesGroups()) {
            for (IndicesPermission.Group indicesGroup : remoteIndicesGroup.indicesPermissionGroups()) {
                indicesPrivileges.add(SimpleRole.toIndicesPrivileges(indicesGroup));
            }
        }
        return new RoleDescriptorsIntersection(new RoleDescriptor("_remote_user", this.remoteClusterPermissions.collapseAndRemoveUnsupportedPrivileges(remoteClusterAlias, remoteClusterVersion), (RoleDescriptor.IndicesPrivileges[])indicesPrivileges.stream().sorted().toArray(RoleDescriptor.IndicesPrivileges[]::new), null, null, null, null, null));
    }

    private static Set<FieldPermissionsDefinition.FieldGrantExcludeGroup> getFieldGrantExcludeGroups(IndicesPermission.Group group) {
        if (group.getFieldPermissions().hasFieldLevelSecurity()) {
            List<FieldPermissionsDefinition> fieldPermissionsDefinitions = group.getFieldPermissions().getFieldPermissionsDefinitions();
            assert (fieldPermissionsDefinitions.size() == 1) : "a simple role can only have up to one field permissions definition per remote indices privilege";
            FieldPermissionsDefinition definition = fieldPermissionsDefinitions.get(0);
            return definition.getFieldGrantExcludeGroups();
        }
        return Collections.emptySet();
    }

    private static RoleDescriptor.IndicesPrivileges toIndicesPrivileges(IndicesPermission.Group indicesGroup) {
        Set<BytesReference> queries = indicesGroup.getQuery();
        Set<FieldPermissionsDefinition.FieldGrantExcludeGroup> fieldGrantExcludeGroups = SimpleRole.getFieldGrantExcludeGroups(indicesGroup);
        assert (queries == null || queries.size() <= 1) : "translation from an indices permission group to indices privileges supports up to one DLS query but multiple queries found";
        assert (fieldGrantExcludeGroups.size() <= 1) : "translation from an indices permission group to indices privileges supports up to one FLS field-grant-exclude group but multiple groups found";
        BytesReference query = queries == null || false == queries.iterator().hasNext() ? null : queries.iterator().next();
        RoleDescriptor.IndicesPrivileges.Builder builder = RoleDescriptor.IndicesPrivileges.builder().indices(Arrays.stream(indicesGroup.indices()).sorted().collect(Collectors.toList())).privileges(indicesGroup.privilege().name().stream().sorted().collect(Collectors.toList())).allowRestrictedIndices(indicesGroup.allowRestrictedIndices()).query(query);
        if (!fieldGrantExcludeGroups.isEmpty()) {
            FieldPermissionsDefinition.FieldGrantExcludeGroup fieldGrantExcludeGroup = fieldGrantExcludeGroups.iterator().next();
            builder.grantedFields(fieldGrantExcludeGroup.getGrantedFields()).deniedFields(fieldGrantExcludeGroup.getExcludedFields());
        }
        return builder.build();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SimpleRole that = (SimpleRole)o;
        return Arrays.equals(this.names, that.names) && this.cluster.equals(that.cluster) && this.indices.equals(that.indices) && this.application.equals(that.application) && this.runAs.equals(that.runAs);
    }

    public int hashCode() {
        int result = Objects.hash(this.cluster, this.indices, this.application, this.runAs);
        result = 31 * result + Arrays.hashCode(this.names);
        return result;
    }

    public String toString() {
        return this.getClass().getName() + "{" + String.join((CharSequence)",", this.names) + "}";
    }

    public void cacheHasPrivileges(Settings settings, AuthorizationEngine.PrivilegesToCheck privilegesToCheck, AuthorizationEngine.PrivilegesCheckResult privilegesCheckResult) throws ExecutionException {
        Cache<AuthorizationEngine.PrivilegesToCheck, AuthorizationEngine.PrivilegesCheckResult> cache = this.hasPrivilegesCacheReference.get();
        if (cache == null) {
            CacheBuilder cacheBuilder = CacheBuilder.builder();
            int cacheSize = (Integer)CACHE_SIZE_SETTING.get(settings);
            if (cacheSize >= 0) {
                cacheBuilder.setMaximumWeight((long)cacheSize);
            }
            this.hasPrivilegesCacheReference.compareAndSet(null, (Cache<AuthorizationEngine.PrivilegesToCheck, AuthorizationEngine.PrivilegesCheckResult>)cacheBuilder.build());
            cache = this.hasPrivilegesCacheReference.get();
        }
        cache.computeIfAbsent((Object)privilegesToCheck, ignore -> privilegesCheckResult);
    }

    public AuthorizationEngine.PrivilegesCheckResult checkPrivilegesWithCache(AuthorizationEngine.PrivilegesToCheck privilegesToCheck) {
        Cache<AuthorizationEngine.PrivilegesToCheck, AuthorizationEngine.PrivilegesCheckResult> cache = this.hasPrivilegesCacheReference.get();
        if (cache == null) {
            return null;
        }
        return (AuthorizationEngine.PrivilegesCheckResult)cache.get((Object)privilegesToCheck);
    }

    Cache<AuthorizationEngine.PrivilegesToCheck, AuthorizationEngine.PrivilegesCheckResult> getHasPrivilegesCache() {
        return this.hasPrivilegesCacheReference.get();
    }
}

