/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.core.security.authc;

import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.lucene.util.SetOnce;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.common.util.concurrent.ThreadContext;
import org.elasticsearch.license.XPackLicenseState;
import org.elasticsearch.xpack.core.security.authc.Authentication;
import org.elasticsearch.xpack.core.security.authc.AuthenticationResult;
import org.elasticsearch.xpack.core.security.authc.AuthenticationToken;
import org.elasticsearch.xpack.core.security.authc.RealmConfig;
import org.elasticsearch.xpack.core.security.user.User;

public abstract class Realm
implements Comparable<Realm> {
    protected final Logger logger = LogManager.getLogger(this.getClass());
    protected final RealmConfig config;
    private final SetOnce<Authentication.RealmRef> realmRef = new SetOnce();

    public Realm(RealmConfig config) {
        this.config = config;
    }

    public String type() {
        return this.config.type();
    }

    public String name() {
        return this.config.name();
    }

    public int order() {
        return this.config.order();
    }

    public Map<String, List<String>> getAuthenticationFailureHeaders() {
        return Collections.singletonMap("WWW-Authenticate", Collections.singletonList("Basic realm=\"security\", charset=\"UTF-8\""));
    }

    @Override
    public final int compareTo(Realm other) {
        int result = Integer.compare(this.order(), other.order());
        if (result == 0) {
            result = this.name().compareTo(other.name());
        }
        return result;
    }

    public abstract boolean supports(AuthenticationToken var1);

    public abstract AuthenticationToken token(ThreadContext var1);

    public abstract void authenticate(AuthenticationToken var1, ActionListener<AuthenticationResult<User>> var2);

    public abstract void lookupUser(String var1, ActionListener<User> var2);

    public void usageStats(ActionListener<Map<String, Object>> listener) {
        HashMap<String, Object> stats = new HashMap<String, Object>();
        stats.put("name", this.name());
        stats.put("order", this.order());
        listener.onResponse(stats);
    }

    public void setRealmRef(Authentication.RealmRef realmRef) {
        this.realmRef.set((Object)realmRef);
    }

    public Authentication.RealmRef realmRef() {
        Authentication.RealmRef realmRef = (Authentication.RealmRef)this.realmRef.get();
        if (realmRef == null) {
            throw new IllegalStateException("Realm [" + String.valueOf(this) + "] not fully configured");
        }
        return realmRef;
    }

    public String toString() {
        if (this.realmRef.get() != null && ((Authentication.RealmRef)this.realmRef.get()).getDomain() != null) {
            return this.config.type() + "/" + this.config.name() + "/" + ((Authentication.RealmRef)this.realmRef.get()).getDomain().name();
        }
        return this.config.type() + "/" + this.config.name();
    }

    public void initialize(Iterable<Realm> realms, XPackLicenseState licenseState) {
    }

    public static interface Factory {
        public Realm create(RealmConfig var1) throws Exception;
    }
}

