/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.gradle.util;

import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import org.elasticsearch.gradle.OS;
import org.elasticsearch.gradle.Version;
import org.gradle.api.logging.Logger;
import org.gradle.api.logging.Logging;

public final class OsUtils {
    private static final Logger LOGGER = Logging.getLogger(OsUtils.class);

    private OsUtils() {
    }

    public static boolean jdkIsIncompatibleWithOS(Version version) {
        return version.after("0.0.0") && version.onOrBefore("8.10.4") && OsUtils.isUbuntu2404OrLater();
    }

    private static boolean isUbuntu2404OrLater() {
        try {
            if (OS.current() != OS.LINUX) {
                return false;
            }
            String osKernelString = System.getProperty("os.version");
            Version kernelVersion = Version.fromString(osKernelString, Version.Mode.RELAXED);
            if (kernelVersion.onOrAfter("6.14.0")) {
                return true;
            }
            Path osRelease = Path.of("/etc/os-release", new String[0]);
            if (!Files.exists(osRelease, new LinkOption[0])) {
                return false;
            }
            String content = Files.readString(osRelease);
            boolean isUbuntu = content.contains("ID=ubuntu");
            if (!isUbuntu) {
                return false;
            }
            String versionLine = content.lines().filter(line -> line.startsWith("VERSION_ID=")).findFirst().orElse("");
            if (versionLine.isEmpty()) {
                return false;
            }
            String version = versionLine.substring("VERSION_ID=".length()).replace("\"", "");
            String[] parts = version.split("\\.");
            if (parts.length >= 2) {
                int major = Integer.parseInt(parts[0]);
                int minor = Integer.parseInt(parts[1]);
                return major > 24 || major == 24 && minor >= 4;
            }
            return false;
        }
        catch (Exception e) {
            LOGGER.debug("Failed to detect Ubuntu version", (Throwable)e);
            return false;
        }
    }
}

