/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.gradle.plugin;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.PropertyNamingStrategies;
import com.fasterxml.jackson.databind.SerializationFeature;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.Writer;
import java.nio.charset.StandardCharsets;
import java.nio.file.FileVisitResult;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.attribute.BasicFileAttributes;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.jar.Manifest;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.zip.ZipEntry;
import org.gradle.api.DefaultTask;
import org.gradle.api.file.FileCollection;
import org.gradle.api.file.RegularFile;
import org.gradle.api.file.RegularFileProperty;
import org.gradle.api.provider.Property;
import org.gradle.api.tasks.CacheableTask;
import org.gradle.api.tasks.Classpath;
import org.gradle.api.tasks.Input;
import org.gradle.api.tasks.Optional;
import org.gradle.api.tasks.OutputFile;
import org.gradle.api.tasks.TaskAction;
import org.jetbrains.annotations.NotNull;
import org.objectweb.asm.ClassReader;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.ModuleVisitor;

@CacheableTask
public abstract class GenerateTestBuildInfoTask
extends DefaultTask {
    public static final String DESCRIPTION = "generates plugin test dependencies file";
    public static final String META_INF_VERSIONS_PREFIX = "META-INF/versions/";
    public static final String JAR_DESCRIPTOR_SUFFIX = ".jar";

    public GenerateTestBuildInfoTask() {
        this.setDescription(DESCRIPTION);
    }

    @Input
    @Optional
    public abstract Property<String> getModuleName();

    @Input
    public abstract Property<String> getComponentName();

    @Classpath
    public abstract Property<FileCollection> getCodeLocations();

    @OutputFile
    public abstract RegularFileProperty getOutputFile();

    @TaskAction
    public void generatePropertiesFile() throws IOException {
        Path outputFile = ((RegularFile)this.getOutputFile().get()).getAsFile().toPath();
        Files.createDirectories(outputFile.getParent(), new FileAttribute[0]);
        try (BufferedWriter writer = Files.newBufferedWriter(outputFile, StandardCharsets.UTF_8, new OpenOption[0]);){
            ObjectMapper mapper = new ObjectMapper().configure(SerializationFeature.INDENT_OUTPUT, true).setPropertyNamingStrategy(PropertyNamingStrategies.SNAKE_CASE);
            mapper.writeValue((Writer)writer, (Object)new OutputFileContents((String)this.getComponentName().get(), this.buildLocationList()));
        }
    }

    private List<Location> buildLocationList() throws IOException {
        ArrayList<Location> locations = new ArrayList<Location>();
        for (File file : ((FileCollection)this.getCodeLocations().get()).getFiles()) {
            if (!file.exists()) continue;
            if (file.getName().endsWith(JAR_DESCRIPTOR_SUFFIX)) {
                this.extractLocationsFromJar(file, locations);
                continue;
            }
            if (file.isDirectory()) {
                this.extractLocationsFromDirectory(file, locations);
                continue;
            }
            throw new IllegalArgumentException("unrecognized classpath entry: " + String.valueOf(file));
        }
        return List.copyOf(locations);
    }

    private void extractLocationsFromJar(File file, List<Location> locations) throws IOException {
        try (JarFile jarFile = new JarFile(file);){
            java.util.Optional<String> className = this.extractClassNameFromJar(jarFile);
            if (className.isPresent()) {
                String moduleName = this.extractModuleNameFromJar(file, jarFile);
                locations.add(new Location(moduleName, className.get()));
            }
        }
    }

    private java.util.Optional<String> extractClassNameFromJar(JarFile jarFile) {
        return jarFile.stream().filter(je -> !je.getName().startsWith("META-INF") && !je.getName().equals("module-info.class") && !je.getName().contains("$") && je.getName().endsWith(".class")).findFirst().map(ZipEntry::getName);
    }

    private String extractModuleNameFromJar(File file, JarFile jarFile) throws IOException {
        StringBuilder dir;
        String moduleName = null;
        if (jarFile.isMultiRelease() && (dir = GenerateTestBuildInfoTask.versionDirectoryIfExists(jarFile)) != null) {
            dir.append("/module-info.class");
            moduleName = this.getModuleNameFromModuleInfoFile(dir.toString(), jarFile);
        }
        if (moduleName == null) {
            moduleName = this.getModuleNameFromModuleInfoFile("module-info.class", jarFile);
        }
        if (moduleName == null) {
            moduleName = GenerateTestBuildInfoTask.getAutomaticModuleNameFromManifest(jarFile);
        }
        if (moduleName == null) {
            moduleName = GenerateTestBuildInfoTask.deriveModuleNameFromJarFileName(file);
        }
        return moduleName;
    }

    private static StringBuilder versionDirectoryIfExists(JarFile jarFile) {
        Comparator numericOrder = Integer::compareTo;
        List<Integer> versions = jarFile.stream().filter(je -> je.getName().startsWith(META_INF_VERSIONS_PREFIX) && je.getName().endsWith("/module-info.class")).map(je -> Integer.parseInt(je.getName().substring(META_INF_VERSIONS_PREFIX.length(), je.getName().length() - META_INF_VERSIONS_PREFIX.length()))).sorted(numericOrder.reversed()).toList();
        int major = Runtime.version().feature();
        StringBuilder path = new StringBuilder(META_INF_VERSIONS_PREFIX);
        for (int version : versions) {
            if (version > major) continue;
            return path.append(version);
        }
        return null;
    }

    private String getModuleNameFromModuleInfoFile(String moduleInfoFileName, JarFile jarFile) throws IOException {
        JarEntry moduleEntry = jarFile.getJarEntry(moduleInfoFileName);
        if (moduleEntry != null) {
            try (InputStream inputStream = jarFile.getInputStream(moduleEntry);){
                String string = this.extractModuleNameFromModuleInfo(inputStream);
                return string;
            }
        }
        return null;
    }

    private static String getAutomaticModuleNameFromManifest(JarFile jarFile) throws IOException {
        JarEntry manifestEntry = jarFile.getJarEntry("META-INF/MANIFEST.MF");
        if (manifestEntry != null) {
            try (InputStream inputStream = jarFile.getInputStream(manifestEntry);){
                Manifest manifest = new Manifest(inputStream);
                String amn = manifest.getMainAttributes().getValue("Automatic-Module-Name");
                if (amn != null) {
                    String string = amn;
                    return string;
                }
            }
        }
        return null;
    }

    @NotNull
    private static String deriveModuleNameFromJarFileName(File jarFile) {
        String jn = jarFile.getName().substring(0, jarFile.getName().length() - JAR_DESCRIPTOR_SUFFIX.length());
        Matcher matcher = Pattern.compile("-(\\d+(\\.|$))").matcher(jn);
        if (matcher.find()) {
            jn = jn.substring(0, matcher.start());
        }
        jn = jn.replaceAll("[^A-Za-z0-9]", ".");
        return jn;
    }

    private void extractLocationsFromDirectory(File dir, List<Location> locations) throws IOException {
        String className = this.extractClassNameFromDirectory(dir);
        String moduleName = this.extractModuleNameFromDirectory(dir);
        if (className != null && moduleName != null) {
            locations.add(new Location(moduleName, className));
        }
    }

    private String extractClassNameFromDirectory(final File dir) throws IOException {
        var visitor = new SimpleFileVisitor<Path>(this){
            String result = null;

            @Override
            @NotNull
            public FileVisitResult visitFile(@NotNull Path candidate, @NotNull BasicFileAttributes attrs) {
                String name = candidate.getFileName().toString();
                if (name.endsWith(".class") && !(name.equals("module-info.class") || name.contains("$"))) {
                    this.result = candidate.toAbsolutePath().toString().substring(dir.getAbsolutePath().length() + 1).replace(File.separatorChar, '/');
                    return FileVisitResult.TERMINATE;
                }
                return FileVisitResult.CONTINUE;
            }
        };
        Files.walkFileTree(dir.toPath(), visitor);
        return visitor.result;
    }

    private String extractModuleNameFromDirectory(File dir) throws IOException {
        var visitor = new SimpleFileVisitor<Path>(){
            private String result;
            {
                this.result = (String)GenerateTestBuildInfoTask.this.getModuleName().getOrNull();
            }

            @Override
            @NotNull
            public FileVisitResult visitFile(@NotNull Path candidate, @NotNull BasicFileAttributes attrs) throws IOException {
                String name = candidate.getFileName().toString();
                if (name.equals("module-info.class")) {
                    try (FileInputStream inputStream = new FileInputStream(candidate.toFile());){
                        this.result = GenerateTestBuildInfoTask.this.extractModuleNameFromModuleInfo(inputStream);
                        FileVisitResult fileVisitResult = FileVisitResult.TERMINATE;
                        return fileVisitResult;
                    }
                }
                return FileVisitResult.CONTINUE;
            }
        };
        Files.walkFileTree(dir.toPath(), visitor);
        return visitor.result;
    }

    private String extractModuleNameFromModuleInfo(InputStream inputStream) throws IOException {
        final String[] moduleName = new String[1];
        ClassReader cr = new ClassReader(inputStream);
        cr.accept(new ClassVisitor(this, 589824){

            public ModuleVisitor visitModule(String name, int access, String version) {
                moduleName[0] = name;
                return super.visitModule(name, access, version);
            }
        }, 589824);
        return moduleName[0];
    }

    record OutputFileContents(String component, List<Location> locations) {
    }

    record Location(String module, String representativeClass) {
    }
}

