/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.eventhubs;

import java.net.PasswordAuthentication;
import java.net.Proxy;
import java.util.Arrays;
import java.util.Objects;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ProxyConfiguration
implements AutoCloseable {
    private static final Logger LOGGER = LoggerFactory.getLogger(ProxyConfiguration.class);
    private final Proxy proxyAddress;
    private final ProxyAuthenticationType authentication;
    private final PasswordAuthentication credentials;
    public static final ProxyConfiguration SYSTEM_DEFAULTS = new ProxyConfiguration();

    private ProxyConfiguration() {
        this.authentication = null;
        this.credentials = null;
        this.proxyAddress = null;
    }

    public ProxyConfiguration(ProxyAuthenticationType authentication, Proxy proxyAddress, String username, String password) {
        Objects.requireNonNull(authentication, "'authentication' cannot be null.");
        this.proxyAddress = proxyAddress;
        this.authentication = authentication;
        if (username != null && password != null) {
            this.credentials = new PasswordAuthentication(username, password.toCharArray());
        } else {
            if (LOGGER.isInfoEnabled()) {
                LOGGER.info("username or password is null. Using system-wide authentication.");
            }
            this.credentials = null;
        }
    }

    public Proxy proxyAddress() {
        return this.proxyAddress;
    }

    public PasswordAuthentication credentials() {
        return this.credentials;
    }

    public ProxyAuthenticationType authentication() {
        return this.authentication;
    }

    public boolean hasUserDefinedCredentials() {
        return this.credentials != null;
    }

    public boolean isProxyAddressConfigured() {
        return this.proxyAddress != null && this.proxyAddress.address() != null;
    }

    @Override
    public void close() {
        if (this.credentials != null) {
            Arrays.fill(this.credentials.getPassword(), '\u0000');
        }
    }

    public static enum ProxyAuthenticationType {
        NONE,
        BASIC,
        DIGEST;

    }
}

