/*
 * Decompiled with CFR 0.152.
 */
package org.logstash.snmp.mib;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.io.JsonStringEncoder;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializationFeature;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.logstash.snmp.mib.FileUtils;
import org.logstash.snmp.mib.InvalidMibFileException;
import org.logstash.snmp.mib.MibReader;
import org.logstash.snmp.mib.OidData;
import org.snmp4j.smi.OID;

class SmilibPythonMibReader
implements MibReader {
    private static final Logger logger = LogManager.getLogger(SmilibPythonMibReader.class);
    static final String FILE_EXTENSION = "dic";
    private static final String TRIPLE_QUOTED_STRING_PATTERN = "((\\\"\\\"\\\")([\\w\\W]*?)(\\\"\\\"\\\"))";
    private static final Map<String, String> CONTENT_REPLACE_TOKENS = Map.of(": (", ": [", "),\n", "],\n");
    private static final Pattern CONTENT_REPLACE_PATTERN = Pattern.compile(String.format("(%s|%s)", SmilibPythonMibReader.createContentReplaceTokensPattern(), "((\\\"\\\"\\\")([\\w\\W]*?)(\\\"\\\"\\\"))"));
    private static final ObjectMapper MAPPER = new ObjectMapper().enable(new JsonParser.Feature[]{JsonParser.Feature.ALLOW_TRAILING_COMMA}).enable(new JsonParser.Feature[]{JsonParser.Feature.ALLOW_COMMENTS}).enable(new JsonParser.Feature[]{JsonParser.Feature.ALLOW_YAML_COMMENTS}).enable(new JsonParser.Feature[]{JsonParser.Feature.ALLOW_UNQUOTED_CONTROL_CHARS}).disable(SerializationFeature.FAIL_ON_EMPTY_BEANS);

    SmilibPythonMibReader() {
    }

    private static String createContentReplaceTokensPattern() {
        return CONTENT_REPLACE_TOKENS.keySet().stream().map(Pattern::quote).collect(Collectors.joining("|"));
    }

    @Override
    public void read(Collection<Path> paths, BiConsumer<OID, OidData> consumer) throws InvalidMibFileException {
        for (Path path : paths) {
            JsonNode jsonNode;
            String content;
            try {
                content = this.sanitize(Files.readString(path));
            }
            catch (Exception e) {
                throw new InvalidMibFileException(String.format("Error reading MIB file: %s", path), e);
            }
            try {
                jsonNode = MAPPER.readTree(content);
            }
            catch (Exception e) {
                throw new InvalidMibFileException(String.format("Error parsing MIB file: %s", path), e);
            }
            JsonNode nodes = jsonNode.get("nodes");
            if (nodes == null) {
                logger.warn("The MIB file `{}` does not contain any node definition. Skipping", (Object)path);
                continue;
            }
            Iterator it = nodes.fields();
            while (it.hasNext()) {
                Map.Entry property = (Map.Entry)it.next();
                this.readNode(path, (String)property.getKey(), (JsonNode)property.getValue(), consumer);
            }
            JsonNode notifications = jsonNode.get("notifications");
            if (notifications == null) continue;
            Iterator it2 = notifications.fields();
            while (it2.hasNext()) {
                Map.Entry property = (Map.Entry)it2.next();
                this.readNode(path, (String)property.getKey(), (JsonNode)property.getValue(), consumer);
            }
        }
    }

    private void readNode(Path path, String nodeName, JsonNode node, BiConsumer<OID, OidData> consumer) {
        OID oid;
        JsonNode oidNode = node.get("oid");
        if (oidNode == null) {
            logger.warn("The MIB file `{}` node `{}` has no defined OID. Skipping", (Object)path, (Object)nodeName);
            return;
        }
        try {
            oid = new OID(oidNode.textValue());
        }
        catch (RuntimeException e) {
            logger.warn("The MIB file `{}` node `{}` has an invalid OID value `{}`. Skipping", (Object)path, (Object)nodeName, (Object)oidNode.textValue());
            return;
        }
        String nodeType = Optional.ofNullable(node.get("nodetype")).map(JsonNode::textValue).orElse("node");
        String moduleName = Optional.ofNullable(node.get("moduleName")).map(JsonNode::textValue).orElseGet(() -> FileUtils.getFileNameWithoutExtension(path));
        consumer.accept(oid, new OidData(nodeType, nodeName, moduleName));
    }

    private String sanitize(String content) {
        String mibDictionary = content.substring(content.indexOf("MIB = ") + 6);
        Matcher matcher = CONTENT_REPLACE_PATTERN.matcher(mibDictionary);
        StringBuilder sb = new StringBuilder();
        while (matcher.find()) {
            if (CONTENT_REPLACE_TOKENS.containsKey(matcher.group(1))) {
                matcher.appendReplacement(sb, CONTENT_REPLACE_TOKENS.get(matcher.group(1)));
            }
            if (matcher.groupCount() <= 3 || !"\"\"\"".equals(matcher.group(3))) continue;
            try {
                char[] chars = JsonStringEncoder.getInstance().quoteAsString(matcher.group(4));
                matcher.appendReplacement(sb, Matcher.quoteReplacement("\"" + new String(chars) + "\""));
            }
            catch (Exception e) {
                throw new InvalidMibFileException(e);
            }
        }
        matcher.appendTail(sb);
        return sb.toString();
    }
}

