/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.impl.sql.compile;

import org.apache.derby.catalog.types.AggregateAliasInfo;
import org.apache.derby.iapi.services.context.ContextManager;
import org.apache.derby.iapi.services.loader.ClassFactory;
import org.apache.derby.iapi.sql.compile.CompilerContext;
import org.apache.derby.iapi.sql.compile.TypeCompilerFactory;
import org.apache.derby.iapi.sql.dictionary.AliasDescriptor;
import org.apache.derby.iapi.types.DataTypeDescriptor;
import org.apache.derby.iapi.types.JSQLType;
import org.apache.derby.impl.sql.compile.AggregateDefinition;
import org.apache.derby.impl.sql.compile.MethodCallNode;
import org.apache.derby.impl.sql.compile.QueryTreeNode;
import org.apache.derby.impl.sql.compile.StaticMethodCallNode;
import org.apache.derby.impl.sql.compile.ValueNode;
import org.apache.derby.shared.common.error.StandardException;

class UserAggregateDefinition
implements AggregateDefinition {
    private static final int INPUT_TYPE = 0;
    private static final int RETURN_TYPE = 1;
    private static final int AGGREGATOR_TYPE = 2;
    private static final int AGGREGATOR_PARAM_COUNT = 3;
    private static final String DERBY_BYTE_ARRAY_NAME = "byte[]";
    private AliasDescriptor _alias;

    public UserAggregateDefinition(AliasDescriptor alias) {
        this._alias = alias;
    }

    public AliasDescriptor getAliasDescriptor() {
        return this._alias;
    }

    @Override
    public final DataTypeDescriptor getAggregator(DataTypeDescriptor inputType, StringBuffer aggregatorClass) throws StandardException {
        try {
            CompilerContext cc = (CompilerContext)QueryTreeNode.getContext("CompilerContext");
            ClassFactory classFactory = cc.getClassFactory();
            TypeCompilerFactory tcf = cc.getTypeCompilerFactory();
            Class derbyAggregatorInterface = classFactory.loadApplicationClass("org.apache.derby.agg.Aggregator");
            Class userAggregatorClass = classFactory.loadApplicationClass(this._alias.getJavaClassName());
            Class[][] typeBounds = classFactory.getClassInspector().getTypeBounds(derbyAggregatorInterface, userAggregatorClass);
            if (typeBounds == null || typeBounds.length != 3 || typeBounds[0] == null || typeBounds[1] == null) {
                throw StandardException.newException((String)"42ZC4", (Object[])new Object[]{this._alias.getSchemaName(), this._alias.getName(), userAggregatorClass.getName()});
            }
            Class<?>[] genericParameterTypes = classFactory.getClassInspector().getGenericParameterTypes(derbyAggregatorInterface, userAggregatorClass);
            if (genericParameterTypes == null) {
                genericParameterTypes = new Class[3];
            }
            AggregateAliasInfo aai = (AggregateAliasInfo)this._alias.getAliasInfo();
            DataTypeDescriptor expectedInputType = DataTypeDescriptor.getType(aai.getForType());
            DataTypeDescriptor expectedReturnType = DataTypeDescriptor.getType(aai.getReturnType());
            Class<?> expectedInputClass = this.getJavaClass(classFactory, expectedInputType);
            Class<?> expectedReturnClass = this.getJavaClass(classFactory, expectedReturnType);
            if (!tcf.getTypeCompiler(expectedInputType.getTypeId()).storable(inputType.getTypeId(), classFactory)) {
                return null;
            }
            Class[] inputBounds = typeBounds[0];
            for (int i = 0; i < inputBounds.length; ++i) {
                this.vetCompatibility(inputBounds[i], expectedInputClass, "42ZC6");
            }
            if (genericParameterTypes[0] != null) {
                this.vetCompatibility(genericParameterTypes[0], expectedInputClass, "42ZC6");
            }
            Class[] returnBounds = typeBounds[1];
            for (int i = 0; i < returnBounds.length; ++i) {
                this.vetCompatibility(returnBounds[i], expectedReturnClass, "42ZC7");
            }
            if (genericParameterTypes[1] != null) {
                this.vetCompatibility(genericParameterTypes[1], expectedReturnClass, "42ZC7");
            }
            aggregatorClass.append("org.apache.derby.impl.sql.execute.UserDefinedAggregator");
            return expectedReturnType;
        }
        catch (ClassNotFoundException cnfe) {
            throw this.aggregatorInstantiation(cnfe);
        }
    }

    private void vetCompatibility(Class<?> actualClass, Class<?> expectedClass, String sqlState) throws StandardException {
        if (!actualClass.isAssignableFrom(expectedClass)) {
            throw StandardException.newException((String)sqlState, (Object[])new Object[]{this._alias.getSchemaName(), this._alias.getName(), expectedClass.toString(), actualClass.toString()});
        }
    }

    final ValueNode castInputValue(ValueNode inputValue, ContextManager cm) throws StandardException {
        DataTypeDescriptor actualInputType;
        AggregateAliasInfo aai = (AggregateAliasInfo)this._alias.getAliasInfo();
        DataTypeDescriptor expectedInputType = DataTypeDescriptor.getType(aai.getForType());
        if (expectedInputType.isExactTypeAndLengthMatch(actualInputType = inputValue.getTypeServices())) {
            return null;
        }
        return StaticMethodCallNode.makeCast(inputValue, expectedInputType, cm);
    }

    private Class<?> getJavaClass(ClassFactory classFactory, DataTypeDescriptor dtd) throws StandardException, ClassNotFoundException {
        JSQLType jsqlType = new JSQLType(dtd);
        String javaClassName = MethodCallNode.getObjectTypeName(jsqlType, null);
        if (DERBY_BYTE_ARRAY_NAME.equals(javaClassName)) {
            javaClassName = byte[].class.getName();
        }
        return classFactory.loadApplicationClass(javaClassName);
    }

    private StandardException aggregatorInstantiation(Throwable t) {
        return StandardException.newException((String)"42ZC8", (Throwable)t, (Object[])new Object[]{this._alias.getJavaClassName(), this._alias.getSchemaName(), this._alias.getName(), t.getMessage()});
    }
}

