/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.maven.polyglot;

import java.io.IOException;
import java.io.InputStream;
import java.util.Properties;
import org.codehaus.plexus.util.IOUtil;

public class Constants {
    private static Properties polyglotProperties = Constants.getPolyglotMavenProperties();

    public static String getGroupId() {
        return polyglotProperties.getProperty("groupId");
    }

    public static String getArtifactId(String postfix) {
        return String.valueOf(polyglotProperties.getProperty("prefix")) + postfix;
    }

    public static String getVersion() {
        return polyglotProperties.getProperty("version");
    }

    public static String getGAV(String postfix) {
        return String.valueOf(Constants.getGroupId()) + ":" + Constants.getArtifactId(postfix) + ":" + Constants.getVersion();
    }

    public static Properties getPolyglotMavenProperties() {
        Properties properties;
        block6: {
            properties = new Properties();
            InputStream resourceAsStream = null;
            try {
                try {
                    resourceAsStream = Constants.class.getClassLoader().getResourceAsStream("maven-polyglot.properties");
                    if (resourceAsStream != null) {
                        properties.load(resourceAsStream);
                    }
                }
                catch (IOException e) {
                    System.err.println("Unable determine version from JAR file: " + e.getMessage());
                    IOUtil.close((InputStream)resourceAsStream);
                    break block6;
                }
            }
            catch (Throwable throwable) {
                IOUtil.close(resourceAsStream);
                throw throwable;
            }
            IOUtil.close((InputStream)resourceAsStream);
        }
        return properties;
    }
}

