/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.rest.serializer;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.BeanDescription;
import com.fasterxml.jackson.databind.DeserializationConfig;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.deser.BeanDeserializerModifier;
import com.fasterxml.jackson.databind.deser.ResolvableDeserializer;
import com.fasterxml.jackson.databind.deser.std.StdDeserializer;
import com.fasterxml.jackson.databind.module.SimpleModule;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.google.common.reflect.TypeToken;
import com.microsoft.azure.management.apigeneration.Beta;
import java.io.IOException;
import java.lang.reflect.Field;

@Beta(value=Beta.SinceVersion.V1_7_0)
public final class AdditionalPropertiesDeserializer
extends StdDeserializer<Object>
implements ResolvableDeserializer {
    private final JsonDeserializer<?> defaultDeserializer;
    private final ObjectMapper mapper;

    protected AdditionalPropertiesDeserializer(Class<?> vc, JsonDeserializer<?> defaultDeserializer, ObjectMapper mapper) {
        super(vc);
        this.defaultDeserializer = defaultDeserializer;
        this.mapper = mapper;
    }

    public static SimpleModule getModule(final ObjectMapper mapper) {
        SimpleModule module = new SimpleModule();
        module.setDeserializerModifier(new BeanDeserializerModifier(){

            public JsonDeserializer<?> modifyDeserializer(DeserializationConfig config, BeanDescription beanDesc, JsonDeserializer<?> deserializer) {
                for (Class c : TypeToken.of((Class)beanDesc.getBeanClass()).getTypes().classes().rawTypes()) {
                    Field[] fields;
                    for (Field field : fields = c.getDeclaredFields()) {
                        JsonProperty property;
                        if (!"additionalProperties".equalsIgnoreCase(field.getName()) || (property = field.getAnnotation(JsonProperty.class)) == null || !property.value().isEmpty()) continue;
                        return new AdditionalPropertiesDeserializer(beanDesc.getBeanClass(), deserializer, mapper);
                    }
                }
                return deserializer;
            }
        });
        return module;
    }

    public Object deserialize(JsonParser jp, DeserializationContext ctxt) throws IOException {
        ObjectNode root = (ObjectNode)this.mapper.readTree(jp);
        ObjectNode copy = root.deepCopy();
        Class tClass = this.defaultDeserializer.handledType();
        for (Class c : TypeToken.of((Class)tClass).getTypes().classes().rawTypes()) {
            Field[] fields;
            for (Field field : fields = c.getDeclaredFields()) {
                String key;
                JsonProperty property = field.getAnnotation(JsonProperty.class);
                if (property == null || (key = property.value().split("((?<!\\\\))\\.")[0]).isEmpty() || !copy.has(key)) continue;
                copy.remove(key);
            }
        }
        root.put("additionalProperties", (JsonNode)copy);
        JsonParser parser = new JsonFactory().createParser(root.toString());
        parser.nextToken();
        return this.defaultDeserializer.deserialize(parser, ctxt);
    }

    public void resolve(DeserializationContext ctxt) throws JsonMappingException {
        ((ResolvableDeserializer)this.defaultDeserializer).resolve(ctxt);
    }
}

