/*
 * Decompiled with CFR 0.152.
 */
package org.logstash.execution;

import java.util.Collection;
import java.util.concurrent.CopyOnWriteArraySet;
import org.jruby.Ruby;
import org.jruby.RubyBasicObject;
import org.jruby.RubyClass;
import org.jruby.anno.JRubyClass;
import org.jruby.anno.JRubyMethod;
import org.jruby.runtime.ThreadContext;
import org.jruby.runtime.builtin.IRubyObject;

@JRubyClass(name={"EventDispatcher"})
public final class EventDispatcherExt
extends RubyBasicObject {
    private static final long serialVersionUID = 1L;
    private final transient Collection<IRubyObject> listeners = new CopyOnWriteArraySet<IRubyObject>();
    private transient IRubyObject emitter;

    public EventDispatcherExt(Ruby runtime, RubyClass metaClass) {
        super(runtime, metaClass);
    }

    @JRubyMethod
    public EventDispatcherExt initialize(ThreadContext context, IRubyObject emitter) {
        this.emitter = emitter;
        return this;
    }

    @JRubyMethod
    public IRubyObject emitter() {
        return this.emitter;
    }

    @JRubyMethod(name={"add_listener"})
    public IRubyObject addListener(ThreadContext context, IRubyObject listener) {
        return this.listeners.add(listener) ? context.tru : context.fals;
    }

    @JRubyMethod(name={"remove_listener"})
    public IRubyObject removeListener(ThreadContext context, IRubyObject listener) {
        return this.listeners.remove(listener) ? context.tru : context.fals;
    }

    @JRubyMethod(name={"execute", "fire"}, required=1, rest=true)
    public IRubyObject fire(ThreadContext context, IRubyObject[] arguments) {
        String methodName = arguments[0].asJavaString();
        IRubyObject[] args = new IRubyObject[arguments.length];
        args[0] = this.emitter;
        System.arraycopy(arguments, 1, args, 1, arguments.length - 1);
        this.listeners.forEach(listener -> {
            if (listener.respondsTo(methodName)) {
                listener.callMethod(context, methodName, args);
            }
        });
        return context.nil;
    }
}

