/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.core.transform.transforms;

import java.io.IOException;
import java.util.Collections;
import java.util.Map;
import java.util.Objects;
import java.util.function.Consumer;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.elasticsearch.action.ActionRequestValidationException;
import org.elasticsearch.action.ValidateActions;
import org.elasticsearch.cluster.SimpleDiffable;
import org.elasticsearch.common.bytes.BytesReference;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.io.stream.Writeable;
import org.elasticsearch.common.xcontent.LoggingDeprecationHandler;
import org.elasticsearch.common.xcontent.XContentHelper;
import org.elasticsearch.index.query.AbstractQueryBuilder;
import org.elasticsearch.index.query.MatchAllQueryBuilder;
import org.elasticsearch.index.query.QueryBuilder;
import org.elasticsearch.xcontent.DeprecationHandler;
import org.elasticsearch.xcontent.NamedXContentRegistry;
import org.elasticsearch.xcontent.ToXContent;
import org.elasticsearch.xcontent.ToXContentObject;
import org.elasticsearch.xcontent.XContentBuilder;
import org.elasticsearch.xcontent.XContentFactory;
import org.elasticsearch.xcontent.XContentParser;
import org.elasticsearch.xcontent.XContentParserConfiguration;
import org.elasticsearch.xcontent.XContentType;
import org.elasticsearch.xpack.core.deprecation.DeprecationIssue;
import org.elasticsearch.xpack.core.deprecation.LoggingDeprecationAccumulationHandler;

public class QueryConfig
implements SimpleDiffable<QueryConfig>,
Writeable,
ToXContentObject {
    private static final Logger logger = LogManager.getLogger(QueryConfig.class);
    private final Map<String, Object> source;
    private final QueryBuilder query;

    public static QueryConfig matchAll() {
        return new QueryConfig(Collections.singletonMap("match_all", Collections.emptyMap()), new MatchAllQueryBuilder());
    }

    public QueryConfig(Map<String, Object> source, QueryBuilder query) {
        this.source = Objects.requireNonNull(source);
        this.query = query;
    }

    public QueryConfig(StreamInput in) throws IOException {
        this.source = in.readGenericMap();
        this.query = in.readOptionalNamedWriteable(QueryBuilder.class);
    }

    @Override
    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.map(this.source);
        return builder;
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        out.writeGenericMap(this.source);
        out.writeOptionalNamedWriteable(this.query);
    }

    public QueryBuilder getQuery() {
        return this.query;
    }

    public static QueryConfig fromXContent(XContentParser parser, boolean lenient) throws IOException {
        NamedXContentRegistry registry = parser.getXContentRegistry();
        Map<String, Object> source = parser.mapOrdered();
        QueryBuilder query = null;
        try {
            query = QueryConfig.queryFromXContent(source, registry, LoggingDeprecationHandler.INSTANCE);
        }
        catch (Exception e) {
            if (lenient) {
                logger.warn("Failed to parse query for transform", (Throwable)e);
            }
            throw e;
        }
        return new QueryConfig(source, query);
    }

    private static QueryBuilder queryFromXContent(Map<String, Object> source, NamedXContentRegistry namedXContentRegistry, DeprecationHandler deprecationHandler) throws IOException {
        QueryBuilder query;
        XContentBuilder xContentBuilder = XContentFactory.jsonBuilder().map(source);
        try (XContentParser sourceParser = XContentHelper.createParserNotCompressed(XContentParserConfiguration.EMPTY.withRegistry(namedXContentRegistry).withDeprecationHandler(deprecationHandler), BytesReference.bytes(xContentBuilder), XContentType.JSON);){
            query = AbstractQueryBuilder.parseTopLevelQuery(sourceParser);
        }
        return query;
    }

    public int hashCode() {
        return Objects.hash(this.source, this.query);
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (other == null || this.getClass() != other.getClass()) {
            return false;
        }
        QueryConfig that = (QueryConfig)other;
        return Objects.equals(this.source, that.source) && Objects.equals(this.query, that.query);
    }

    public ActionRequestValidationException validate(ActionRequestValidationException validationException) {
        if (this.query == null) {
            validationException = ValidateActions.addValidationError("source.query must not be null", validationException);
        }
        return validationException;
    }

    public void checkForDeprecations(String id, NamedXContentRegistry namedXContentRegistry, Consumer<DeprecationIssue> onDeprecation) {
        LoggingDeprecationAccumulationHandler deprecationLogger = new LoggingDeprecationAccumulationHandler();
        try {
            QueryConfig.queryFromXContent(this.source, namedXContentRegistry, deprecationLogger);
        }
        catch (Exception e) {
            onDeprecation.accept(new DeprecationIssue(DeprecationIssue.Level.CRITICAL, "Transform [" + id + "]: Failed to parse query for transform", "https://ela.st/es-deprecation-8-transform-query-options", e.getMessage(), false, null));
        }
        deprecationLogger.getDeprecations().forEach(deprecationMessage -> onDeprecation.accept(new DeprecationIssue(DeprecationIssue.Level.CRITICAL, "Transform [" + id + "] uses deprecated query options", "https://ela.st/es-deprecation-8-transform-query-options", (String)deprecationMessage, false, null)));
    }
}

