/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.core.textstructure.action;

import java.io.IOException;
import java.util.Objects;
import org.elasticsearch.action.ActionRequestValidationException;
import org.elasticsearch.action.ActionType;
import org.elasticsearch.action.ValidateActions;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.xcontent.ParseField;
import org.elasticsearch.xpack.core.textstructure.action.AbstractFindStructureRequest;
import org.elasticsearch.xpack.core.textstructure.action.FindStructureResponse;

public class FindFieldStructureAction
extends ActionType<FindStructureResponse> {
    public static final FindFieldStructureAction INSTANCE = new FindFieldStructureAction();
    public static final String NAME = "cluster:monitor/text_structure/find_field_structure";

    private FindFieldStructureAction() {
        super(NAME);
    }

    public static class Request
    extends AbstractFindStructureRequest {
        public static final ParseField INDEX = new ParseField("index", new String[0]);
        public static final ParseField FIELD = new ParseField("field", new String[0]);
        private String index;
        private String field;

        public Request() {
        }

        public Request(StreamInput in) throws IOException {
            super(in);
            this.index = in.readString();
            this.field = in.readString();
        }

        public String getIndex() {
            return this.index;
        }

        public void setIndex(String index) {
            this.index = index;
        }

        public String getField() {
            return this.field;
        }

        public void setField(String field) {
            this.field = field;
        }

        @Override
        public ActionRequestValidationException validate() {
            ActionRequestValidationException validationException = super.validate();
            if (Strings.isNullOrEmpty(this.index)) {
                validationException = ValidateActions.addValidationError("index must be specified", validationException);
            }
            if (Strings.isNullOrEmpty(this.field)) {
                validationException = ValidateActions.addValidationError("field must be specified", validationException);
            }
            return validationException;
        }

        @Override
        public void writeTo(StreamOutput out) throws IOException {
            super.writeTo(out);
            out.writeString(this.index);
            out.writeString(this.field);
        }

        @Override
        public int hashCode() {
            return Objects.hash(super.hashCode(), this.field, this.index);
        }

        @Override
        public boolean equals(Object other) {
            if (this == other) {
                return true;
            }
            if (other == null || this.getClass() != other.getClass()) {
                return false;
            }
            Request that = (Request)other;
            return super.equals(other) && Objects.equals(this.index, that.index) && Objects.equals(this.field, that.field);
        }
    }
}

