/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.core.security.action.oidc;

import java.io.IOException;
import org.elasticsearch.action.ActionRequest;
import org.elasticsearch.action.ActionRequestValidationException;
import org.elasticsearch.action.ValidateActions;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;

public class OpenIdConnectAuthenticateRequest
extends ActionRequest {
    private String redirectUri;
    private String state;
    private String nonce;
    private String realm;

    public OpenIdConnectAuthenticateRequest() {
    }

    public OpenIdConnectAuthenticateRequest(StreamInput in) throws IOException {
        super(in);
        this.redirectUri = in.readString();
        this.state = in.readString();
        this.nonce = in.readString();
        this.realm = in.readOptionalString();
    }

    public String getRedirectUri() {
        return this.redirectUri;
    }

    public void setRedirectUri(String redirectUri) {
        this.redirectUri = redirectUri;
    }

    public String getState() {
        return this.state;
    }

    public void setState(String state) {
        this.state = state;
    }

    public String getNonce() {
        return this.nonce;
    }

    public void setNonce(String nonce) {
        this.nonce = nonce;
    }

    public String getRealm() {
        return this.realm;
    }

    public void setRealm(String realm) {
        this.realm = realm;
    }

    @Override
    public ActionRequestValidationException validate() {
        ActionRequestValidationException validationException = null;
        if (Strings.isNullOrEmpty(this.state)) {
            validationException = ValidateActions.addValidationError("state parameter is missing", validationException);
        }
        if (Strings.isNullOrEmpty(this.nonce)) {
            validationException = ValidateActions.addValidationError("nonce parameter is missing", validationException);
        }
        if (Strings.isNullOrEmpty(this.redirectUri)) {
            validationException = ValidateActions.addValidationError("redirect_uri parameter is missing", validationException);
        }
        return validationException;
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        super.writeTo(out);
        out.writeString(this.redirectUri);
        out.writeString(this.state);
        out.writeString(this.nonce);
        out.writeOptionalString(this.realm);
    }

    @Override
    public String toString() {
        return "{redirectUri=" + this.redirectUri + ", state=" + this.state + ", nonce=" + this.nonce + ", realm=" + this.realm + "}";
    }
}

