/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.core.ml.dataframe.evaluation.regression;

import java.io.IOException;
import java.text.MessageFormat;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.Optional;
import java.util.Set;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.util.set.Sets;
import org.elasticsearch.core.Nullable;
import org.elasticsearch.core.Tuple;
import org.elasticsearch.script.Script;
import org.elasticsearch.search.aggregations.AggregationBuilder;
import org.elasticsearch.search.aggregations.AggregationBuilders;
import org.elasticsearch.search.aggregations.InternalAggregations;
import org.elasticsearch.search.aggregations.PipelineAggregationBuilder;
import org.elasticsearch.search.aggregations.metrics.NumericMetricsAggregation;
import org.elasticsearch.xcontent.ConstructingObjectParser;
import org.elasticsearch.xcontent.ParseField;
import org.elasticsearch.xcontent.ToXContent;
import org.elasticsearch.xcontent.XContentBuilder;
import org.elasticsearch.xcontent.XContentParser;
import org.elasticsearch.xpack.core.ml.dataframe.analyses.Regression;
import org.elasticsearch.xpack.core.ml.dataframe.evaluation.EvaluationFields;
import org.elasticsearch.xpack.core.ml.dataframe.evaluation.EvaluationMetric;
import org.elasticsearch.xpack.core.ml.dataframe.evaluation.EvaluationMetricResult;
import org.elasticsearch.xpack.core.ml.dataframe.evaluation.EvaluationParameters;
import org.elasticsearch.xpack.core.ml.dataframe.evaluation.MlEvaluationNamedXContentProvider;
import org.elasticsearch.xpack.core.ml.dataframe.evaluation.regression.Regression;

public class MeanSquaredLogarithmicError
implements EvaluationMetric {
    public static final ParseField NAME = new ParseField(Regression.LossFunction.MSLE.toString(), new String[0]);
    public static final ParseField OFFSET = new ParseField("offset", new String[0]);
    private static final double DEFAULT_OFFSET = 1.0;
    private static final String PAINLESS_TEMPLATE = "def offset = {2};def diff = Math.log(doc[''{0}''].value + offset) - Math.log(doc[''{1}''].value + offset);return diff * diff;";
    private static final String AGG_NAME = "regression_" + NAME.getPreferredName();
    private static final ConstructingObjectParser<MeanSquaredLogarithmicError, Void> PARSER = new ConstructingObjectParser(NAME.getPreferredName(), true, args -> new MeanSquaredLogarithmicError((Double)args[0]));
    private final double offset;
    private EvaluationMetricResult result;

    private static String buildScript(Object ... args) {
        return new MessageFormat(PAINLESS_TEMPLATE, Locale.ROOT).format(args);
    }

    public static MeanSquaredLogarithmicError fromXContent(XContentParser parser) {
        return PARSER.apply(parser, null);
    }

    public MeanSquaredLogarithmicError(StreamInput in) throws IOException {
        this.offset = in.readDouble();
    }

    public MeanSquaredLogarithmicError(@Nullable Double offset) {
        this.offset = offset != null ? offset : 1.0;
    }

    @Override
    public String getName() {
        return NAME.getPreferredName();
    }

    @Override
    public Set<String> getRequiredFields() {
        return Sets.newHashSet(EvaluationFields.ACTUAL_FIELD.getPreferredName(), EvaluationFields.PREDICTED_FIELD.getPreferredName());
    }

    @Override
    public Tuple<List<AggregationBuilder>, List<PipelineAggregationBuilder>> aggs(EvaluationParameters parameters, EvaluationFields fields) {
        if (this.result != null) {
            return Tuple.tuple(Collections.emptyList(), Collections.emptyList());
        }
        String actualField = fields.getActualField();
        String predictedField = fields.getPredictedField();
        return Tuple.tuple(Arrays.asList(AggregationBuilders.avg(AGG_NAME).script(new Script(MeanSquaredLogarithmicError.buildScript(actualField, predictedField, this.offset)))), Collections.emptyList());
    }

    @Override
    public void process(InternalAggregations aggs) {
        NumericMetricsAggregation.SingleValue value = (NumericMetricsAggregation.SingleValue)aggs.get(AGG_NAME);
        this.result = value == null ? new Result(0.0) : new Result(value.value());
    }

    public Optional<EvaluationMetricResult> getResult() {
        return Optional.ofNullable(this.result);
    }

    @Override
    public String getWriteableName() {
        return MlEvaluationNamedXContentProvider.registeredMetricName(Regression.NAME, NAME);
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        out.writeDouble(this.offset);
    }

    @Override
    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject();
        builder.field(OFFSET.getPreferredName(), this.offset);
        builder.endObject();
        return builder;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        MeanSquaredLogarithmicError that = (MeanSquaredLogarithmicError)o;
        return this.offset == that.offset;
    }

    public int hashCode() {
        return Double.hashCode(this.offset);
    }

    static {
        PARSER.declareDouble(ConstructingObjectParser.optionalConstructorArg(), OFFSET);
    }

    public static class Result
    implements EvaluationMetricResult {
        private static final String VALUE = "value";
        private final double value;

        public Result(double value) {
            this.value = value;
        }

        public Result(StreamInput in) throws IOException {
            this.value = in.readDouble();
        }

        @Override
        public String getWriteableName() {
            return MlEvaluationNamedXContentProvider.registeredMetricName(Regression.NAME, NAME);
        }

        @Override
        public String getMetricName() {
            return NAME.getPreferredName();
        }

        public double getValue() {
            return this.value;
        }

        @Override
        public void writeTo(StreamOutput out) throws IOException {
            out.writeDouble(this.value);
        }

        @Override
        public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
            builder.startObject();
            builder.field(VALUE, this.value);
            builder.endObject();
            return builder;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Result other = (Result)o;
            return this.value == other.value;
        }

        public int hashCode() {
            return Double.hashCode(this.value);
        }
    }
}

