/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.core.inference.results;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.io.stream.Writeable;
import org.elasticsearch.common.xcontent.ChunkedToXContentHelper;
import org.elasticsearch.inference.InferenceResults;
import org.elasticsearch.inference.InferenceServiceResults;
import org.elasticsearch.xcontent.ToXContent;
import org.elasticsearch.xcontent.ToXContentObject;
import org.elasticsearch.xcontent.XContentBuilder;
import org.elasticsearch.xpack.core.inference.results.EmbeddingInt;
import org.elasticsearch.xpack.core.inference.results.LegacyTextEmbeddingResults;
import org.elasticsearch.xpack.core.inference.results.TextEmbedding;
import org.elasticsearch.xpack.core.inference.results.TextEmbeddingUtils;
import org.elasticsearch.xpack.core.ml.inference.results.MlTextEmbeddingResults;

public record InferenceTextEmbeddingByteResults(List<InferenceByteEmbedding> embeddings) implements InferenceServiceResults,
TextEmbedding
{
    public static final String NAME = "text_embedding_service_byte_results";
    public static final String TEXT_EMBEDDING_BYTES = "text_embedding_bytes";

    public InferenceTextEmbeddingByteResults(StreamInput in) throws IOException {
        this(in.readCollectionAsList(InferenceByteEmbedding::new));
    }

    @Override
    public int getFirstEmbeddingSize() {
        return TextEmbeddingUtils.getFirstEmbeddingSize(new ArrayList<EmbeddingInt>(this.embeddings));
    }

    @Override
    public Iterator<? extends ToXContent> toXContentChunked(ToXContent.Params params) {
        return ChunkedToXContentHelper.array(TEXT_EMBEDDING_BYTES, this.embeddings.iterator());
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        out.writeCollection(this.embeddings);
    }

    @Override
    public String getWriteableName() {
        return NAME;
    }

    @Override
    public List<? extends InferenceResults> transformToCoordinationFormat() {
        return this.embeddings.stream().map(embedding -> new MlTextEmbeddingResults(TEXT_EMBEDDING_BYTES, embedding.toDoubleArray(), false)).toList();
    }

    @Override
    public List<? extends InferenceResults> transformToLegacyFormat() {
        LegacyTextEmbeddingResults legacyEmbedding = new LegacyTextEmbeddingResults(this.embeddings.stream().map(embedding -> new LegacyTextEmbeddingResults.Embedding(embedding.toFloatArray())).toList());
        return List.of(legacyEmbedding);
    }

    @Override
    public Map<String, Object> asMap() {
        LinkedHashMap<String, Object> map = new LinkedHashMap<String, Object>();
        map.put(TEXT_EMBEDDING_BYTES, this.embeddings);
        return map;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        InferenceTextEmbeddingByteResults that = (InferenceTextEmbeddingByteResults)o;
        return Objects.equals(this.embeddings, that.embeddings);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.embeddings);
    }

    public record InferenceByteEmbedding(byte[] values) implements Writeable,
    ToXContentObject,
    EmbeddingInt
    {
        public static final String EMBEDDING = "embedding";

        public InferenceByteEmbedding(StreamInput in) throws IOException {
            this(in.readByteArray());
        }

        @Override
        public void writeTo(StreamOutput out) throws IOException {
            out.writeByteArray(this.values);
        }

        public static InferenceByteEmbedding of(List<Byte> embeddingValuesList) {
            byte[] embeddingValues = new byte[embeddingValuesList.size()];
            for (int i = 0; i < embeddingValuesList.size(); ++i) {
                embeddingValues[i] = embeddingValuesList.get(i);
            }
            return new InferenceByteEmbedding(embeddingValues);
        }

        @Override
        public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
            builder.startObject();
            builder.startArray(EMBEDDING);
            for (byte value : this.values) {
                builder.value(value);
            }
            builder.endArray();
            builder.endObject();
            return builder;
        }

        @Override
        public String toString() {
            return Strings.toString(this);
        }

        private float[] toFloatArray() {
            float[] floatArray = new float[this.values.length];
            for (int i = 0; i < this.values.length; ++i) {
                floatArray[i] = Byte.valueOf(this.values[i]).floatValue();
            }
            return floatArray;
        }

        private double[] toDoubleArray() {
            double[] doubleArray = new double[this.values.length];
            for (int i = 0; i < this.values.length; ++i) {
                doubleArray[i] = Byte.valueOf(this.values[i]).floatValue();
            }
            return doubleArray;
        }

        @Override
        public int getSize() {
            return this.values().length;
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            InferenceByteEmbedding embedding = (InferenceByteEmbedding)o;
            return Arrays.equals(this.values, embedding.values);
        }

        @Override
        public int hashCode() {
            return Arrays.hashCode(this.values);
        }
    }
}

