/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.core.ilm;

import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.elasticsearch.action.downsample.DownsampleConfig;
import org.elasticsearch.cluster.ClusterState;
import org.elasticsearch.cluster.metadata.IndexMetadata;
import org.elasticsearch.cluster.metadata.LifecycleExecutionState;
import org.elasticsearch.index.Index;
import org.elasticsearch.search.aggregations.bucket.histogram.DateHistogramInterval;
import org.elasticsearch.xpack.core.ilm.ClusterStateActionStep;
import org.elasticsearch.xpack.core.ilm.LifecycleExecutionStateUtils;
import org.elasticsearch.xpack.core.ilm.Step;

public class DownsamplePrepareLifeCycleStateStep
extends ClusterStateActionStep {
    private static final Logger LOGGER = LogManager.getLogger(DownsamplePrepareLifeCycleStateStep.class);
    public static final String NAME = "generate-downsampled-index-name";
    private final DateHistogramInterval fixedInterval;

    public DownsamplePrepareLifeCycleStateStep(Step.StepKey key, Step.StepKey nextStepKey, DateHistogramInterval fixedInterval) {
        super(key, nextStepKey);
        this.fixedInterval = fixedInterval;
    }

    @Override
    public ClusterState performAction(Index index, ClusterState clusterState) {
        IndexMetadata indexMetadata = clusterState.metadata().index(index);
        if (indexMetadata == null) {
            LOGGER.debug("[{}] lifecycle action for index [{}] executed but index no longer exists", (Object)this.getKey().action(), (Object)index.getName());
            return clusterState;
        }
        LifecycleExecutionState lifecycleState = indexMetadata.getLifecycleExecutionState();
        LifecycleExecutionState.Builder newLifecycleState = LifecycleExecutionState.builder(lifecycleState);
        String downsampleIndexName = DownsampleConfig.generateDownsampleIndexName("downsample-", indexMetadata, this.fixedInterval);
        newLifecycleState.setDownsampleIndexName(downsampleIndexName);
        return LifecycleExecutionStateUtils.newClusterStateWithLifecycleState(clusterState, indexMetadata.getIndex(), newLifecycleState.build());
    }

    @Override
    public boolean isRetryable() {
        return true;
    }
}

