/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.core.action;

import java.io.IOException;
import java.util.Map;
import java.util.Objects;
import org.elasticsearch.action.ActionRequest;
import org.elasticsearch.action.ActionRequestValidationException;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.tasks.CancellableTask;
import org.elasticsearch.tasks.Task;
import org.elasticsearch.tasks.TaskId;
import org.elasticsearch.xpack.core.action.util.PageParams;

public abstract class AbstractGetResourcesRequest
extends ActionRequest {
    private String resourceId;
    private PageParams pageParams = PageParams.defaultParams();
    private boolean allowNoResources = false;

    public AbstractGetResourcesRequest() {
    }

    public AbstractGetResourcesRequest(StreamInput in) throws IOException {
        super(in);
        this.resourceId = in.readOptionalString();
        this.pageParams = in.readOptionalWriteable(PageParams::new);
        this.allowNoResources = in.readBoolean();
    }

    protected AbstractGetResourcesRequest(String resourceId, PageParams pageParams, boolean allowNoResources) {
        this.resourceId = resourceId;
        this.pageParams = pageParams;
        this.allowNoResources = allowNoResources;
    }

    public final void setResourceId(String resourceId) {
        this.resourceId = resourceId;
    }

    public final String getResourceId() {
        return this.resourceId;
    }

    public final void setPageParams(PageParams pageParams) {
        this.pageParams = pageParams;
    }

    public final PageParams getPageParams() {
        return this.pageParams;
    }

    public final void setAllowNoResources(boolean allowNoResources) {
        this.allowNoResources = allowNoResources;
    }

    public final boolean isAllowNoResources() {
        return this.allowNoResources;
    }

    @Override
    public ActionRequestValidationException validate() {
        return null;
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        super.writeTo(out);
        out.writeOptionalString(this.resourceId);
        out.writeOptionalWriteable(this.pageParams);
        out.writeBoolean(this.allowNoResources);
    }

    public int hashCode() {
        return Objects.hash(this.resourceId, this.pageParams, this.allowNoResources);
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AbstractGetResourcesRequest)) {
            return false;
        }
        AbstractGetResourcesRequest other = (AbstractGetResourcesRequest)obj;
        return Objects.equals(this.resourceId, other.resourceId) && Objects.equals(this.pageParams, other.pageParams) && this.allowNoResources == other.allowNoResources;
    }

    @Override
    public Task createTask(long id, String type, String action, TaskId parentTaskId, Map<String, String> headers) {
        return new CancellableTask(id, type, action, this.getCancelableTaskDescription(), parentTaskId, headers);
    }

    public abstract String getCancelableTaskDescription();

    public abstract String getResourceIdField();
}

