/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xcontent;

import java.util.function.Supplier;
import org.elasticsearch.xcontent.XContentLocation;

public interface DeprecationHandler {
    public static final DeprecationHandler THROW_UNSUPPORTED_OPERATION = new DeprecationHandler(){

        @Override
        public void logReplacedField(String parserName, Supplier<XContentLocation> location, String oldName, String replacedName) {
            if (parserName != null) {
                throw new UnsupportedOperationException("deprecated fields not supported in [" + parserName + "] but got [" + oldName + "] at [" + String.valueOf(location.get()) + "] which is a deprecated name for [" + replacedName + "]");
            }
            throw new UnsupportedOperationException("deprecated fields not supported here but got [" + oldName + "] which is a deprecated name for [" + replacedName + "]");
        }

        @Override
        public void logRenamedField(String parserName, Supplier<XContentLocation> location, String oldName, String currentName) {
            if (parserName != null) {
                throw new UnsupportedOperationException("deprecated fields not supported in [" + parserName + "] but got [" + oldName + "] at [" + String.valueOf(location.get()) + "] which has been replaced with [" + currentName + "]");
            }
            throw new UnsupportedOperationException("deprecated fields not supported here but got [" + oldName + "] which has been replaced with [" + currentName + "]");
        }

        @Override
        public void logRemovedField(String parserName, Supplier<XContentLocation> location, String removedName) {
            if (parserName != null) {
                throw new UnsupportedOperationException("deprecated fields not supported in [" + parserName + "] but got [" + removedName + "] at [" + String.valueOf(location.get()) + "] which has been deprecated entirely");
            }
            throw new UnsupportedOperationException("deprecated fields not supported here but got [" + removedName + "] which has been deprecated entirely");
        }
    };
    public static final DeprecationHandler IGNORE_DEPRECATIONS = new DeprecationHandler(){

        @Override
        public void logRenamedField(String parserName, Supplier<XContentLocation> location, String oldName, String currentName) {
        }

        @Override
        public void logReplacedField(String parserName, Supplier<XContentLocation> location, String oldName, String replacedName) {
        }

        @Override
        public void logRemovedField(String parserName, Supplier<XContentLocation> location, String removedName) {
        }
    };

    public void logRenamedField(String var1, Supplier<XContentLocation> var2, String var3, String var4);

    public void logReplacedField(String var1, Supplier<XContentLocation> var2, String var3, String var4);

    public void logRemovedField(String var1, Supplier<XContentLocation> var2, String var3);

    default public void logRenamedField(String parserName, Supplier<XContentLocation> location, String oldName, String currentName, boolean isCompatibleDeprecation) {
        this.logRenamedField(parserName, location, oldName, currentName);
    }

    default public void logReplacedField(String parserName, Supplier<XContentLocation> location, String oldName, String replacedName, boolean isCompatibleDeprecation) {
        this.logReplacedField(parserName, location, oldName, replacedName);
    }

    default public void logRemovedField(String parserName, Supplier<XContentLocation> location, String removedName, boolean isCompatibleDeprecation) {
        this.logRemovedField(parserName, location, removedName);
    }
}

