/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.transport;

import java.io.IOException;
import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.lucene.store.AlreadyClosedException;
import org.apache.lucene.util.BytesRef;
import org.elasticsearch.TransportVersion;
import org.elasticsearch.TransportVersions;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.cluster.node.DiscoveryNode;
import org.elasticsearch.common.bytes.BytesReference;
import org.elasticsearch.common.io.stream.RecyclerBytesStreamOutput;
import org.elasticsearch.common.network.CloseableChannel;
import org.elasticsearch.common.network.HandlingTimeTracker;
import org.elasticsearch.common.recycler.Recycler;
import org.elasticsearch.common.transport.NetworkExceptionHelper;
import org.elasticsearch.common.util.concurrent.ThreadContext;
import org.elasticsearch.core.Nullable;
import org.elasticsearch.core.Releasable;
import org.elasticsearch.core.Releasables;
import org.elasticsearch.core.Strings;
import org.elasticsearch.core.TimeValue;
import org.elasticsearch.threadpool.ThreadPool;
import org.elasticsearch.transport.Compression;
import org.elasticsearch.transport.OutboundMessage;
import org.elasticsearch.transport.RemoteTransportException;
import org.elasticsearch.transport.ResponseStatsConsumer;
import org.elasticsearch.transport.StatsTracker;
import org.elasticsearch.transport.TcpChannel;
import org.elasticsearch.transport.TransportException;
import org.elasticsearch.transport.TransportLogger;
import org.elasticsearch.transport.TransportMessageListener;
import org.elasticsearch.transport.TransportRequest;
import org.elasticsearch.transport.TransportRequestOptions;
import org.elasticsearch.transport.TransportResponse;

final class OutboundHandler {
    private static final Logger logger = LogManager.getLogger(OutboundHandler.class);
    private final String nodeName;
    private final TransportVersion version;
    private final StatsTracker statsTracker;
    private final ThreadPool threadPool;
    private final Recycler<BytesRef> recycler;
    private final HandlingTimeTracker handlingTimeTracker;
    private final boolean rstOnClose;
    private volatile long slowLogThresholdMs = Long.MAX_VALUE;
    private volatile TransportMessageListener messageListener = TransportMessageListener.NOOP_LISTENER;

    OutboundHandler(String nodeName, TransportVersion version, StatsTracker statsTracker, ThreadPool threadPool, Recycler<BytesRef> recycler, HandlingTimeTracker handlingTimeTracker, boolean rstOnClose) {
        this.nodeName = nodeName;
        this.version = version;
        this.statsTracker = statsTracker;
        this.threadPool = threadPool;
        this.recycler = recycler;
        this.handlingTimeTracker = handlingTimeTracker;
        this.rstOnClose = rstOnClose;
    }

    void setSlowLogThreshold(TimeValue slowLogThreshold) {
        this.slowLogThresholdMs = slowLogThreshold.getMillis();
    }

    void sendBytes(TcpChannel channel, BytesReference bytes, ActionListener<Void> listener) {
        this.internalSend(channel, bytes, null, listener);
    }

    void sendRequest(DiscoveryNode node, TcpChannel channel, long requestId, String action, TransportRequest request, TransportRequestOptions options, TransportVersion transportVersion, Compression.Scheme compressionScheme, boolean isHandshake) throws IOException, TransportException {
        assert (this.assertValidTransportVersion(transportVersion));
        OutboundMessage.Request message = new OutboundMessage.Request(this.threadPool.getThreadContext(), request, transportVersion, action, requestId, isHandshake, compressionScheme);
        if (!request.tryIncRef()) {
            assert (false) : "request [" + String.valueOf(request) + "] has been released already";
            throw new AlreadyClosedException("request [" + String.valueOf(request) + "] has been released already");
        }
        this.sendMessage(channel, message, ResponseStatsConsumer.NONE, () -> {
            try {
                this.messageListener.onRequestSent(node, requestId, action, request, options);
            }
            finally {
                request.decRef();
            }
        });
    }

    void sendResponse(TransportVersion transportVersion, TcpChannel channel, long requestId, String action, TransportResponse response, Compression.Scheme compressionScheme, boolean isHandshake, ResponseStatsConsumer responseStatsConsumer) {
        assert (this.assertValidTransportVersion(transportVersion));
        OutboundMessage.Response message = new OutboundMessage.Response(this.threadPool.getThreadContext(), response, transportVersion, requestId, isHandshake, compressionScheme);
        response.mustIncRef();
        try {
            this.sendMessage(channel, message, responseStatsConsumer, () -> {
                try {
                    this.messageListener.onResponseSent(requestId, action, response);
                }
                finally {
                    response.decRef();
                }
            });
        }
        catch (Exception ex) {
            if (isHandshake) {
                logger.error(() -> Strings.format("Failed to send handshake response version [%s] received on [%s], closing channel", transportVersion, channel), (Throwable)ex);
                channel.close();
            }
            this.sendErrorResponse(transportVersion, channel, requestId, action, responseStatsConsumer, ex);
        }
    }

    void sendErrorResponse(TransportVersion transportVersion, TcpChannel channel, long requestId, String action, ResponseStatsConsumer responseStatsConsumer, Exception error) {
        assert (this.assertValidTransportVersion(transportVersion));
        OutboundMessage.Response message = new OutboundMessage.Response(this.threadPool.getThreadContext(), new RemoteTransportException(this.nodeName, channel.getLocalAddress(), action, (Throwable)error), transportVersion, requestId, false, null);
        try {
            this.sendMessage(channel, message, responseStatsConsumer, () -> this.messageListener.onResponseSent(requestId, action, error));
        }
        catch (Exception sendException) {
            sendException.addSuppressed(error);
            logger.error(() -> Strings.format("Failed to send error response on channel [%s], closing channel", channel), (Throwable)sendException);
            channel.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void sendMessage(TcpChannel channel, OutboundMessage networkMessage, ResponseStatsConsumer responseStatsConsumer, Releasable onAfter) throws IOException {
        BytesReference message;
        RecyclerBytesStreamOutput byteStreamOutput;
        boolean bufferSuccess = false;
        try {
            byteStreamOutput = new RecyclerBytesStreamOutput(this.recycler);
            bufferSuccess = true;
        }
        finally {
            if (!bufferSuccess) {
                Releasables.closeExpectNoException(onAfter);
            }
        }
        Releasable release = Releasables.wrap(byteStreamOutput, onAfter);
        boolean serializeSuccess = false;
        try {
            message = networkMessage.serialize(byteStreamOutput);
            serializeSuccess = true;
        }
        catch (Exception e) {
            logger.warn(() -> "failed to serialize outbound message [" + String.valueOf(networkMessage) + "]", (Throwable)e);
            throw e;
        }
        finally {
            if (!serializeSuccess) {
                release.close();
            }
        }
        responseStatsConsumer.addResponseStats(message.length());
        this.internalSend(channel, message, networkMessage, ActionListener.running(release::close));
    }

    private void internalSend(final TcpChannel channel, BytesReference reference, final @Nullable OutboundMessage message, final ActionListener<Void> listener) {
        final long startTime = this.threadPool.rawRelativeTimeInMillis();
        channel.getChannelStats().markAccessed(startTime);
        final long messageSize = reference.length();
        TransportLogger.logOutboundMessage(channel, reference);
        try (ThreadContext.StoredContext ignored = this.threadPool.getThreadContext().newEmptyContext();){
            channel.sendMessage(reference, new ActionListener<Void>(){

                @Override
                public void onResponse(Void v) {
                    OutboundHandler.this.statsTracker.markBytesWritten(messageSize);
                    listener.onResponse(v);
                    this.maybeLogSlowMessage(true);
                }

                @Override
                public void onFailure(Exception e) {
                    Level closeConnectionExceptionLevel = NetworkExceptionHelper.getCloseConnectionExceptionLevel(e, OutboundHandler.this.rstOnClose);
                    if (closeConnectionExceptionLevel == Level.OFF) {
                        logger.warn(() -> "send message failed [channel: " + String.valueOf(channel) + "]", (Throwable)e);
                    } else if (closeConnectionExceptionLevel == Level.INFO && !logger.isDebugEnabled()) {
                        logger.info("send message failed [channel: {}]: {}", (Object)channel, (Object)e.getMessage());
                    } else {
                        logger.log(closeConnectionExceptionLevel, () -> "send message failed [channel: " + String.valueOf(channel) + "]", (Throwable)e);
                    }
                    listener.onFailure(e);
                    this.maybeLogSlowMessage(false);
                }

                private void maybeLogSlowMessage(boolean success) {
                    long logThreshold = OutboundHandler.this.slowLogThresholdMs;
                    if (logThreshold > 0L) {
                        long took = OutboundHandler.this.threadPool.rawRelativeTimeInMillis() - startTime;
                        OutboundHandler.this.handlingTimeTracker.addHandlingTime(took);
                        if (took > logThreshold) {
                            logger.warn("sending transport message [{}] of size [{}] on [{}] took [{}ms] which is above the warn threshold of [{}ms] with success [{}]", (Object)message, (Object)messageSize, (Object)channel, (Object)took, (Object)logThreshold, (Object)success);
                        }
                    }
                }
            });
        }
        catch (RuntimeException ex) {
            Releasables.closeExpectNoException(() -> listener.onFailure(ex), () -> CloseableChannel.closeChannel(channel));
            throw ex;
        }
    }

    void setMessageListener(TransportMessageListener listener) {
        if (this.messageListener != TransportMessageListener.NOOP_LISTENER) {
            throw new IllegalStateException("Cannot set message listener twice");
        }
        this.messageListener = listener;
    }

    public boolean rstOnClose() {
        return this.rstOnClose;
    }

    private boolean assertValidTransportVersion(TransportVersion transportVersion) {
        assert (this.version.before(TransportVersions.MINIMUM_COMPATIBLE) || this.version.onOrAfter(transportVersion)) : String.valueOf(this.version) + " vs " + String.valueOf(transportVersion);
        return true;
    }
}

