/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.search.vectors;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HexFormat;
import java.util.Objects;
import org.elasticsearch.common.ParsingException;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.io.stream.Writeable;
import org.elasticsearch.index.mapper.vectors.DenseVectorFieldMapper;
import org.elasticsearch.xcontent.ToXContent;
import org.elasticsearch.xcontent.ToXContentFragment;
import org.elasticsearch.xcontent.XContentBuilder;
import org.elasticsearch.xcontent.XContentParser;

public record VectorData(float[] floatVector, byte[] byteVector) implements Writeable,
ToXContentFragment
{
    private VectorData(float[] floatVector) {
        this(floatVector, null);
    }

    private VectorData(byte[] byteVector) {
        this(null, byteVector);
    }

    public VectorData(StreamInput in) throws IOException {
        this(in.readOptionalFloatArray(), in.readOptionalByteArray());
    }

    public VectorData {
        if (!(floatVector == null ^ byteVector == null)) {
            throw new IllegalArgumentException("please supply exactly either a float or a byte vector");
        }
    }

    public byte[] asByteVector() {
        if (this.byteVector != null) {
            return this.byteVector;
        }
        DenseVectorFieldMapper.ElementType.BYTE.checkVectorBounds(this.floatVector);
        byte[] vec = new byte[this.floatVector.length];
        for (int i = 0; i < this.floatVector.length; ++i) {
            vec[i] = (byte)this.floatVector[i];
        }
        return vec;
    }

    public float[] asFloatVector() {
        if (this.floatVector != null) {
            return this.floatVector;
        }
        float[] vec = new float[this.byteVector.length];
        for (int i = 0; i < this.byteVector.length; ++i) {
            vec[i] = this.byteVector[i];
        }
        return vec;
    }

    public void addToBuffer(ByteBuffer byteBuffer) {
        if (this.floatVector != null) {
            for (float val : this.floatVector) {
                byteBuffer.putFloat(val);
            }
        } else {
            byteBuffer.put(this.byteVector);
        }
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        out.writeOptionalFloatArray(this.floatVector);
        out.writeOptionalByteArray(this.byteVector);
    }

    @Override
    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        if (this.floatVector != null) {
            builder.startArray();
            for (float v : this.floatVector) {
                builder.value(v);
            }
            builder.endArray();
        } else {
            builder.value(HexFormat.of().formatHex(this.byteVector));
        }
        return builder;
    }

    @Override
    public String toString() {
        return this.floatVector != null ? Arrays.toString(this.floatVector) : Arrays.toString(this.byteVector);
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        VectorData other = (VectorData)obj;
        return Arrays.equals(this.floatVector, other.floatVector) && Arrays.equals(this.byteVector, other.byteVector);
    }

    @Override
    public int hashCode() {
        return Objects.hash(Arrays.hashCode(this.floatVector), Arrays.hashCode(this.byteVector));
    }

    public static VectorData parseXContent(XContentParser parser) throws IOException {
        XContentParser.Token token = parser.currentToken();
        return switch (token) {
            case XContentParser.Token.START_ARRAY -> VectorData.parseQueryVectorArray(parser);
            case XContentParser.Token.VALUE_STRING -> VectorData.parseHexEncodedVector(parser);
            case XContentParser.Token.VALUE_NUMBER -> VectorData.parseNumberVector(parser);
            default -> throw new ParsingException(parser.getTokenLocation(), Strings.format("Unknown type [%s] for parsing vector", new Object[]{token}), new Object[0]);
        };
    }

    private static VectorData parseQueryVectorArray(XContentParser parser) throws IOException {
        XContentParser.Token token;
        ArrayList<Float> vectorArr = new ArrayList<Float>();
        while ((token = parser.nextToken()) != XContentParser.Token.END_ARRAY) {
            if (token == XContentParser.Token.VALUE_NUMBER || token == XContentParser.Token.VALUE_STRING) {
                vectorArr.add(Float.valueOf(parser.floatValue()));
                continue;
            }
            throw new ParsingException(parser.getTokenLocation(), Strings.format("Type [%s] not supported for query vector", new Object[]{token}), new Object[0]);
        }
        float[] floatVector = new float[vectorArr.size()];
        for (int i = 0; i < vectorArr.size(); ++i) {
            floatVector[i] = ((Float)vectorArr.get(i)).floatValue();
        }
        return VectorData.fromFloats(floatVector);
    }

    private static VectorData parseHexEncodedVector(XContentParser parser) throws IOException {
        return VectorData.fromBytes(HexFormat.of().parseHex(parser.text()));
    }

    private static VectorData parseNumberVector(XContentParser parser) throws IOException {
        return VectorData.fromFloats(new float[]{parser.floatValue()});
    }

    public static VectorData fromFloats(float[] vec) {
        return vec == null ? null : new VectorData(vec);
    }

    public static VectorData fromBytes(byte[] vec) {
        return vec == null ? null : new VectorData(vec);
    }
}

