/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.search.fetch.subphase;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import org.elasticsearch.common.ParsingException;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.io.stream.Writeable;
import org.elasticsearch.core.Booleans;
import org.elasticsearch.core.Nullable;
import org.elasticsearch.rest.RestRequest;
import org.elasticsearch.search.lookup.SourceFilter;
import org.elasticsearch.xcontent.ParseField;
import org.elasticsearch.xcontent.ToXContent;
import org.elasticsearch.xcontent.ToXContentObject;
import org.elasticsearch.xcontent.XContentBuilder;
import org.elasticsearch.xcontent.XContentParser;

public class FetchSourceContext
implements Writeable,
ToXContentObject {
    public static final ParseField INCLUDES_FIELD = new ParseField("includes", "include");
    public static final ParseField EXCLUDES_FIELD = new ParseField("excludes", "exclude");
    public static final FetchSourceContext FETCH_SOURCE = new FetchSourceContext(true, Strings.EMPTY_ARRAY, Strings.EMPTY_ARRAY);
    public static final FetchSourceContext DO_NOT_FETCH_SOURCE = new FetchSourceContext(false, Strings.EMPTY_ARRAY, Strings.EMPTY_ARRAY);
    private final boolean fetchSource;
    private final String[] includes;
    private final String[] excludes;

    public static FetchSourceContext of(boolean fetchSource) {
        return fetchSource ? FETCH_SOURCE : DO_NOT_FETCH_SOURCE;
    }

    public static FetchSourceContext of(boolean fetchSource, @Nullable String[] includes, @Nullable String[] excludes) {
        if (!(includes != null && includes.length != 0 || excludes != null && excludes.length != 0)) {
            return FetchSourceContext.of(fetchSource);
        }
        return new FetchSourceContext(fetchSource, includes, excludes);
    }

    public static FetchSourceContext readFrom(StreamInput in) throws IOException {
        boolean fetchSource = in.readBoolean();
        String[] includes = in.readStringArray();
        String[] excludes = in.readStringArray();
        return FetchSourceContext.of(fetchSource, includes, excludes);
    }

    private FetchSourceContext(boolean fetchSource, @Nullable String[] includes, @Nullable String[] excludes) {
        this.fetchSource = fetchSource;
        this.includes = includes == null ? Strings.EMPTY_ARRAY : includes;
        this.excludes = excludes == null ? Strings.EMPTY_ARRAY : excludes;
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        out.writeBoolean(this.fetchSource);
        out.writeStringArray(this.includes);
        out.writeStringArray(this.excludes);
    }

    public boolean fetchSource() {
        return this.fetchSource;
    }

    public String[] includes() {
        return this.includes;
    }

    public String[] excludes() {
        return this.excludes;
    }

    private boolean hasFilter() {
        return this.includes.length > 0 || this.excludes.length > 0;
    }

    public SourceFilter filter() {
        return this.hasFilter() ? new SourceFilter(this.includes, this.excludes) : null;
    }

    public static FetchSourceContext parseFromRestRequest(RestRequest request) {
        String sExcludes;
        String sIncludes;
        Boolean fetchSource = null;
        String[] sourceExcludes = null;
        String[] sourceIncludes = null;
        String source = request.param("_source");
        if (source != null) {
            if (Booleans.isTrue(source)) {
                fetchSource = true;
            } else if (Booleans.isFalse(source)) {
                fetchSource = false;
            } else {
                sourceIncludes = Strings.splitStringByCommaToArray(source);
            }
        }
        if ((sIncludes = request.param("_source_includes")) != null) {
            sourceIncludes = Strings.splitStringByCommaToArray(sIncludes);
        }
        if ((sExcludes = request.param("_source_excludes")) != null) {
            sourceExcludes = Strings.splitStringByCommaToArray(sExcludes);
        }
        if (fetchSource != null || sourceIncludes != null || sourceExcludes != null) {
            return FetchSourceContext.of(fetchSource == null || fetchSource != false, sourceIncludes, sourceExcludes);
        }
        return null;
    }

    public static FetchSourceContext fromXContent(XContentParser parser) throws IOException {
        if (parser.currentToken() == null) {
            parser.nextToken();
        }
        XContentParser.Token token = parser.currentToken();
        boolean fetchSource = true;
        String[] includes = Strings.EMPTY_ARRAY;
        String[] excludes = Strings.EMPTY_ARRAY;
        if (token == XContentParser.Token.VALUE_BOOLEAN) {
            fetchSource = parser.booleanValue();
        } else if (token == XContentParser.Token.VALUE_STRING) {
            includes = new String[]{parser.text()};
        } else if (token == XContentParser.Token.START_ARRAY) {
            ArrayList<String> list = new ArrayList<String>();
            while (parser.nextToken() != XContentParser.Token.END_ARRAY) {
                list.add(parser.text());
            }
            includes = list.toArray(Strings.EMPTY_ARRAY);
        } else if (token == XContentParser.Token.START_OBJECT) {
            String currentFieldName = null;
            while ((token = parser.nextToken()) != XContentParser.Token.END_OBJECT) {
                if (token == XContentParser.Token.FIELD_NAME) {
                    currentFieldName = parser.currentName();
                    continue;
                }
                if (token == XContentParser.Token.START_ARRAY) {
                    if (INCLUDES_FIELD.match(currentFieldName, parser.getDeprecationHandler())) {
                        includes = FetchSourceContext.parseStringArray(parser, currentFieldName);
                        continue;
                    }
                    if (EXCLUDES_FIELD.match(currentFieldName, parser.getDeprecationHandler())) {
                        excludes = FetchSourceContext.parseStringArray(parser, currentFieldName);
                        continue;
                    }
                    throw new ParsingException(parser.getTokenLocation(), "Unknown key for a " + String.valueOf((Object)token) + " in [" + currentFieldName + "].", parser.getTokenLocation());
                }
                if (token == XContentParser.Token.VALUE_STRING) {
                    if (INCLUDES_FIELD.match(currentFieldName, parser.getDeprecationHandler())) {
                        includes = new String[]{parser.text()};
                        continue;
                    }
                    if (EXCLUDES_FIELD.match(currentFieldName, parser.getDeprecationHandler())) {
                        excludes = new String[]{parser.text()};
                        continue;
                    }
                    throw new ParsingException(parser.getTokenLocation(), "Unknown key for a " + String.valueOf((Object)token) + " in [" + currentFieldName + "].", parser.getTokenLocation());
                }
                throw new ParsingException(parser.getTokenLocation(), "Unknown key for a " + String.valueOf((Object)token) + " in [" + currentFieldName + "].", parser.getTokenLocation());
            }
        } else {
            throw new ParsingException(parser.getTokenLocation(), "Expected one of [" + String.valueOf((Object)XContentParser.Token.VALUE_BOOLEAN) + ", " + String.valueOf((Object)XContentParser.Token.VALUE_STRING) + ", " + String.valueOf((Object)XContentParser.Token.START_ARRAY) + ", " + String.valueOf((Object)XContentParser.Token.START_OBJECT) + "] but found [" + String.valueOf((Object)token) + "]", parser.getTokenLocation());
        }
        return FetchSourceContext.of(fetchSource, includes, excludes);
    }

    private static String[] parseStringArray(XContentParser parser, String currentFieldName) throws IOException {
        XContentParser.Token token;
        ArrayList<String> excludesList = new ArrayList<String>();
        while ((token = parser.nextToken()) != XContentParser.Token.END_ARRAY) {
            if (token == XContentParser.Token.VALUE_STRING) {
                excludesList.add(parser.text());
                continue;
            }
            throw new ParsingException(parser.getTokenLocation(), "Unknown key for a " + String.valueOf((Object)token) + " in [" + currentFieldName + "].", parser.getTokenLocation());
        }
        String[] excludes = excludesList.toArray(Strings.EMPTY_ARRAY);
        return excludes;
    }

    @Override
    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        if (this.fetchSource) {
            builder.startObject();
            builder.array(INCLUDES_FIELD.getPreferredName(), this.includes);
            builder.array(EXCLUDES_FIELD.getPreferredName(), this.excludes);
            builder.endObject();
        } else {
            builder.value(false);
        }
        return builder;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        FetchSourceContext that = (FetchSourceContext)o;
        if (this.fetchSource != that.fetchSource) {
            return false;
        }
        if (!Arrays.equals(this.excludes, that.excludes)) {
            return false;
        }
        return Arrays.equals(this.includes, that.includes);
    }

    public int hashCode() {
        int result = this.fetchSource ? 1 : 0;
        result = 31 * result + Arrays.hashCode(this.includes);
        result = 31 * result + Arrays.hashCode(this.excludes);
        return result;
    }
}

