/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.search.aggregations.bucket.prefix;

import java.io.IOException;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.Arrays;
import java.util.Map;
import java.util.Objects;
import org.apache.lucene.util.BytesRef;
import org.elasticsearch.TransportVersion;
import org.elasticsearch.TransportVersions;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.search.aggregations.AggregationBuilder;
import org.elasticsearch.search.aggregations.AggregatorFactories;
import org.elasticsearch.search.aggregations.AggregatorFactory;
import org.elasticsearch.search.aggregations.bucket.prefix.IpPrefixAggregationSupplier;
import org.elasticsearch.search.aggregations.bucket.prefix.IpPrefixAggregator;
import org.elasticsearch.search.aggregations.bucket.prefix.IpPrefixAggregatorFactory;
import org.elasticsearch.search.aggregations.support.AggregationContext;
import org.elasticsearch.search.aggregations.support.CoreValuesSourceType;
import org.elasticsearch.search.aggregations.support.ValuesSourceAggregationBuilder;
import org.elasticsearch.search.aggregations.support.ValuesSourceAggregatorFactory;
import org.elasticsearch.search.aggregations.support.ValuesSourceConfig;
import org.elasticsearch.search.aggregations.support.ValuesSourceRegistry;
import org.elasticsearch.search.aggregations.support.ValuesSourceType;
import org.elasticsearch.xcontent.ObjectParser;
import org.elasticsearch.xcontent.ParseField;
import org.elasticsearch.xcontent.ToXContent;
import org.elasticsearch.xcontent.XContentBuilder;

public class IpPrefixAggregationBuilder
extends ValuesSourceAggregationBuilder<IpPrefixAggregationBuilder> {
    public static final String NAME = "ip_prefix";
    public static final ValuesSourceRegistry.RegistryKey<IpPrefixAggregationSupplier> REGISTRY_KEY = new ValuesSourceRegistry.RegistryKey<IpPrefixAggregationSupplier>("ip_prefix", IpPrefixAggregationSupplier.class);
    public static final ObjectParser<IpPrefixAggregationBuilder, String> PARSER = ObjectParser.fromBuilder("ip_prefix", IpPrefixAggregationBuilder::new);
    public static final ParseField PREFIX_LENGTH_FIELD = new ParseField("prefix_length", new String[0]);
    public static final ParseField IS_IPV6_FIELD = new ParseField("is_ipv6", new String[0]);
    public static final ParseField APPEND_PREFIX_LENGTH_FIELD = new ParseField("append_prefix_length", new String[0]);
    public static final ParseField MIN_DOC_COUNT_FIELD = new ParseField("min_doc_count", new String[0]);
    public static final ParseField KEYED_FIELD = new ParseField("keyed", new String[0]);
    private static final int IPV6_MAX_PREFIX_LENGTH = 128;
    private static final int IPV4_MAX_PREFIX_LENGTH = 32;
    private static final int MIN_PREFIX_LENGTH = 0;
    private long minDocCount = 1L;
    private int prefixLength = -1;
    private boolean isIpv6 = false;
    private boolean appendPrefixLength = false;
    private boolean keyed = false;

    public IpPrefixAggregationBuilder(StreamInput in) throws IOException {
        super(in);
        this.prefixLength = in.readVInt();
        this.isIpv6 = in.readBoolean();
        this.minDocCount = in.readVLong();
        this.appendPrefixLength = in.readBoolean();
        this.keyed = in.readBoolean();
    }

    public static void registerAggregators(ValuesSourceRegistry.Builder builder) {
        IpPrefixAggregatorFactory.registerAggregators(builder);
    }

    private static <T> void throwOnInvalidFieldValue(String fieldName, T minValue, T maxValue, T fieldValue) {
        throw new IllegalArgumentException("[" + fieldName + "] must be in range [" + minValue.toString() + ", " + maxValue.toString() + "] while value is [" + fieldValue.toString() + "]");
    }

    public IpPrefixAggregationBuilder minDocCount(long minDocCount) {
        if (minDocCount < 1L) {
            IpPrefixAggregationBuilder.throwOnInvalidFieldValue(MIN_DOC_COUNT_FIELD.getPreferredName(), 1, Integer.MAX_VALUE, minDocCount);
        }
        this.minDocCount = minDocCount;
        return this;
    }

    public IpPrefixAggregationBuilder prefixLength(int prefixLength) {
        if (prefixLength < 0) {
            IpPrefixAggregationBuilder.throwOnInvalidFieldValue(PREFIX_LENGTH_FIELD.getPreferredName(), 0, this.isIpv6 ? 128 : 32, prefixLength);
        }
        this.prefixLength = prefixLength;
        return this;
    }

    public IpPrefixAggregationBuilder isIpv6(boolean isIpv6) {
        this.isIpv6 = isIpv6;
        return this;
    }

    public IpPrefixAggregationBuilder appendPrefixLength(boolean appendPrefixLength) {
        this.appendPrefixLength = appendPrefixLength;
        return this;
    }

    public IpPrefixAggregationBuilder keyed(boolean keyed) {
        this.keyed = keyed;
        return this;
    }

    public IpPrefixAggregationBuilder(String name) {
        super(name);
    }

    protected IpPrefixAggregationBuilder(IpPrefixAggregationBuilder clone, AggregatorFactories.Builder factoriesBuilder, Map<String, Object> metadata) {
        super(clone, factoriesBuilder, metadata);
        this.minDocCount = clone.minDocCount;
        this.isIpv6 = clone.isIpv6;
        this.prefixLength = clone.prefixLength;
        this.appendPrefixLength = clone.appendPrefixLength;
        this.keyed = clone.keyed;
    }

    @Override
    protected AggregationBuilder shallowCopy(AggregatorFactories.Builder factoriesBuilder, Map<String, Object> metadata) {
        return new IpPrefixAggregationBuilder(this, factoriesBuilder, metadata);
    }

    @Override
    public AggregationBuilder.BucketCardinality bucketCardinality() {
        return AggregationBuilder.BucketCardinality.MANY;
    }

    @Override
    public String getType() {
        return NAME;
    }

    @Override
    protected void innerWriteTo(StreamOutput out) throws IOException {
        out.writeVInt(this.prefixLength);
        out.writeBoolean(this.isIpv6);
        out.writeVLong(this.minDocCount);
        out.writeBoolean(this.appendPrefixLength);
        out.writeBoolean(this.keyed);
    }

    @Override
    protected ValuesSourceType defaultValueSourceType() {
        return CoreValuesSourceType.IP;
    }

    @Override
    protected ValuesSourceAggregatorFactory innerBuild(AggregationContext context, ValuesSourceConfig config, AggregatorFactory parent, AggregatorFactories.Builder subFactoriesBuilder) throws IOException {
        IpPrefixAggregationSupplier aggregationSupplier = context.getValuesSourceRegistry().getAggregator(REGISTRY_KEY, config);
        if (this.prefixLength < 0 || !this.isIpv6 && this.prefixLength > 32 || this.isIpv6 && this.prefixLength > 128) {
            IpPrefixAggregationBuilder.throwOnInvalidFieldValue(PREFIX_LENGTH_FIELD.getPreferredName(), 0, this.isIpv6 ? 128 : 32, this.prefixLength);
        }
        IpPrefixAggregator.IpPrefix ipPrefix = new IpPrefixAggregator.IpPrefix(this.isIpv6, this.prefixLength, this.appendPrefixLength, IpPrefixAggregationBuilder.extractNetmask(this.prefixLength, this.isIpv6));
        return new IpPrefixAggregatorFactory(this.name, config, this.keyed, this.minDocCount, ipPrefix, context, parent, subFactoriesBuilder, this.metadata, aggregationSupplier);
    }

    public static BytesRef extractNetmask(int prefixLength, boolean isIpv6) {
        if (prefixLength < 0 || !isIpv6 && prefixLength > 32 || isIpv6 && prefixLength > 128) {
            IpPrefixAggregationBuilder.throwOnInvalidFieldValue(PREFIX_LENGTH_FIELD.getPreferredName(), 0, isIpv6 ? 128 : 32, prefixLength);
        }
        byte[] ipv4Address = new byte[]{0, 0, 0, 0};
        byte[] ipv6Address = new byte[]{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0};
        byte[] ipAddress = isIpv6 ? ipv6Address : ipv4Address;
        int bytesCount = prefixLength / 8;
        int bitsCount = prefixLength % 8;
        for (int i = 0; i < bytesCount; ++i) {
            ipAddress[i] = -1;
        }
        if (bitsCount > 0) {
            int rem = 0;
            for (int j = 0; j < bitsCount; ++j) {
                rem |= 1 << 7 - j;
            }
            ipAddress[i] = (byte)rem;
        }
        try {
            return new BytesRef(InetAddress.getByAddress(ipAddress).getAddress());
        }
        catch (UnknownHostException e) {
            throw new IllegalArgumentException("Unable to get the ip address for [" + Arrays.toString(ipAddress) + "]", e);
        }
    }

    @Override
    protected XContentBuilder doXContentBody(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.field(PREFIX_LENGTH_FIELD.getPreferredName(), this.prefixLength);
        builder.field(IS_IPV6_FIELD.getPreferredName(), this.isIpv6);
        builder.field(APPEND_PREFIX_LENGTH_FIELD.getPreferredName(), this.appendPrefixLength);
        builder.field(KEYED_FIELD.getPreferredName(), this.keyed);
        builder.field(MIN_DOC_COUNT_FIELD.getPreferredName(), this.minDocCount);
        return builder;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        IpPrefixAggregationBuilder that = (IpPrefixAggregationBuilder)o;
        return this.minDocCount == that.minDocCount && this.prefixLength == that.prefixLength && this.isIpv6 == that.isIpv6;
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.minDocCount, this.prefixLength, this.isIpv6);
    }

    @Override
    public TransportVersion getMinimalSupportedVersion() {
        return TransportVersions.V_8_1_0;
    }

    static {
        ValuesSourceAggregationBuilder.declareFields(PARSER, false, false, false);
        PARSER.declareInt(IpPrefixAggregationBuilder::prefixLength, PREFIX_LENGTH_FIELD);
        PARSER.declareBoolean(IpPrefixAggregationBuilder::isIpv6, IS_IPV6_FIELD);
        PARSER.declareLong(IpPrefixAggregationBuilder::minDocCount, MIN_DOC_COUNT_FIELD);
        PARSER.declareBoolean(IpPrefixAggregationBuilder::appendPrefixLength, APPEND_PREFIX_LENGTH_FIELD);
        PARSER.declareBoolean(IpPrefixAggregationBuilder::keyed, KEYED_FIELD);
    }
}

