/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.rest.action.admin.cluster;

import java.io.IOException;
import java.util.List;
import org.elasticsearch.action.admin.cluster.configuration.AddVotingConfigExclusionsRequest;
import org.elasticsearch.action.admin.cluster.configuration.TransportAddVotingConfigExclusionsAction;
import org.elasticsearch.client.internal.node.NodeClient;
import org.elasticsearch.common.Strings;
import org.elasticsearch.core.TimeValue;
import org.elasticsearch.rest.BaseRestHandler;
import org.elasticsearch.rest.RestChannel;
import org.elasticsearch.rest.RestHandler;
import org.elasticsearch.rest.RestRequest;
import org.elasticsearch.rest.RestUtils;
import org.elasticsearch.rest.action.RestToXContentListener;

public class RestAddVotingConfigExclusionAction
extends BaseRestHandler {
    private static final TimeValue DEFAULT_TIMEOUT = TimeValue.timeValueSeconds(30L);

    @Override
    public String getName() {
        return "add_voting_config_exclusions_action";
    }

    @Override
    public List<RestHandler.Route> routes() {
        return List.of(new RestHandler.Route(RestRequest.Method.POST, "/_cluster/voting_config_exclusions"));
    }

    @Override
    public boolean canTripCircuitBreaker() {
        return false;
    }

    @Override
    protected BaseRestHandler.RestChannelConsumer prepareRequest(RestRequest request, NodeClient client) throws IOException {
        AddVotingConfigExclusionsRequest votingConfigExclusionsRequest = RestAddVotingConfigExclusionAction.resolveVotingConfigExclusionsRequest(request);
        return channel -> client.execute(TransportAddVotingConfigExclusionsAction.TYPE, votingConfigExclusionsRequest, new RestToXContentListener((RestChannel)channel));
    }

    static AddVotingConfigExclusionsRequest resolveVotingConfigExclusionsRequest(RestRequest request) {
        String nodeIds = null;
        String nodeNames = null;
        if (request.hasParam("node_ids")) {
            nodeIds = request.param("node_ids");
        }
        if (request.hasParam("node_names")) {
            nodeNames = request.param("node_names");
        }
        return new AddVotingConfigExclusionsRequest(RestUtils.getMasterNodeTimeout(request), Strings.splitStringByCommaToArray(nodeIds), Strings.splitStringByCommaToArray(nodeNames), request.paramAsTime("timeout", DEFAULT_TIMEOUT));
    }
}

