/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.repositories;

import java.util.Map;
import java.util.Set;
import java.util.function.Consumer;
import org.apache.lucene.util.SetOnce;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.DelegatingActionListener;
import org.elasticsearch.cluster.ClusterState;
import org.elasticsearch.cluster.SnapshotsInProgress;
import org.elasticsearch.cluster.metadata.Metadata;
import org.elasticsearch.index.IndexVersion;
import org.elasticsearch.repositories.RepositoryData;
import org.elasticsearch.repositories.RepositoryShardId;
import org.elasticsearch.repositories.ShardGeneration;
import org.elasticsearch.repositories.ShardGenerations;
import org.elasticsearch.snapshots.SnapshotInfo;
import org.elasticsearch.snapshots.SnapshotsService;

public final class FinalizeSnapshotContext
extends DelegatingActionListener<RepositoryData, RepositoryData> {
    private final UpdatedShardGenerations updatedShardGenerations;
    private final SetOnce<Map<RepositoryShardId, Set<ShardGeneration>>> obsoleteGenerations = new SetOnce();
    private final long repositoryStateId;
    private final Metadata clusterMetadata;
    private final SnapshotInfo snapshotInfo;
    private final IndexVersion repositoryMetaVersion;
    private final Consumer<SnapshotInfo> onDone;

    public FinalizeSnapshotContext(UpdatedShardGenerations updatedShardGenerations, long repositoryStateId, Metadata clusterMetadata, SnapshotInfo snapshotInfo, IndexVersion repositoryMetaVersion, ActionListener<RepositoryData> listener, Consumer<SnapshotInfo> onDone) {
        super(listener);
        this.updatedShardGenerations = updatedShardGenerations;
        this.repositoryStateId = repositoryStateId;
        this.clusterMetadata = clusterMetadata;
        this.snapshotInfo = snapshotInfo;
        this.repositoryMetaVersion = repositoryMetaVersion;
        this.onDone = onDone;
    }

    public long repositoryStateId() {
        return this.repositoryStateId;
    }

    public UpdatedShardGenerations updatedShardGenerations() {
        return this.updatedShardGenerations;
    }

    public SnapshotInfo snapshotInfo() {
        return this.snapshotInfo;
    }

    public IndexVersion repositoryMetaVersion() {
        return this.repositoryMetaVersion;
    }

    public Metadata clusterMetadata() {
        return this.clusterMetadata;
    }

    public Map<RepositoryShardId, Set<ShardGeneration>> obsoleteShardGenerations() {
        assert (this.obsoleteGenerations.get() != null) : "must only be called after #updatedClusterState";
        return this.obsoleteGenerations.get();
    }

    public ClusterState updatedClusterState(ClusterState state) {
        ClusterState updatedState = SnapshotsService.stateWithoutSnapshot(state, this.snapshotInfo.snapshot(), this.updatedShardGenerations);
        this.obsoleteGenerations.set(SnapshotsInProgress.get(updatedState).obsoleteGenerations(this.snapshotInfo.repository(), SnapshotsInProgress.get(state)));
        return updatedState;
    }

    public void onDone(SnapshotInfo snapshotInfo) {
        this.onDone.accept(snapshotInfo);
    }

    @Override
    public void onResponse(RepositoryData repositoryData) {
        this.delegate.onResponse(repositoryData);
    }

    public record UpdatedShardGenerations(ShardGenerations liveIndices, ShardGenerations deletedIndices) {
        public static final UpdatedShardGenerations EMPTY = new UpdatedShardGenerations(ShardGenerations.EMPTY, ShardGenerations.EMPTY);

        public boolean hasShardGen(RepositoryShardId repositoryShardId) {
            return this.liveIndices.hasShardGen(repositoryShardId) || this.deletedIndices.hasShardGen(repositoryShardId);
        }
    }
}

