/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.lucene.document;

import org.apache.lucene.document.IntPoint;
import org.apache.lucene.document.LongPoint;
import org.apache.lucene.document.SortedNumericDocValuesField;
import org.apache.lucene.search.IndexOrDocValuesQuery;
import org.apache.lucene.search.PointRangeQuery;
import org.apache.lucene.search.Query;
import org.elasticsearch.lucene.search.XIndexSortSortedNumericDocValuesRangeQuery;

public final class NumericField {
    private NumericField() {
    }

    public static Query newExactLongQuery(String field, long value) {
        return NumericField.newRangeLongQuery(field, value, value);
    }

    public static Query newRangeLongQuery(String field, long lowerValue, long upperValue) {
        PointRangeQuery.checkArgs(field, lowerValue, upperValue);
        IndexOrDocValuesQuery fallbackQuery = new IndexOrDocValuesQuery(LongPoint.newRangeQuery(field, lowerValue, upperValue), SortedNumericDocValuesField.newSlowRangeQuery(field, lowerValue, upperValue));
        return new XIndexSortSortedNumericDocValuesRangeQuery(field, lowerValue, upperValue, fallbackQuery);
    }

    public static Query newExactIntQuery(String field, int value) {
        return NumericField.newRangeIntQuery(field, value, value);
    }

    public static Query newRangeIntQuery(String field, int lowerValue, int upperValue) {
        PointRangeQuery.checkArgs(field, lowerValue, upperValue);
        IndexOrDocValuesQuery fallbackQuery = new IndexOrDocValuesQuery(IntPoint.newRangeQuery(field, lowerValue, upperValue), SortedNumericDocValuesField.newSlowRangeQuery(field, lowerValue, upperValue));
        return new XIndexSortSortedNumericDocValuesRangeQuery(field, lowerValue, upperValue, fallbackQuery);
    }
}

