/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.inference;

import java.io.IOException;
import java.util.Objects;
import org.elasticsearch.core.Nullable;
import org.elasticsearch.index.mapper.vectors.DenseVectorFieldMapper;
import org.elasticsearch.inference.Model;
import org.elasticsearch.inference.SimilarityMeasure;
import org.elasticsearch.inference.TaskType;
import org.elasticsearch.xcontent.ConstructingObjectParser;
import org.elasticsearch.xcontent.ParseField;
import org.elasticsearch.xcontent.ToXContent;
import org.elasticsearch.xcontent.ToXContentObject;
import org.elasticsearch.xcontent.XContentBuilder;
import org.elasticsearch.xcontent.XContentParser;

public record MinimalServiceSettings(TaskType taskType, @Nullable Integer dimensions, @Nullable SimilarityMeasure similarity, @Nullable DenseVectorFieldMapper.ElementType elementType) implements ToXContentObject
{
    public static final String TASK_TYPE_FIELD = "task_type";
    static final String DIMENSIONS_FIELD = "dimensions";
    static final String SIMILARITY_FIELD = "similarity";
    static final String ELEMENT_TYPE_FIELD = "element_type";
    private static final ConstructingObjectParser<MinimalServiceSettings, Void> PARSER = new ConstructingObjectParser("model_settings", true, args -> {
        TaskType taskType = TaskType.fromString((String)args[0]);
        Integer dimensions = (Integer)args[1];
        SimilarityMeasure similarity = args[2] == null ? null : SimilarityMeasure.fromString((String)args[2]);
        DenseVectorFieldMapper.ElementType elementType = args[3] == null ? null : DenseVectorFieldMapper.ElementType.fromString((String)args[3]);
        return new MinimalServiceSettings(taskType, dimensions, similarity, elementType);
    });

    public MinimalServiceSettings(Model model) {
        this(model.getTaskType(), model.getServiceSettings().dimensions(), model.getServiceSettings().similarity(), model.getServiceSettings().elementType());
    }

    public MinimalServiceSettings(TaskType taskType, @Nullable Integer dimensions, @Nullable SimilarityMeasure similarity, @Nullable DenseVectorFieldMapper.ElementType elementType) {
        this.taskType = Objects.requireNonNull(taskType, "task type must not be null");
        this.dimensions = dimensions;
        this.similarity = similarity;
        this.elementType = elementType;
        this.validate();
    }

    public static MinimalServiceSettings parse(XContentParser parser) throws IOException {
        return PARSER.parse(parser, null);
    }

    public static MinimalServiceSettings textEmbedding(int dimensions, SimilarityMeasure similarity, DenseVectorFieldMapper.ElementType elementType) {
        return new MinimalServiceSettings(TaskType.TEXT_EMBEDDING, dimensions, similarity, elementType);
    }

    public static MinimalServiceSettings sparseEmbedding() {
        return new MinimalServiceSettings(TaskType.SPARSE_EMBEDDING, null, null, null);
    }

    public static MinimalServiceSettings rerank() {
        return new MinimalServiceSettings(TaskType.RERANK, null, null, null);
    }

    public static MinimalServiceSettings completion() {
        return new MinimalServiceSettings(TaskType.COMPLETION, null, null, null);
    }

    public static MinimalServiceSettings chatCompletion() {
        return new MinimalServiceSettings(TaskType.CHAT_COMPLETION, null, null, null);
    }

    @Override
    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject();
        builder.field(TASK_TYPE_FIELD, this.taskType.toString());
        if (this.dimensions != null) {
            builder.field(DIMENSIONS_FIELD, this.dimensions);
        }
        if (this.similarity != null) {
            builder.field(SIMILARITY_FIELD, this.similarity);
        }
        if (this.elementType != null) {
            builder.field(ELEMENT_TYPE_FIELD, this.elementType);
        }
        return builder.endObject();
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("task_type=").append(this.taskType);
        if (this.dimensions != null) {
            sb.append(", dimensions=").append(this.dimensions);
        }
        if (this.similarity != null) {
            sb.append(", similarity=").append((Object)this.similarity);
        }
        if (this.elementType != null) {
            sb.append(", element_type=").append((Object)this.elementType);
        }
        return sb.toString();
    }

    private void validate() {
        switch (this.taskType) {
            case TEXT_EMBEDDING: {
                this.validateFieldPresent(DIMENSIONS_FIELD, this.dimensions);
                this.validateFieldPresent(SIMILARITY_FIELD, (Object)this.similarity);
                this.validateFieldPresent(ELEMENT_TYPE_FIELD, (Object)this.elementType);
                break;
            }
            default: {
                this.validateFieldNotPresent(DIMENSIONS_FIELD, this.dimensions);
                this.validateFieldNotPresent(SIMILARITY_FIELD, (Object)this.similarity);
                this.validateFieldNotPresent(ELEMENT_TYPE_FIELD, (Object)this.elementType);
            }
        }
    }

    private void validateFieldPresent(String field, Object fieldValue) {
        if (fieldValue == null) {
            throw new IllegalArgumentException("required [" + field + "] field is missing for task_type [" + this.taskType.name() + "]");
        }
    }

    private void validateFieldNotPresent(String field, Object fieldValue) {
        if (fieldValue != null) {
            throw new IllegalArgumentException("[" + field + "] is not allowed for task_type [" + this.taskType.name() + "]");
        }
    }

    static {
        PARSER.declareString(ConstructingObjectParser.constructorArg(), new ParseField(TASK_TYPE_FIELD, new String[0]));
        PARSER.declareInt(ConstructingObjectParser.optionalConstructorArg(), new ParseField(DIMENSIONS_FIELD, new String[0]));
        PARSER.declareString(ConstructingObjectParser.optionalConstructorArg(), new ParseField(SIMILARITY_FIELD, new String[0]));
        PARSER.declareString(ConstructingObjectParser.optionalConstructorArg(), new ParseField(ELEMENT_TYPE_FIELD, new String[0]));
    }
}

