/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.shard;

import java.io.Closeable;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintStream;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.VarHandle;
import java.nio.channels.ClosedByInterruptException;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Deque;
import java.util.EnumSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.LongSupplier;
import java.util.function.LongUnaryOperator;
import java.util.function.Supplier;
import org.apache.logging.log4j.Logger;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.analysis.DelegatingAnalyzerWrapper;
import org.apache.lucene.index.CheckIndex;
import org.apache.lucene.index.DirectoryReader;
import org.apache.lucene.index.FieldInfos;
import org.apache.lucene.index.FilterDirectoryReader;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.LeafReader;
import org.apache.lucene.index.LeafReaderContext;
import org.apache.lucene.index.SegmentInfos;
import org.apache.lucene.search.QueryCachingPolicy;
import org.apache.lucene.search.ReferenceManager;
import org.apache.lucene.search.Sort;
import org.apache.lucene.search.UsageTrackingQueryCachingPolicy;
import org.apache.lucene.store.AlreadyClosedException;
import org.apache.lucene.util.SetOnce;
import org.apache.lucene.util.ThreadInterruptedException;
import org.apache.lucene.util.Version;
import org.elasticsearch.ElasticsearchException;
import org.elasticsearch.ExceptionsHelper;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.ActionRunnable;
import org.elasticsearch.action.admin.indices.flush.FlushRequest;
import org.elasticsearch.action.admin.indices.forcemerge.ForceMergeRequest;
import org.elasticsearch.action.support.PlainActionFuture;
import org.elasticsearch.action.support.SubscribableListener;
import org.elasticsearch.action.support.replication.PendingReplicationActions;
import org.elasticsearch.action.support.replication.ReplicationResponse;
import org.elasticsearch.cluster.metadata.DataStream;
import org.elasticsearch.cluster.metadata.IndexMetadata;
import org.elasticsearch.cluster.metadata.MappingMetadata;
import org.elasticsearch.cluster.routing.IndexShardRoutingTable;
import org.elasticsearch.cluster.routing.RecoverySource;
import org.elasticsearch.cluster.routing.ShardRouting;
import org.elasticsearch.cluster.routing.allocation.decider.DiskThresholdDecider;
import org.elasticsearch.common.UUIDs;
import org.elasticsearch.common.io.stream.BytesStreamOutput;
import org.elasticsearch.common.lucene.Lucene;
import org.elasticsearch.common.lucene.index.ElasticsearchDirectoryReader;
import org.elasticsearch.common.metrics.CounterMetric;
import org.elasticsearch.common.metrics.MeanMetric;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.util.BigArrays;
import org.elasticsearch.common.util.CollectionUtils;
import org.elasticsearch.common.util.concurrent.AbstractRunnable;
import org.elasticsearch.common.util.concurrent.EsExecutors;
import org.elasticsearch.common.xcontent.XContentHelper;
import org.elasticsearch.core.Assertions;
import org.elasticsearch.core.Booleans;
import org.elasticsearch.core.CheckedConsumer;
import org.elasticsearch.core.CheckedFunction;
import org.elasticsearch.core.CheckedRunnable;
import org.elasticsearch.core.IOUtils;
import org.elasticsearch.core.Nullable;
import org.elasticsearch.core.Releasable;
import org.elasticsearch.core.Releasables;
import org.elasticsearch.core.Strings;
import org.elasticsearch.core.TimeValue;
import org.elasticsearch.gateway.WriteStateException;
import org.elasticsearch.index.Index;
import org.elasticsearch.index.IndexModule;
import org.elasticsearch.index.IndexNotFoundException;
import org.elasticsearch.index.IndexService;
import org.elasticsearch.index.IndexSettings;
import org.elasticsearch.index.IndexVersion;
import org.elasticsearch.index.IndexVersions;
import org.elasticsearch.index.VersionType;
import org.elasticsearch.index.bulk.stats.BulkOperationListener;
import org.elasticsearch.index.bulk.stats.BulkStats;
import org.elasticsearch.index.bulk.stats.ShardBulkStats;
import org.elasticsearch.index.cache.IndexCache;
import org.elasticsearch.index.cache.bitset.ShardBitsetFilterCache;
import org.elasticsearch.index.cache.query.TrivialQueryCachingPolicy;
import org.elasticsearch.index.cache.request.ShardRequestCache;
import org.elasticsearch.index.codec.CodecService;
import org.elasticsearch.index.codec.FieldInfosWithUsages;
import org.elasticsearch.index.engine.CommitStats;
import org.elasticsearch.index.engine.Engine;
import org.elasticsearch.index.engine.EngineConfig;
import org.elasticsearch.index.engine.EngineException;
import org.elasticsearch.index.engine.EngineFactory;
import org.elasticsearch.index.engine.ReadOnlyEngine;
import org.elasticsearch.index.engine.RefreshFailedEngineException;
import org.elasticsearch.index.engine.SafeCommitInfo;
import org.elasticsearch.index.engine.Segment;
import org.elasticsearch.index.engine.SegmentsStats;
import org.elasticsearch.index.engine.ThreadPoolMergeExecutorService;
import org.elasticsearch.index.fielddata.FieldDataStats;
import org.elasticsearch.index.fielddata.ShardFieldData;
import org.elasticsearch.index.flush.FlushStats;
import org.elasticsearch.index.get.GetStats;
import org.elasticsearch.index.get.ShardGetService;
import org.elasticsearch.index.mapper.DateFieldMapper;
import org.elasticsearch.index.mapper.DocumentMapper;
import org.elasticsearch.index.mapper.MappedFieldType;
import org.elasticsearch.index.mapper.MapperMetrics;
import org.elasticsearch.index.mapper.MapperService;
import org.elasticsearch.index.mapper.Mapping;
import org.elasticsearch.index.mapper.MappingLookup;
import org.elasticsearch.index.mapper.ParsedDocument;
import org.elasticsearch.index.mapper.SourceToParse;
import org.elasticsearch.index.mapper.Uid;
import org.elasticsearch.index.merge.MergeStats;
import org.elasticsearch.index.recovery.RecoveryStats;
import org.elasticsearch.index.refresh.RefreshStats;
import org.elasticsearch.index.search.stats.FieldUsageStats;
import org.elasticsearch.index.search.stats.SearchStats;
import org.elasticsearch.index.search.stats.ShardFieldUsageTracker;
import org.elasticsearch.index.search.stats.ShardSearchStats;
import org.elasticsearch.index.seqno.ReplicationTracker;
import org.elasticsearch.index.seqno.RetentionLease;
import org.elasticsearch.index.seqno.RetentionLeaseStats;
import org.elasticsearch.index.seqno.RetentionLeaseSyncer;
import org.elasticsearch.index.seqno.RetentionLeases;
import org.elasticsearch.index.seqno.SeqNoStats;
import org.elasticsearch.index.seqno.SequenceNumbers;
import org.elasticsearch.index.shard.AbstractIndexShardComponent;
import org.elasticsearch.index.shard.DenseVectorStats;
import org.elasticsearch.index.shard.DocsStats;
import org.elasticsearch.index.shard.GlobalCheckpointListeners;
import org.elasticsearch.index.shard.GlobalCheckpointSyncer;
import org.elasticsearch.index.shard.IllegalIndexShardStateException;
import org.elasticsearch.index.shard.IndexEventListener;
import org.elasticsearch.index.shard.IndexShardClosedException;
import org.elasticsearch.index.shard.IndexShardNotRecoveringException;
import org.elasticsearch.index.shard.IndexShardNotStartedException;
import org.elasticsearch.index.shard.IndexShardOperationPermits;
import org.elasticsearch.index.shard.IndexShardRecoveringException;
import org.elasticsearch.index.shard.IndexShardRelocatedException;
import org.elasticsearch.index.shard.IndexShardStartedException;
import org.elasticsearch.index.shard.IndexShardState;
import org.elasticsearch.index.shard.IndexingFailuresDebugListener;
import org.elasticsearch.index.shard.IndexingOperationListener;
import org.elasticsearch.index.shard.IndexingStats;
import org.elasticsearch.index.shard.InternalIndexingStats;
import org.elasticsearch.index.shard.LocalShardSnapshot;
import org.elasticsearch.index.shard.MultiEngineGet;
import org.elasticsearch.index.shard.PrimaryReplicaSyncer;
import org.elasticsearch.index.shard.RefreshListeners;
import org.elasticsearch.index.shard.ReplicationGroup;
import org.elasticsearch.index.shard.SearchOperationListener;
import org.elasticsearch.index.shard.ShardFieldStats;
import org.elasticsearch.index.shard.ShardId;
import org.elasticsearch.index.shard.ShardLongFieldRange;
import org.elasticsearch.index.shard.ShardNotInPrimaryModeException;
import org.elasticsearch.index.shard.ShardPath;
import org.elasticsearch.index.shard.ShardStateMetadata;
import org.elasticsearch.index.shard.SparseVectorStats;
import org.elasticsearch.index.shard.StoreRecovery;
import org.elasticsearch.index.similarity.SimilarityService;
import org.elasticsearch.index.store.Store;
import org.elasticsearch.index.store.StoreFileMetadata;
import org.elasticsearch.index.store.StoreStats;
import org.elasticsearch.index.translog.Translog;
import org.elasticsearch.index.translog.TranslogConfig;
import org.elasticsearch.index.translog.TranslogStats;
import org.elasticsearch.index.warmer.ShardIndexWarmerService;
import org.elasticsearch.index.warmer.WarmerStats;
import org.elasticsearch.indices.IndexingMemoryController;
import org.elasticsearch.indices.IndicesService;
import org.elasticsearch.indices.breaker.CircuitBreakerService;
import org.elasticsearch.indices.cluster.IndicesClusterStateService;
import org.elasticsearch.indices.recovery.PeerRecoveryTargetService;
import org.elasticsearch.indices.recovery.RecoveryFailedException;
import org.elasticsearch.indices.recovery.RecoverySettings;
import org.elasticsearch.indices.recovery.RecoveryState;
import org.elasticsearch.plugins.IndexStorePlugin;
import org.elasticsearch.repositories.RepositoriesService;
import org.elasticsearch.repositories.Repository;
import org.elasticsearch.rest.RestStatus;
import org.elasticsearch.search.internal.FieldUsageTrackingDirectoryReader;
import org.elasticsearch.search.suggest.completion.CompletionStats;
import org.elasticsearch.threadpool.ThreadPool;

public class IndexShard
extends AbstractIndexShardComponent
implements IndicesClusterStateService.Shard {
    private final ThreadPool threadPool;
    @Nullable
    private final ThreadPoolMergeExecutorService threadPoolMergeExecutorService;
    private final MapperService mapperService;
    private final IndexCache indexCache;
    private final Store store;
    private final InternalIndexingStats internalIndexingStats;
    private final ShardSearchStats searchStats = new ShardSearchStats();
    private final ShardFieldUsageTracker fieldUsageTracker;
    private final String shardUuid = UUIDs.randomBase64UUID();
    private final long shardCreationTime;
    private final ShardGetService getService;
    private final ShardIndexWarmerService shardWarmerService;
    private final ShardRequestCache requestCacheStats;
    private final ShardFieldData shardFieldData;
    private final ShardBitsetFilterCache shardBitsetFilterCache;
    private final Object mutex = new Object();
    private final String checkIndexOnStartup;
    private final CodecService codecService;
    private final Engine.Warmer warmer;
    private final SimilarityService similarityService;
    private final TranslogConfig translogConfig;
    private final IndexEventListener indexEventListener;
    private final QueryCachingPolicy cachingPolicy;
    private final Supplier<Sort> indexSortSupplier;
    final CircuitBreakerService circuitBreakerService;
    private final SearchOperationListener searchOperationListener;
    private final ShardBulkStats bulkOperationListener;
    private final GlobalCheckpointListeners globalCheckpointListeners;
    private final PendingReplicationActions pendingReplicationActions;
    private final ReplicationTracker replicationTracker;
    private final IndexStorePlugin.SnapshotCommitSupplier snapshotCommitSupplier;
    private final Engine.IndexCommitListener indexCommitListener;
    private FieldInfos fieldInfos;
    private volatile ShardFieldStats shardFieldStats;
    private static final boolean enableFieldHasValue = Booleans.parseBoolean(System.getProperty("es.field_caps_empty_fields_filter", Boolean.TRUE.toString()));
    protected volatile ShardRouting shardRouting;
    protected volatile IndexShardState state;
    private volatile SubscribableListener<Void> postRecoveryComplete;
    private volatile long pendingPrimaryTerm;
    private final Object engineMutex = new Object();
    private final AtomicReference<Engine> currentEngineReference = new AtomicReference();
    final EngineFactory engineFactory;
    private final IndexingOperationListener indexingOperationListeners;
    private final GlobalCheckpointSyncer globalCheckpointSyncer;
    private final RetentionLeaseSyncer retentionLeaseSyncer;
    @Nullable
    private volatile RecoveryState recoveryState;
    private final RecoveryStats recoveryStats = new RecoveryStats();
    private final MeanMetric refreshMetric = new MeanMetric();
    private final MeanMetric externalRefreshMetric = new MeanMetric();
    private final MeanMetric flushMetric = new MeanMetric();
    private final CounterMetric periodicFlushMetric = new CounterMetric();
    private final ShardEventListener shardEventListener = new ShardEventListener();
    private final ShardPath path;
    private final IndexShardOperationPermits indexShardOperationPermits;
    private static final EnumSet<IndexShardState> readAllowedStates = EnumSet.of(IndexShardState.STARTED, IndexShardState.POST_RECOVERY);
    private static final EnumSet<IndexShardState> writeAllowedStates = EnumSet.of(IndexShardState.RECOVERING, IndexShardState.POST_RECOVERY, IndexShardState.STARTED);
    private final CheckedFunction<DirectoryReader, DirectoryReader, IOException> readerWrapper;
    private final AtomicBoolean active = new AtomicBoolean();
    private final RefreshListeners refreshListeners;
    private final AtomicLong lastSearcherAccess = new AtomicLong();
    private final AtomicReference<Translog.Location> pendingRefreshLocation = new AtomicReference();
    private final RefreshPendingLocationListener refreshPendingLocationListener;
    private final RefreshFieldHasValueListener refreshFieldHasValueListener;
    private volatile boolean useRetentionLeasesInPeerRecovery;
    private final LongSupplier relativeTimeInNanosSupplier;
    private volatile long startedRelativeTimeInNanos;
    private volatile long indexingTimeBeforeShardStartedInNanos;
    private final SubscribableListener<Void> waitForEngineOrClosedShardListeners = new SubscribableListener();
    private volatile long globalCheckPointIfUnpromotable;
    private final AtomicBoolean primaryReplicaResyncInProgress = new AtomicBoolean();
    private static final VarHandle FIELD_INFOS;
    static boolean suppressCreateEngineErrors;
    private final AtomicInteger outstandingCleanFilesConditions = new AtomicInteger(0);
    private final Deque<Runnable> afterCleanFilesActions = new LinkedList<Runnable>();
    public static final int OPERATIONS_BLOCKED = -1;
    private final AtomicBoolean flushOrRollRunning = new AtomicBoolean();

    public IndexShard(ShardRouting shardRouting, IndexSettings indexSettings, ShardPath path, Store store, Supplier<Sort> indexSortSupplier, IndexCache indexCache, MapperService mapperService, SimilarityService similarityService, EngineFactory engineFactory, IndexEventListener indexEventListener, CheckedFunction<DirectoryReader, DirectoryReader, IOException> indexReaderWrapper, ThreadPool threadPool, ThreadPoolMergeExecutorService threadPoolMergeExecutorService, BigArrays bigArrays, Engine.Warmer warmer, List<SearchOperationListener> searchOperationListener, List<IndexingOperationListener> listeners, GlobalCheckpointSyncer globalCheckpointSyncer, RetentionLeaseSyncer retentionLeaseSyncer, CircuitBreakerService circuitBreakerService, IndexStorePlugin.SnapshotCommitSupplier snapshotCommitSupplier, LongSupplier relativeTimeInNanosSupplier, Engine.IndexCommitListener indexCommitListener, MapperMetrics mapperMetrics) throws IOException {
        super(shardRouting.shardId(), indexSettings);
        long primaryTerm;
        assert (shardRouting.initializing());
        this.shardRouting = shardRouting;
        Settings settings = indexSettings.getSettings();
        this.codecService = new CodecService(mapperService, bigArrays);
        this.warmer = warmer;
        this.similarityService = similarityService;
        Objects.requireNonNull(store, "Store must be provided to the index shard");
        this.engineFactory = Objects.requireNonNull(engineFactory);
        this.snapshotCommitSupplier = Objects.requireNonNull(snapshotCommitSupplier);
        this.store = store;
        this.indexSortSupplier = indexSortSupplier;
        this.indexEventListener = indexEventListener;
        this.threadPool = threadPool;
        this.threadPoolMergeExecutorService = threadPoolMergeExecutorService;
        this.mapperService = mapperService;
        this.indexCache = indexCache;
        this.internalIndexingStats = new InternalIndexingStats();
        IndexingFailuresDebugListener indexingFailuresDebugListener = new IndexingFailuresDebugListener(this);
        this.indexingOperationListeners = new IndexingOperationListener.CompositeListener(CollectionUtils.appendToCopyNoNullElements(listeners, this.internalIndexingStats, indexingFailuresDebugListener), this.logger);
        this.bulkOperationListener = new ShardBulkStats();
        this.globalCheckpointSyncer = globalCheckpointSyncer;
        this.retentionLeaseSyncer = Objects.requireNonNull(retentionLeaseSyncer);
        this.searchOperationListener = new SearchOperationListener.CompositeListener(CollectionUtils.appendToCopyNoNullElements(searchOperationListener, this.searchStats), this.logger);
        this.getService = new ShardGetService(indexSettings, this, mapperService, mapperMetrics);
        this.shardWarmerService = new ShardIndexWarmerService(this.shardId, indexSettings);
        this.requestCacheStats = new ShardRequestCache();
        this.shardFieldData = new ShardFieldData();
        this.shardBitsetFilterCache = new ShardBitsetFilterCache(this.shardId, indexSettings);
        this.state = IndexShardState.CREATED;
        this.path = path;
        this.circuitBreakerService = circuitBreakerService;
        this.logger.debug("state: [CREATED]");
        this.checkIndexOnStartup = indexSettings.getValue(IndexSettings.INDEX_CHECK_ON_STARTUP);
        this.translogConfig = new TranslogConfig(this.shardId, this.shardPath().resolveTranslog(), indexSettings, bigArrays);
        String aId = shardRouting.allocationId().getId();
        this.pendingPrimaryTerm = primaryTerm = indexSettings.getIndexMetadata().primaryTerm(this.shardId.id());
        this.globalCheckpointListeners = new GlobalCheckpointListeners(this.shardId, threadPool.scheduler(), this.logger);
        this.pendingReplicationActions = new PendingReplicationActions(this.shardId, threadPool);
        this.replicationTracker = new ReplicationTracker(this.shardId, aId, indexSettings, primaryTerm, -2L, this.globalCheckpointListeners::globalCheckpointUpdated, threadPool::absoluteTimeInMillis, (retentionLeases, listener) -> retentionLeaseSyncer.sync(this.shardId, aId, this.getPendingPrimaryTerm(), (RetentionLeases)retentionLeases, (ActionListener<ReplicationResponse>)listener), this::getSafeCommitInfo, this.pendingReplicationActions);
        this.fieldUsageTracker = new ShardFieldUsageTracker();
        this.shardCreationTime = threadPool.absoluteTimeInMillis();
        this.cachingPolicy = IndexModule.INDEX_QUERY_CACHE_EVERYTHING_SETTING.get(settings) != false ? TrivialQueryCachingPolicy.ALWAYS : new UsageTrackingQueryCachingPolicy();
        this.indexShardOperationPermits = new IndexShardOperationPermits(this.shardId, threadPool);
        this.readerWrapper = indexReaderWrapper;
        this.refreshListeners = new RefreshListeners(indexSettings::getMaxRefreshListeners, () -> this.refresh("too_many_listeners"), this.logger, threadPool.getThreadContext(), this.externalRefreshMetric);
        this.lastSearcherAccess.set(threadPool.relativeTimeInMillis());
        IndexShard.persistMetadata(path, indexSettings, shardRouting, null, this.logger);
        this.useRetentionLeasesInPeerRecovery = this.replicationTracker.hasAllPeerRecoveryRetentionLeases();
        this.refreshPendingLocationListener = new RefreshPendingLocationListener();
        this.refreshFieldHasValueListener = new RefreshFieldHasValueListener();
        this.relativeTimeInNanosSupplier = relativeTimeInNanosSupplier;
        this.indexCommitListener = indexCommitListener;
    }

    public ThreadPool getThreadPool() {
        return this.threadPool;
    }

    public Store store() {
        return this.store;
    }

    public Sort getIndexSort() {
        return this.indexSortSupplier.get();
    }

    public ShardGetService getService() {
        return this.getService;
    }

    public ShardBitsetFilterCache shardBitsetFilterCache() {
        return this.shardBitsetFilterCache;
    }

    public MapperService mapperService() {
        return this.mapperService;
    }

    public SearchOperationListener getSearchOperationListener() {
        return this.searchOperationListener;
    }

    public BulkOperationListener getBulkOperationListener() {
        return this.bulkOperationListener;
    }

    public IndexingOperationListener getIndexingOperationListener() {
        return this.indexingOperationListeners;
    }

    public ShardIndexWarmerService warmerService() {
        return this.shardWarmerService;
    }

    public ShardRequestCache requestCache() {
        return this.requestCacheStats;
    }

    public ShardFieldData fieldData() {
        return this.shardFieldData;
    }

    public boolean isSystem() {
        return this.indexSettings.getIndexMetadata().isSystem();
    }

    public long getPendingPrimaryTerm() {
        return this.pendingPrimaryTerm;
    }

    public long getOperationPrimaryTerm() {
        return this.replicationTracker.getOperationPrimaryTerm();
    }

    public String getShardUuid() {
        return this.shardUuid;
    }

    public long getShardCreationTime() {
        return this.shardCreationTime;
    }

    @Override
    public ShardRouting routingEntry() {
        return this.shardRouting;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void updateShardState(ShardRouting newRouting, long newPrimaryTerm, BiConsumer<IndexShard, ActionListener<PrimaryReplicaSyncer.ResyncTask>> primaryReplicaSyncer, long applyingClusterStateVersion, Set<String> inSyncAllocationIds, IndexShardRoutingTable routingTable) throws IOException {
        ShardRouting currentRouting;
        Object object = this.mutex;
        synchronized (object) {
            currentRouting = this.shardRouting;
            assert (currentRouting != null);
            if (!newRouting.shardId().equals(this.shardId())) {
                throw new IllegalArgumentException("Trying to set a routing entry with shardId " + String.valueOf(newRouting.shardId()) + " on a shard with shardId " + String.valueOf(this.shardId()));
            }
            if (!newRouting.isSameAllocation(currentRouting)) {
                throw new IllegalArgumentException("Trying to set a routing entry with a different allocation. Current " + String.valueOf(currentRouting) + ", new " + String.valueOf(newRouting));
            }
            if (currentRouting.primary() && !newRouting.primary()) {
                throw new IllegalArgumentException("illegal state: trying to move shard from primary mode to replica mode. Current " + String.valueOf(currentRouting) + ", new " + String.valueOf(newRouting));
            }
            if (newRouting.primary()) {
                this.replicationTracker.updateFromMaster(applyingClusterStateVersion, inSyncAllocationIds, routingTable);
            }
            if (this.state == IndexShardState.POST_RECOVERY && newRouting.active()) {
                assert (!currentRouting.active()) : "we are in POST_RECOVERY, but our shard routing is active " + String.valueOf(currentRouting);
                assert (!currentRouting.isRelocationTarget() || !currentRouting.primary() || this.replicationTracker.isPrimaryMode()) : "a primary relocation is completed by the master, but primary mode is not active " + String.valueOf(currentRouting);
                this.changeState(IndexShardState.STARTED, "global state is [" + String.valueOf((Object)newRouting.state()) + "]");
                this.startedRelativeTimeInNanos = this.getRelativeTimeInNanos();
                this.indexingTimeBeforeShardStartedInNanos = this.internalIndexingStats.totalIndexingTimeInNanos();
            } else if (currentRouting.primary() && currentRouting.relocating() && this.replicationTracker.isRelocated() && (!newRouting.relocating() || !newRouting.equalsIgnoringMetadata(currentRouting))) {
                throw new IndexShardRelocatedException(this.shardId(), "Shard is marked as relocated, cannot safely move to state " + String.valueOf((Object)newRouting.state()));
            }
            if (newRouting.active() && this.state != IndexShardState.STARTED && this.state != IndexShardState.CLOSED) {
                assert (!newRouting.primary()) : "primary routing is active, but local shard state isn't. routing: " + String.valueOf(newRouting) + ", local state: " + String.valueOf((Object)this.state);
                throw new IllegalIndexShardStateException(this.shardId, this.state, "master processed stale shard-started event, failing shard", new Object[0]);
            }
            IndexShard.persistMetadata(this.path, this.indexSettings, newRouting, currentRouting, this.logger);
            CountDownLatch shardStateUpdated = new CountDownLatch(1);
            if (newRouting.primary()) {
                if (newPrimaryTerm == this.pendingPrimaryTerm) {
                    if (currentRouting.initializing() && !currentRouting.isRelocationTarget() && newRouting.active()) {
                        this.replicationTracker.activatePrimaryMode(this.getLocalCheckpoint());
                        this.ensurePeerRecoveryRetentionLeasesExist();
                    }
                } else {
                    assert (!currentRouting.primary()) : "term is only increased as part of primary promotion";
                    assert (!newRouting.initializing()) : "a started primary shard should never update its term; shard " + String.valueOf(newRouting) + ", current term [" + this.pendingPrimaryTerm + "], new term [" + newPrimaryTerm + "]";
                    assert (newPrimaryTerm > this.pendingPrimaryTerm) : "primary terms can only go up; current term [" + this.pendingPrimaryTerm + "], new term [" + newPrimaryTerm + "]";
                    boolean resyncStarted = this.primaryReplicaResyncInProgress.compareAndSet(false, true);
                    if (!resyncStarted) {
                        throw new IllegalStateException("cannot start resync while it's already in progress");
                    }
                    this.bumpPrimaryTerm(newPrimaryTerm, () -> {
                        shardStateUpdated.await();
                        assert (this.pendingPrimaryTerm == newPrimaryTerm) : "shard term changed on primary. expected [" + newPrimaryTerm + "] but was [" + this.pendingPrimaryTerm + "], current routing: " + String.valueOf(currentRouting) + ", new routing: " + String.valueOf(newRouting);
                        assert (this.getOperationPrimaryTerm() == newPrimaryTerm);
                        try {
                            this.replicationTracker.activatePrimaryMode(this.getLocalCheckpoint());
                            this.ensurePeerRecoveryRetentionLeasesExist();
                            Engine engine = this.getEngine();
                            engine.restoreLocalHistoryFromTranslog((resettingEngine, snapshot) -> this.runTranslogRecovery(resettingEngine, snapshot, Engine.Operation.Origin.LOCAL_RESET, () -> {}));
                            engine.rollTranslogGeneration();
                            engine.fillSeqNoGaps(newPrimaryTerm);
                            this.replicationTracker.updateLocalCheckpoint(currentRouting.allocationId().getId(), this.getLocalCheckpoint());
                            primaryReplicaSyncer.accept(this, new ActionListener<PrimaryReplicaSyncer.ResyncTask>(){

                                @Override
                                public void onResponse(PrimaryReplicaSyncer.ResyncTask resyncTask) {
                                    IndexShard.this.logger.info("primary-replica resync completed with {} operations", (Object)resyncTask.getResyncedOperations());
                                    boolean resyncCompleted = IndexShard.this.primaryReplicaResyncInProgress.compareAndSet(true, false);
                                    assert (resyncCompleted) : "primary-replica resync finished but was not started";
                                }

                                @Override
                                public void onFailure(Exception e) {
                                    boolean resyncCompleted = IndexShard.this.primaryReplicaResyncInProgress.compareAndSet(true, false);
                                    assert (resyncCompleted) : "primary-replica resync finished but was not started";
                                    if (IndexShard.this.state != IndexShardState.CLOSED) {
                                        try {
                                            IndexShard.this.failShard("exception during primary-replica resync", e);
                                        }
                                        catch (AlreadyClosedException alreadyClosedException) {
                                            // empty catch block
                                        }
                                    }
                                }
                            });
                        }
                        catch (AlreadyClosedException alreadyClosedException) {
                            // empty catch block
                        }
                    }, null);
                }
            }
            this.shardRouting = newRouting;
            assert (!this.shardRouting.primary() || !this.shardRouting.started() || this.indexShardOperationPermits.isBlocked() || this.replicationTracker.isPrimaryMode()) : "a started primary with non-pending operation term must be in primary mode " + String.valueOf(this.shardRouting);
            shardStateUpdated.countDown();
        }
        if (!currentRouting.active() && newRouting.active()) {
            this.indexEventListener.afterIndexShardStarted(this);
        }
        if (!newRouting.equals(currentRouting)) {
            this.indexEventListener.shardRoutingChanged(this, currentRouting, newRouting);
        }
        if (this.indexSettings.isSoftDeleteEnabled() && !this.useRetentionLeasesInPeerRecovery) {
            RetentionLeases retentionLeases = this.replicationTracker.getRetentionLeases();
            boolean allShardsUseRetentionLeases = true;
            for (int copy = 0; copy < routingTable.size(); ++copy) {
                ShardRouting shardRoutingReloc;
                ShardRouting shardRouting = routingTable.shard(copy);
                if (!shardRouting.isPromotableToPrimary()) continue;
                if (!shardRouting.assignedToNode() || !retentionLeases.contains(ReplicationTracker.getPeerRecoveryRetentionLeaseId(shardRouting))) {
                    allShardsUseRetentionLeases = false;
                    break;
                }
                if (!this.shardRouting.relocating() || (shardRoutingReloc = this.shardRouting.getTargetRelocatingShard()).assignedToNode() && retentionLeases.contains(ReplicationTracker.getPeerRecoveryRetentionLeaseId(shardRoutingReloc))) continue;
                allShardsUseRetentionLeases = false;
                break;
            }
            this.useRetentionLeasesInPeerRecovery = allShardsUseRetentionLeases;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IndexShardState markAsRecovering(String reason, RecoveryState recoveryState) throws IndexShardStartedException, IndexShardRelocatedException, IndexShardRecoveringException, IndexShardClosedException {
        Object object = this.mutex;
        synchronized (object) {
            if (this.state == IndexShardState.CLOSED) {
                throw new IndexShardClosedException(this.shardId);
            }
            if (this.state == IndexShardState.STARTED) {
                throw new IndexShardStartedException(this.shardId);
            }
            if (this.state == IndexShardState.RECOVERING) {
                throw new IndexShardRecoveringException(this.shardId);
            }
            if (this.state == IndexShardState.POST_RECOVERY) {
                throw new IndexShardRecoveringException(this.shardId);
            }
            this.recoveryState = recoveryState;
            return this.changeState(IndexShardState.RECOVERING, reason);
        }
    }

    public void relocated(final String targetNodeId, final String targetAllocationId, final BiConsumer<ReplicationTracker.PrimaryContext, ActionListener<Void>> consumer, final ActionListener<Void> listener) throws IllegalIndexShardStateException, IllegalStateException {
        assert (this.shardRouting.primary()) : "only primaries can be marked as relocated: " + String.valueOf(this.shardRouting);
        try (final Releasable forceRefreshes = this.refreshListeners.forceRefreshes();){
            this.indexShardOperationPermits.blockOperations(new ActionListener<Releasable>(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void onResponse(Releasable releasable) {
                    boolean success = false;
                    try {
                        forceRefreshes.close();
                        assert (IndexShard.this.indexShardOperationPermits.getActiveOperationsCount() == -1) : "in-flight operations in progress while moving shard state to relocated";
                        IndexShard.this.verifyRelocatingState(targetNodeId);
                        ReplicationTracker.PrimaryContext primaryContext = IndexShard.this.replicationTracker.startRelocationHandoff(targetAllocationId);
                        final ActionListener wrappedInnerListener = ActionListener.runBefore(listener, Releasables.releaseOnce(releasable)::close);
                        ActionListener<Void> wrappedListener = new ActionListener<Void>(){

                            /*
                             * WARNING - Removed try catching itself - possible behaviour change.
                             */
                            @Override
                            public void onResponse(Void unused) {
                                try {
                                    Object object = IndexShard.this.mutex;
                                    synchronized (object) {
                                        IndexShard.this.verifyRelocatingState(targetNodeId);
                                        IndexShard.this.replicationTracker.completeRelocationHandoff();
                                    }
                                    wrappedInnerListener.onResponse(null);
                                }
                                catch (Exception e) {
                                    this.onFailure(e);
                                }
                            }

                            @Override
                            public void onFailure(Exception e) {
                                try {
                                    IndexShard.this.replicationTracker.abortRelocationHandoff();
                                }
                                catch (Exception inner) {
                                    e.addSuppressed(inner);
                                }
                                wrappedInnerListener.onFailure(e);
                            }
                        };
                        try {
                            consumer.accept(primaryContext, wrappedListener);
                        }
                        catch (Exception e) {
                            wrappedListener.onFailure(e);
                        }
                        success = true;
                    }
                    catch (Exception e) {
                        listener.onFailure(e);
                    }
                    finally {
                        if (!success) {
                            releasable.close();
                        }
                    }
                }

                @Override
                public void onFailure(Exception e) {
                    if (e instanceof TimeoutException) {
                        IndexShard.this.logger.warn("timed out waiting for relocation hand-off to complete");
                        IndexShard.this.failShard("timed out waiting for relocation hand-off to complete", null);
                        listener.onFailure(new IndexShardClosedException(IndexShard.this.shardId(), "timed out waiting for relocation hand-off to complete"));
                    } else {
                        listener.onFailure(e);
                    }
                }
            }, 30L, TimeUnit.MINUTES, EsExecutors.DIRECT_EXECUTOR_SERVICE);
        }
    }

    private void verifyRelocatingState(String targetNodeId) {
        if (this.state != IndexShardState.STARTED) {
            throw new IndexShardNotStartedException(this.shardId, this.state);
        }
        if (!this.shardRouting.relocating()) {
            throw new IllegalIndexShardStateException(this.shardId, IndexShardState.STARTED, ": shard is no longer relocating " + String.valueOf(this.shardRouting), new Object[0]);
        }
        if (!Objects.equals(targetNodeId, this.shardRouting.relocatingNodeId())) {
            throw new IllegalIndexShardStateException(this.shardId, IndexShardState.STARTED, ": shard is no longer relocating to node [" + targetNodeId + "]: " + String.valueOf(this.shardRouting), new Object[0]);
        }
        if (this.primaryReplicaResyncInProgress.get()) {
            throw new IllegalIndexShardStateException(this.shardId, IndexShardState.STARTED, ": primary relocation is forbidden while primary-replica resync is in progress " + String.valueOf(this.shardRouting), new Object[0]);
        }
    }

    @Override
    public IndexShardState state() {
        return this.state;
    }

    private IndexShardState changeState(IndexShardState newState, String reason) {
        assert (Thread.holdsLock(this.mutex));
        this.logger.debug("state: [{}]->[{}], reason [{}]", (Object)this.state, (Object)newState, (Object)reason);
        IndexShardState previousState = this.state;
        this.state = newState;
        this.indexEventListener.indexShardStateChanged(this, previousState, newState, reason);
        return previousState;
    }

    public Engine.IndexResult applyIndexOperationOnPrimary(long version, VersionType versionType, SourceToParse sourceToParse, long ifSeqNo, long ifPrimaryTerm, long autoGeneratedTimestamp, boolean isRetry) throws IOException {
        assert (versionType.validateVersionForWrites(version));
        return this.applyIndexOperation(this.getEngine(), -2L, this.getOperationPrimaryTerm(), version, versionType, ifSeqNo, ifPrimaryTerm, autoGeneratedTimestamp, isRetry, Engine.Operation.Origin.PRIMARY, sourceToParse);
    }

    public Engine.IndexResult applyIndexOperationOnReplica(long seqNo, long opPrimaryTerm, long version, long autoGeneratedTimeStamp, boolean isRetry, SourceToParse sourceToParse) throws IOException {
        return this.applyIndexOperation(this.getEngine(), seqNo, opPrimaryTerm, version, null, -2L, 0L, autoGeneratedTimeStamp, isRetry, Engine.Operation.Origin.REPLICA, sourceToParse);
    }

    private Engine.IndexResult applyIndexOperation(Engine engine, long seqNo, long opPrimaryTerm, long version, @Nullable VersionType versionType, long ifSeqNo, long ifPrimaryTerm, long autoGeneratedTimeStamp, boolean isRetry, Engine.Operation.Origin origin, SourceToParse sourceToParse) throws IOException {
        Engine.Index operation;
        assert (opPrimaryTerm <= this.getOperationPrimaryTerm()) : "op term [ " + opPrimaryTerm + " ] > shard term [" + this.getOperationPrimaryTerm() + "]";
        this.ensureWriteAllowed(origin);
        try {
            operation = IndexShard.prepareIndex(this.mapperService, sourceToParse, seqNo, opPrimaryTerm, version, versionType, origin, autoGeneratedTimeStamp, isRetry, ifSeqNo, ifPrimaryTerm, this.getRelativeTimeInNanos());
            Mapping update = operation.parsedDoc().dynamicMappingsUpdate();
            if (update != null) {
                return new Engine.IndexResult(update, operation.parsedDoc().id());
            }
        }
        catch (Exception e) {
            this.verifyNotClosed(e);
            return new Engine.IndexResult(e, version, opPrimaryTerm, seqNo, sourceToParse.id());
        }
        return this.index(engine, operation);
    }

    public FieldInfos getFieldInfos() {
        FieldInfos res = this.fieldInfos;
        if (res == null) {
            FieldInfos read = this.loadFieldInfos();
            FieldInfos existing = FIELD_INFOS.compareAndExchange(this, null, read);
            return existing == null ? read : existing;
        }
        return res;
    }

    public static Engine.Index prepareIndex(MapperService mapperService, SourceToParse source, long seqNo, long primaryTerm, long version, VersionType versionType, Engine.Operation.Origin origin, long autoGeneratedIdTimestamp, boolean isRetry, long ifSeqNo, long ifPrimaryTerm, long startTimeInNanos) {
        assert (source.dynamicTemplates().isEmpty() || origin == Engine.Operation.Origin.PRIMARY) : "dynamic_templates parameter can only be associated with primary operations";
        DocumentMapper documentMapper = mapperService.documentMapper();
        Mapping mapping = null;
        if (documentMapper == null) {
            documentMapper = DocumentMapper.createEmpty(mapperService);
            mapping = documentMapper.mapping();
        }
        ParsedDocument doc = documentMapper.parse(source);
        if (mapping != null) {
            doc.addDynamicMappingsUpdate(mapping);
        }
        return new Engine.Index(Uid.encodeId(doc.id()), doc, seqNo, primaryTerm, version, versionType, origin, startTimeInNanos, autoGeneratedIdTimestamp, isRetry, ifSeqNo, ifPrimaryTerm);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Engine.IndexResult index(Engine engine, Engine.Index index) throws IOException {
        try {
            Engine.IndexResult result;
            Engine.Index preIndex = this.indexingOperationListeners.preIndex(this.shardId, index);
            try {
                if (this.logger.isTraceEnabled()) {
                    this.logger.trace("index [{}] seq# [{}] allocation-id [{}] primaryTerm [{}] operationPrimaryTerm [{}] origin [{}]", (Object)preIndex.id(), (Object)preIndex.seqNo(), (Object)this.routingEntry().allocationId(), (Object)preIndex.primaryTerm(), (Object)this.getOperationPrimaryTerm(), (Object)preIndex.origin());
                }
                result = engine.index(preIndex);
                if (this.logger.isTraceEnabled()) {
                    this.logger.trace("index-done [{}] seq# [{}] allocation-id [{}] primaryTerm [{}] operationPrimaryTerm [{}] origin [{}] result-seq# [{}] result-term [{}] failure [{}]", (Object)preIndex.id(), (Object)preIndex.seqNo(), (Object)this.routingEntry().allocationId(), (Object)preIndex.primaryTerm(), (Object)this.getOperationPrimaryTerm(), (Object)preIndex.origin(), (Object)result.getSeqNo(), (Object)result.getTerm(), (Object)result.getFailure());
                }
            }
            catch (Exception e) {
                if (this.logger.isTraceEnabled()) {
                    this.logger.trace(() -> Strings.format("index-fail [%s] seq# [%s] allocation-id [%s] primaryTerm [%s] operationPrimaryTerm [%s] origin [%s]", new Object[]{preIndex.id(), preIndex.seqNo(), this.routingEntry().allocationId(), preIndex.primaryTerm(), this.getOperationPrimaryTerm(), preIndex.origin()}), (Throwable)e);
                }
                this.indexingOperationListeners.postIndex(this.shardId, preIndex, e);
                throw e;
            }
            this.indexingOperationListeners.postIndex(this.shardId, preIndex, result);
            Engine.IndexResult indexResult = result;
            return indexResult;
        }
        finally {
            this.active.set(true);
        }
    }

    public Engine.NoOpResult markSeqNoAsNoop(long seqNo, long opPrimaryTerm, String reason) throws IOException {
        return this.markSeqNoAsNoop(this.getEngine(), seqNo, opPrimaryTerm, reason, Engine.Operation.Origin.REPLICA);
    }

    private Engine.NoOpResult markSeqNoAsNoop(Engine engine, long seqNo, long opPrimaryTerm, String reason, Engine.Operation.Origin origin) throws IOException {
        assert (opPrimaryTerm <= this.getOperationPrimaryTerm()) : "op term [ " + opPrimaryTerm + " ] > shard term [" + this.getOperationPrimaryTerm() + "]";
        long startTime = System.nanoTime();
        this.ensureWriteAllowed(origin);
        Engine.NoOp noOp = new Engine.NoOp(seqNo, opPrimaryTerm, origin, startTime, reason);
        return this.noOp(engine, noOp);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Engine.NoOpResult noOp(Engine engine, Engine.NoOp noOp) throws IOException {
        try {
            if (this.logger.isTraceEnabled()) {
                this.logger.trace("noop (seq# [{}])", (Object)noOp.seqNo());
            }
            Engine.NoOpResult noOpResult = engine.noOp(noOp);
            return noOpResult;
        }
        finally {
            this.active.set(true);
        }
    }

    public Engine.IndexResult getFailedIndexResult(Exception e, long version, String id) {
        return new Engine.IndexResult(e, version, id);
    }

    public Engine.DeleteResult getFailedDeleteResult(Exception e, long version, String id) {
        return new Engine.DeleteResult(e, version, this.getOperationPrimaryTerm(), id);
    }

    public Engine.DeleteResult applyDeleteOperationOnPrimary(long version, String id, VersionType versionType, long ifSeqNo, long ifPrimaryTerm) throws IOException {
        assert (versionType.validateVersionForWrites(version));
        return this.applyDeleteOperation(this.getEngine(), -2L, this.getOperationPrimaryTerm(), version, id, versionType, ifSeqNo, ifPrimaryTerm, Engine.Operation.Origin.PRIMARY);
    }

    public Engine.DeleteResult applyDeleteOperationOnReplica(long seqNo, long opPrimaryTerm, long version, String id) throws IOException {
        return this.applyDeleteOperation(this.getEngine(), seqNo, opPrimaryTerm, version, id, null, -2L, 0L, Engine.Operation.Origin.REPLICA);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Engine.DeleteResult applyDeleteOperation(Engine engine, long seqNo, long opPrimaryTerm, long version, String id, @Nullable VersionType versionType, long ifSeqNo, long ifPrimaryTerm, Engine.Operation.Origin origin) throws IOException {
        assert (opPrimaryTerm <= this.getOperationPrimaryTerm()) : "op term [ " + opPrimaryTerm + " ] > shard term [" + this.getOperationPrimaryTerm() + "]";
        this.ensureWriteAllowed(origin);
        try {
            Engine.DeleteResult result;
            Engine.Delete delete = this.indexingOperationListeners.preDelete(this.shardId, IndexShard.prepareDelete(id, seqNo, opPrimaryTerm, version, versionType, origin, ifSeqNo, ifPrimaryTerm));
            try {
                if (this.logger.isTraceEnabled()) {
                    this.logger.trace("delete [{}] (seq no [{}])", (Object)delete.uid(), (Object)delete.seqNo());
                }
                result = engine.delete(delete);
            }
            catch (Exception e) {
                this.indexingOperationListeners.postDelete(this.shardId, delete, e);
                throw e;
            }
            this.indexingOperationListeners.postDelete(this.shardId, delete, result);
            Engine.DeleteResult deleteResult = result;
            return deleteResult;
        }
        finally {
            this.active.set(true);
        }
    }

    public static Engine.Delete prepareDelete(String id, long seqNo, long primaryTerm, long version, VersionType versionType, Engine.Operation.Origin origin, long ifSeqNo, long ifPrimaryTerm) {
        long startTime = System.nanoTime();
        return new Engine.Delete(id, Uid.encodeId(id), seqNo, primaryTerm, version, versionType, origin, startTime, ifSeqNo, ifPrimaryTerm);
    }

    public Engine.GetResult get(Engine.Get get) {
        return this.innerGet(get, false, this::wrapSearcher);
    }

    public void mget(Consumer<MultiEngineGet> mgetter) {
        MultiEngineGet mget = new MultiEngineGet(this::wrapSearcher){

            @Override
            public Engine.GetResult get(Engine.Get get) {
                return IndexShard.this.innerGet(get, false, this::wrapSearchSearchWithCache);
            }
        };
        try {
            mgetter.accept(mget);
        }
        finally {
            mget.releaseCachedSearcher();
        }
    }

    public Engine.GetResult getFromTranslog(Engine.Get get) {
        assert (get.realtime());
        return this.innerGet(get, true, this::wrapSearcher);
    }

    private Engine.GetResult innerGet(Engine.Get get, boolean translogOnly, Function<Engine.Searcher, Engine.Searcher> searcherWrapper) {
        this.readAllowed();
        MappingLookup mappingLookup = this.mapperService.mappingLookup();
        if (!mappingLookup.hasMappings()) {
            return Engine.GetResult.NOT_EXISTS;
        }
        if (this.indexSettings.getIndexVersionCreated().isLegacyIndexVersion()) {
            throw new IllegalStateException("get operations not allowed on a legacy index");
        }
        if (translogOnly) {
            return this.getEngine().getFromTranslog(get, mappingLookup, this.mapperService.documentParser(), searcherWrapper);
        }
        return this.getEngine().get(get, mappingLookup, this.mapperService.documentParser(), searcherWrapper);
    }

    public Engine.RefreshResult refresh(String source) {
        this.verifyNotClosed();
        this.logger.trace("refresh with source [{}]", (Object)source);
        return this.getEngine().refresh(source);
    }

    public void externalRefresh(String source, ActionListener<Engine.RefreshResult> listener) {
        this.verifyNotClosed();
        this.getEngine().externalRefresh(source, listener);
    }

    public long getWritingBytes() {
        Engine engine = this.getEngineOrNull();
        if (engine == null) {
            return 0L;
        }
        return engine.getWritingBytes();
    }

    public RefreshStats refreshStats() {
        int listeners = this.refreshListeners.pendingCount();
        return new RefreshStats(this.refreshMetric.count(), TimeUnit.NANOSECONDS.toMillis(this.refreshMetric.sum()), this.externalRefreshMetric.count(), TimeUnit.NANOSECONDS.toMillis(this.externalRefreshMetric.sum()), listeners);
    }

    public FlushStats flushStats() {
        Engine engine = this.getEngineOrNull();
        return new FlushStats(this.flushMetric.count(), this.periodicFlushMetric.count(), TimeUnit.NANOSECONDS.toMillis(this.flushMetric.sum()), engine != null ? engine.getTotalFlushTimeExcludingWaitingOnLockInMillis() : 0L);
    }

    public DocsStats docStats() {
        this.readAllowed();
        return this.getEngine().docStats();
    }

    public CommitStats commitStats() {
        return this.getEngine().commitStats();
    }

    public SeqNoStats seqNoStats() {
        return this.getEngine().getSeqNoStats(this.replicationTracker.getGlobalCheckpoint());
    }

    public IndexingStats indexingStats() {
        long throttleTimeInMillis;
        boolean throttled;
        Engine engine = this.getEngineOrNull();
        if (engine == null) {
            throttled = false;
            throttleTimeInMillis = 0L;
        } else {
            throttled = engine.isThrottled();
            throttleTimeInMillis = engine.getIndexThrottleTimeInMillis();
        }
        return this.internalIndexingStats.stats(throttled, throttleTimeInMillis, this.indexingTimeBeforeShardStartedInNanos, this.getRelativeTimeInNanos() - this.startedRelativeTimeInNanos);
    }

    public SearchStats searchStats(String ... groups) {
        return this.searchStats.stats(groups);
    }

    public FieldUsageStats fieldUsageStats(String ... fields) {
        return this.fieldUsageTracker.stats(fields);
    }

    public GetStats getStats() {
        return this.getService.stats();
    }

    public StoreStats storeStats() {
        try {
            RecoveryState recoveryState = this.recoveryState;
            if (DiskThresholdDecider.SETTING_IGNORE_DISK_WATERMARKS.get(this.indexSettings.getSettings()).booleanValue()) {
                return this.store.stats(0L, size -> 0L);
            }
            long bytesStillToRecover = recoveryState == null ? -1L : recoveryState.getIndex().bytesStillToRecover();
            long reservedBytes = bytesStillToRecover == -1L ? -1L : bytesStillToRecover;
            return this.store.stats(reservedBytes, LongUnaryOperator.identity());
        }
        catch (IOException e) {
            this.failShard("Failing shard because of exception during storeStats", e);
            throw new ElasticsearchException("io exception while building 'store stats'", (Throwable)e, new Object[0]);
        }
    }

    public MergeStats mergeStats() {
        Engine engine = this.getEngineOrNull();
        if (engine == null) {
            return new MergeStats();
        }
        return engine.getMergeStats();
    }

    public SegmentsStats segmentStats(boolean includeSegmentFileSizes, boolean includeUnloadedSegments) {
        SegmentsStats segmentsStats = this.getEngine().segmentsStats(includeSegmentFileSizes, includeUnloadedSegments);
        segmentsStats.addBitsetMemoryInBytes(this.shardBitsetFilterCache.getMemorySizeInBytes());
        return segmentsStats;
    }

    public WarmerStats warmerStats() {
        return this.shardWarmerService.stats();
    }

    public FieldDataStats fieldDataStats(String ... fields) {
        return this.shardFieldData.stats(fields);
    }

    public TranslogStats translogStats() {
        return this.getEngine().getTranslogStats();
    }

    public CompletionStats completionStats(String ... fields) {
        this.readAllowed();
        return this.getEngine().completionStats(fields);
    }

    public DenseVectorStats denseVectorStats() {
        this.readAllowed();
        MappingLookup mappingLookup = this.mapperService != null ? this.mapperService.mappingLookup() : null;
        return this.getEngine().denseVectorStats(mappingLookup);
    }

    public SparseVectorStats sparseVectorStats() {
        this.readAllowed();
        MappingLookup mappingLookup = this.mapperService != null ? this.mapperService.mappingLookup() : null;
        return this.getEngine().sparseVectorStats(mappingLookup);
    }

    public BulkStats bulkStats() {
        return this.bulkOperationListener.stats();
    }

    public boolean flush(FlushRequest request) {
        PlainActionFuture<Boolean> future = new PlainActionFuture<Boolean>();
        this.flush(request, future);
        return future.actionGet();
    }

    public void flush(FlushRequest request, ActionListener<Boolean> listener) {
        boolean waitIfOngoing = request.waitIfOngoing();
        boolean force = request.force();
        this.logger.trace("flush with {}", (Object)request);
        ActionListener.run(listener, l -> {
            this.verifyNotClosed();
            long startTime = System.nanoTime();
            this.getEngine().flush(force, waitIfOngoing, ActionListener.runBefore(l.map(Engine.FlushResult::flushPerformed), () -> this.flushMetric.inc(System.nanoTime() - startTime)));
        });
    }

    public boolean hasTranslog() {
        return this.translogConfig.hasTranslog();
    }

    public long readGlobalCheckpointForRecovery(Map<String, String> commitUserData) throws IOException {
        if (this.hasTranslog()) {
            return Translog.readGlobalCheckpoint(this.translogConfig.getTranslogPath(), commitUserData.get("translog_uuid"));
        }
        return Long.parseLong(commitUserData.get("local_checkpoint"));
    }

    public void trimTranslog() {
        this.verifyNotClosed();
        Engine engine = this.getEngine();
        engine.trimUnreferencedTranslogFiles();
    }

    public void rollTranslogGeneration() {
        Engine engine = this.getEngine();
        engine.rollTranslogGeneration();
    }

    public void forceMerge(ForceMergeRequest forceMerge) throws IOException {
        IndexShardState state = this.state;
        if (state != IndexShardState.STARTED) {
            throw new IllegalIndexShardStateException(this.shardId, state, "operation only allowed when shard is active", new Object[0]);
        }
        this.logger.trace("force merge with {}", (Object)forceMerge);
        Engine engine = this.getEngine();
        engine.forceMerge(forceMerge.flush(), forceMerge.maxNumSegments(), forceMerge.onlyExpungeDeletes(), forceMerge.forceMergeUUID());
    }

    public void triggerPendingMerges() throws IOException {
        switch (this.state) {
            case STARTED: 
            case POST_RECOVERY: {
                this.getEngine().forceMerge(false, -1, false, null);
            }
        }
    }

    public Engine.IndexCommitRef acquireLastIndexCommit(boolean flushFirst) throws EngineException {
        IndexShardState state = this.state;
        if (state == IndexShardState.STARTED || state == IndexShardState.CLOSED) {
            return this.getEngine().acquireLastIndexCommit(flushFirst);
        }
        throw new IllegalIndexShardStateException(this.shardId, state, "snapshot is not allowed", new Object[0]);
    }

    public Engine.IndexCommitRef acquireIndexCommitForSnapshot() throws EngineException {
        IndexShardState state = this.state;
        if (state == IndexShardState.STARTED) {
            return this.getEngine().acquireIndexCommitForSnapshot();
        }
        throw new IllegalIndexShardStateException(this.shardId, state, "snapshot is not allowed", new Object[0]);
    }

    public Engine.IndexCommitRef acquireSafeIndexCommit() throws EngineException {
        IndexShardState state = this.state;
        if (state == IndexShardState.STARTED || state == IndexShardState.CLOSED) {
            return this.getEngine().acquireSafeIndexCommit();
        }
        throw new IllegalIndexShardStateException(this.shardId, state, "snapshot is not allowed", new Object[0]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    public Store.MetadataSnapshot snapshotStoreMetadata() throws IOException {
        Object object;
        Engine.IndexCommitRef indexCommit;
        block8: {
            Store.MetadataSnapshot metadataSnapshot;
            assert (!Thread.holdsLock(this.mutex)) : "snapshotting store metadata under mutex";
            indexCommit = null;
            this.store.incRef();
            try {
                object = this.engineMutex;
                // MONITORENTER : object
                Engine engine = this.getEngineOrNull();
                if (engine != null) {
                    indexCommit = engine.acquireLastIndexCommit(false);
                }
                if (indexCommit != null) break block8;
                metadataSnapshot = this.store.getMetadata(null, true);
                // MONITOREXIT : object
                this.store.decRef();
            }
            catch (Throwable throwable) {
                this.store.decRef();
                IOUtils.close(indexCommit);
                throw throwable;
            }
            IOUtils.close((Closeable)indexCommit);
            return metadataSnapshot;
        }
        // MONITOREXIT : object
        object = this.store.getMetadata(indexCommit.getIndexCommit());
        this.store.decRef();
        IOUtils.close((Closeable)indexCommit);
        return object;
    }

    public void failShard(String reason, @Nullable Exception e) {
        this.getEngine().failEngine(reason, e);
    }

    public Engine.SearcherSupplier acquireSearcherSupplier() {
        return this.acquireSearcherSupplier(Engine.SearcherScope.EXTERNAL);
    }

    public Engine.SearcherSupplier acquireSearcherSupplier(Engine.SearcherScope scope) {
        this.readAllowed();
        this.markSearcherAccessed();
        Engine engine = this.getEngine();
        return engine.acquireSearcherSupplier(this::wrapSearcher, scope);
    }

    public Engine.Searcher acquireSearcher(String source) {
        this.readAllowed();
        this.markSearcherAccessed();
        Engine engine = this.getEngine();
        return engine.acquireSearcher(source, Engine.SearcherScope.EXTERNAL, this::wrapSearcher);
    }

    private void markSearcherAccessed() {
        this.lastSearcherAccess.lazySet(this.threadPool.relativeTimeInMillis());
    }

    private Engine.Searcher wrapSearcher(Engine.Searcher searcher) {
        Engine.Searcher searcher2;
        block7: {
            assert (ElasticsearchDirectoryReader.unwrap(searcher.getDirectoryReader()) != null) : "DirectoryReader must be an instance or ElasticsearchDirectoryReader";
            boolean success = false;
            try {
                Engine.Searcher newSearcher = IndexShard.wrapSearcher(searcher, this.fieldUsageTracker.createSession(), this.readerWrapper);
                assert (newSearcher != null);
                success = true;
                searcher2 = newSearcher;
                if (success) break block7;
            }
            catch (IOException ex) {
                try {
                    throw new ElasticsearchException("failed to wrap searcher", (Throwable)ex, new Object[0]);
                }
                catch (Throwable throwable) {
                    if (!success) {
                        Releasables.closeWhileHandlingException(searcher);
                    }
                    throw throwable;
                }
            }
            Releasables.closeWhileHandlingException(searcher);
        }
        return searcher2;
    }

    static Engine.Searcher wrapSearcher(Engine.Searcher engineSearcher, ShardFieldUsageTracker.FieldUsageStatsTrackingSession fieldUsageStatsTrackingSession, @Nullable CheckedFunction<DirectoryReader, DirectoryReader, IOException> readerWrapper) throws IOException {
        NonClosingReaderWrapper nonClosingReaderWrapper;
        DirectoryReader reader;
        ElasticsearchDirectoryReader elasticsearchDirectoryReader = ElasticsearchDirectoryReader.getElasticsearchDirectoryReader(engineSearcher.getDirectoryReader());
        if (elasticsearchDirectoryReader == null) {
            throw new IllegalStateException("Can't wrap non elasticsearch directory reader");
        }
        if (readerWrapper == null) {
            readerWrapper = r -> r;
        }
        if ((reader = readerWrapper.apply(new FieldUsageTrackingDirectoryReader((DirectoryReader)(nonClosingReaderWrapper = new NonClosingReaderWrapper(engineSearcher.getDirectoryReader())), fieldUsageStatsTrackingSession))).getReaderCacheHelper() != elasticsearchDirectoryReader.getReaderCacheHelper()) {
            throw new IllegalStateException("wrapped directory reader doesn't delegate IndexReader#getCoreCacheKey, wrappers must override this method and delegate to the original readers core cache key. Wrapped readers can't be used as cache keys since their are used only per request which would lead to subtle bugs");
        }
        if (ElasticsearchDirectoryReader.getElasticsearchDirectoryReader(reader) != elasticsearchDirectoryReader) {
            throw new IllegalStateException("wrapped directory reader hides actual ElasticsearchDirectoryReader but shouldn't");
        }
        return new Engine.Searcher(engineSearcher.source(), reader, engineSearcher.getSimilarity(), engineSearcher.getQueryCache(), engineSearcher.getQueryCachingPolicy(), () -> IOUtils.close(reader, engineSearcher, fieldUsageStatsTrackingSession));
    }

    public void setGlobalCheckpointIfUnpromotable(long globalCheckpoint) {
        assert (!this.shardRouting.isPromotableToPrimary()) : "must only call this on unpromotable shards";
        this.globalCheckPointIfUnpromotable = globalCheckpoint;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close(String reason, boolean flushEngine, Executor closeExecutor, ActionListener<Void> closeListener) throws IOException {
        Object object = this.engineMutex;
        synchronized (object) {
            try {
                Object object2 = this.mutex;
                synchronized (object2) {
                    this.changeState(IndexShardState.CLOSED, reason);
                }
                this.checkAndCallWaitForEngineOrClosedShardListeners();
            }
            catch (Throwable throwable) {
                Engine engine = this.currentEngineReference.getAndSet(null);
                closeExecutor.execute(ActionRunnable.run(closeListener, new CheckedRunnable<Exception>(engine, flushEngine){
                    final /* synthetic */ Engine val$engine;
                    final /* synthetic */ boolean val$flushEngine;
                    {
                        this.val$engine = engine;
                        this.val$flushEngine = bl;
                    }

                    @Override
                    public void run() throws Exception {
                        try {
                            if (this.val$engine != null && this.val$flushEngine) {
                                this.val$engine.flushAndClose();
                            }
                        }
                        catch (Throwable throwable) {
                            IOUtils.close(this.val$engine, IndexShard.this.globalCheckpointListeners, IndexShard.this.refreshListeners, IndexShard.this.pendingReplicationActions, IndexShard.this.indexShardOperationPermits);
                            throw throwable;
                        }
                        IOUtils.close(this.val$engine, IndexShard.this.globalCheckpointListeners, IndexShard.this.refreshListeners, IndexShard.this.pendingReplicationActions, IndexShard.this.indexShardOperationPermits);
                    }

                    public String toString() {
                        return "IndexShard#close[" + String.valueOf(IndexShard.this.shardId) + "]";
                    }
                }));
                throw throwable;
            }
            Engine engine = this.currentEngineReference.getAndSet(null);
            closeExecutor.execute(ActionRunnable.run(closeListener, new /* invalid duplicate definition of identical inner class */));
        }
    }

    public void preRecovery(ActionListener<Void> listener) {
        IndexShardState currentState = this.state;
        if (currentState == IndexShardState.CLOSED) {
            throw new IndexShardNotRecoveringException(this.shardId, currentState);
        }
        assert (currentState == IndexShardState.RECOVERING) : "expected a recovering shard " + String.valueOf(this.shardId) + " but got " + String.valueOf((Object)currentState);
        this.indexEventListener.beforeIndexShardRecovery(this, this.indexSettings, listener);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void postRecovery(String reason, ActionListener<Void> listener) throws IndexShardStartedException, IndexShardRelocatedException, IndexShardClosedException {
        assert (this.postRecoveryComplete == null);
        SubscribableListener subscribableListener = new SubscribableListener();
        this.postRecoveryComplete = subscribableListener;
        ActionListener<Void> finalListener = ActionListener.runBefore(listener, () -> subscribableListener.onResponse(null));
        try {
            this.getEngine().refresh("post_recovery");
            Object object = this.mutex;
            synchronized (object) {
                if (this.state == IndexShardState.CLOSED) {
                    throw new IndexShardClosedException(this.shardId);
                }
                if (this.state == IndexShardState.STARTED) {
                    throw new IndexShardStartedException(this.shardId);
                }
                this.recoveryState.setStage(RecoveryState.Stage.DONE);
                this.changeState(IndexShardState.POST_RECOVERY, reason);
            }
            this.indexEventListener.afterIndexShardRecovery(this, finalListener);
        }
        catch (Exception e) {
            finalListener.onFailure(e);
        }
    }

    public void prepareForIndexRecovery() {
        if (this.state != IndexShardState.RECOVERING) {
            throw new IndexShardNotRecoveringException(this.shardId, this.state);
        }
        this.recoveryState.setStage(RecoveryState.Stage.INDEX);
        assert (this.currentEngineReference.get() == null);
    }

    public void recoverLocallyUpToGlobalCheckpoint(ActionListener<Long> recoveryStartingSeqNoListener) {
        assert (!Thread.holdsLock(this.mutex)) : "must not hold the mutex here";
        if (this.state != IndexShardState.RECOVERING) {
            recoveryStartingSeqNoListener.onFailure(new IndexShardNotRecoveringException(this.shardId, this.state));
            return;
        }
        try {
            this.recoveryState.validateCurrentStage(RecoveryState.Stage.INDEX);
        }
        catch (Exception e2) {
            recoveryStartingSeqNoListener.onFailure(e2);
            return;
        }
        assert (this.routingEntry().recoverySource().getType() == RecoverySource.Type.PEER) : "not a peer recovery [" + String.valueOf(this.routingEntry()) + "]";
        try {
            long globalCheckpoint = this.readGlobalCheckpointForRecovery(this.store.readLastCommittedSegmentsInfo().getUserData());
            Optional<SequenceNumbers.CommitInfo> safeCommit = this.store.findSafeIndexCommit(globalCheckpoint);
            ActionListener.run(recoveryStartingSeqNoListener.delegateResponse((l, e) -> {
                this.logger.debug(() -> Strings.format("failed to recover shard locally up to global checkpoint %s", globalCheckpoint), (Throwable)e);
                l.onResponse(-2L);
            }), l -> this.doLocalRecovery(globalCheckpoint, safeCommit, (ActionListener<Long>)l));
        }
        catch (org.apache.lucene.index.IndexNotFoundException e3) {
            this.logger.trace("skip local recovery as no index commit found");
            recoveryStartingSeqNoListener.onResponse(-2L);
        }
        catch (Exception e4) {
            this.logger.debug("skip local recovery as failed to find the safe commit", (Throwable)e4);
            recoveryStartingSeqNoListener.onResponse(-2L);
        }
    }

    private void doLocalRecovery(long globalCheckpoint, Optional<SequenceNumbers.CommitInfo> safeCommit, ActionListener<Long> recoveryStartingSeqNoListener) {
        this.maybeCheckIndex();
        this.recoveryState.setLocalTranslogStage();
        if (!safeCommit.isPresent()) {
            this.logger.trace("skip local recovery as no safe commit found");
            recoveryStartingSeqNoListener.onResponse(-2L);
            return;
        }
        assert (safeCommit.get().localCheckpoint() <= globalCheckpoint) : safeCommit.get().localCheckpoint() + " > " + globalCheckpoint;
        if (safeCommit.get().localCheckpoint() == globalCheckpoint) {
            this.logger.trace("skip local recovery as the safe commit is up to date; safe commit {} global checkpoint {}", (Object)safeCommit.get(), (Object)globalCheckpoint);
            this.recoveryState.getTranslog().totalLocal(0);
            recoveryStartingSeqNoListener.onResponse(globalCheckpoint + 1L);
            return;
        }
        if (this.indexSettings.getIndexMetadata().getState() == IndexMetadata.State.CLOSE || IndexMetadata.INDEX_BLOCKS_WRITE_SETTING.get(this.indexSettings.getSettings()).booleanValue()) {
            this.logger.trace("skip local recovery as the index was closed or not allowed to write; safe commit {} global checkpoint {}", (Object)safeCommit.get(), (Object)globalCheckpoint);
            this.recoveryState.getTranslog().totalLocal(0);
            recoveryStartingSeqNoListener.onResponse(safeCommit.get().localCheckpoint() + 1L);
            return;
        }
        SubscribableListener.newForked(l -> ActionListener.runWithResource(ActionListener.assertOnce(l), () -> () -> {
            assert (!Thread.holdsLock(this.mutex)) : "must not hold the mutex here";
            Object object = this.engineMutex;
            synchronized (object) {
                IOUtils.close((Closeable)this.currentEngineReference.getAndSet(null));
            }
        }, (recoveryCompleteListener, ignoredRef) -> {
            assert (!Thread.holdsLock(this.mutex)) : "must not hold the mutex here";
            Engine.TranslogRecoveryRunner translogRecoveryRunner = (engine, snapshot) -> {
                this.recoveryState.getTranslog().totalLocal(snapshot.totalOperations());
                int recoveredOps = this.runTranslogRecovery(engine, snapshot, Engine.Operation.Origin.LOCAL_TRANSLOG_RECOVERY, this.recoveryState.getTranslog()::incrementRecoveredOperations);
                this.recoveryState.getTranslog().totalLocal(recoveredOps);
                return recoveredOps;
            };
            this.innerOpenEngineAndTranslog(() -> globalCheckpoint);
            this.getEngine().recoverFromTranslog(translogRecoveryRunner, globalCheckpoint, recoveryCompleteListener.map(v -> {
                this.logger.trace("shard locally recovered up to {}", (Object)this.getEngine().getSeqNoStats(globalCheckpoint));
                return v;
            }));
        })).andThenApply(ignored -> {
            assert (!Thread.holdsLock(this.mutex)) : "must not hold the mutex here";
            try {
                Optional<SequenceNumbers.CommitInfo> newSafeCommit = this.store.findSafeIndexCommit(globalCheckpoint);
                assert (newSafeCommit.isPresent()) : "no safe commit found after local recovery";
                return newSafeCommit.get().localCheckpoint() + 1L;
            }
            catch (Exception e) {
                this.logger.debug(() -> Strings.format("failed to find the safe commit after recovering shard locally up to global checkpoint %s", globalCheckpoint), (Throwable)e);
                return -2L;
            }
        }).addListener(recoveryStartingSeqNoListener);
    }

    public void trimOperationOfPreviousPrimaryTerms(long aboveSeqNo) {
        this.getEngine().trimOperationsFromTranslog(this.getOperationPrimaryTerm(), aboveSeqNo);
    }

    public long getMaxSeenAutoIdTimestamp() {
        return this.getEngine().getMaxSeenAutoIdTimestamp();
    }

    public void updateMaxUnsafeAutoIdTimestamp(long maxSeenAutoIdTimestampFromPrimary) {
        this.getEngine().updateMaxUnsafeAutoIdTimestamp(maxSeenAutoIdTimestampFromPrimary);
    }

    public Engine.Result applyTranslogOperation(Translog.Operation operation, Engine.Operation.Origin origin) throws IOException {
        return this.applyTranslogOperation(this.getEngine(), operation, origin);
    }

    private Engine.Result applyTranslogOperation(Engine engine, Translog.Operation operation, Engine.Operation.Origin origin) throws IOException {
        VersionType versionType = origin == Engine.Operation.Origin.PRIMARY ? VersionType.EXTERNAL : null;
        return switch (operation.opType()) {
            case Translog.Operation.Type.INDEX -> {
                Translog.Index index = (Translog.Index)operation;
                yield this.applyIndexOperation(engine, index.seqNo(), index.primaryTerm(), index.version(), versionType, -2L, 0L, index.getAutoGeneratedIdTimestamp(), true, origin, new SourceToParse(index.id(), index.source(), XContentHelper.xContentType(index.source()), index.routing()));
            }
            case Translog.Operation.Type.DELETE -> {
                Translog.Delete delete = (Translog.Delete)operation;
                yield this.applyDeleteOperation(engine, delete.seqNo(), delete.primaryTerm(), delete.version(), delete.id(), versionType, -2L, 0L, origin);
            }
            case Translog.Operation.Type.NO_OP -> {
                Translog.NoOp noOp = (Translog.NoOp)operation;
                yield this.markSeqNoAsNoop(engine, noOp.seqNo(), noOp.primaryTerm(), noOp.reason(), origin);
            }
            default -> throw new IllegalStateException("No operation defined for [" + String.valueOf(operation) + "]");
        };
    }

    int runTranslogRecovery(Engine engine, Translog.Snapshot snapshot, Engine.Operation.Origin origin, Runnable onOperationRecovered) throws IOException {
        Translog.Operation operation;
        int opsRecovered = 0;
        while ((operation = snapshot.next()) != null) {
            try {
                this.logger.trace("[translog] recover op {}", (Object)operation);
                Engine.Result result = this.applyTranslogOperation(engine, operation, origin);
                switch (result.getResultType()) {
                    case FAILURE: {
                        throw result.getFailure();
                    }
                    case MAPPING_UPDATE_REQUIRED: {
                        throw new IllegalArgumentException("unexpected mapping update: " + String.valueOf(result.getRequiredMappingUpdate()));
                    }
                    case SUCCESS: {
                        break;
                    }
                    default: {
                        throw new AssertionError((Object)("Unknown result type [" + String.valueOf((Object)result.getResultType()) + "]"));
                    }
                }
                ++opsRecovered;
                onOperationRecovered.run();
            }
            catch (Exception e) {
                if (origin == Engine.Operation.Origin.LOCAL_TRANSLOG_RECOVERY && ExceptionsHelper.status(e) == RestStatus.BAD_REQUEST) {
                    this.logger.info("ignoring recovery of a corrupt translog entry", (Throwable)e);
                    continue;
                }
                throw ExceptionsHelper.convertToRuntime(e);
            }
        }
        return opsRecovered;
    }

    private void loadGlobalCheckpointToReplicationTracker() throws IOException {
        if (this.shardRouting.isPromotableToPrimary()) {
            long globalCheckpoint = this.readGlobalCheckpointForRecovery(this.store.readLastCommittedSegmentsInfo().getUserData());
            this.replicationTracker.updateGlobalCheckpointOnReplica(globalCheckpoint, "read from translog checkpoint");
        } else {
            this.replicationTracker.updateGlobalCheckpointOnReplica(this.globalCheckPointIfUnpromotable, "from CleanFilesRequest");
        }
    }

    public void openEngineAndRecoverFromTranslog(ActionListener<Void> listener) {
        try {
            this.recoveryState.validateCurrentStage(RecoveryState.Stage.INDEX);
            this.maybeCheckIndex();
            this.recoveryState.setLocalTranslogStage();
            RecoveryState.Translog translogRecoveryStats = this.recoveryState.getTranslog();
            Engine.TranslogRecoveryRunner translogRecoveryRunner = (engine, snapshot) -> {
                translogRecoveryStats.totalOperations(snapshot.totalOperations());
                translogRecoveryStats.totalOperationsOnStart(snapshot.totalOperations());
                return this.runTranslogRecovery(engine, snapshot, Engine.Operation.Origin.LOCAL_TRANSLOG_RECOVERY, translogRecoveryStats::incrementRecoveredOperations);
            };
            this.loadGlobalCheckpointToReplicationTracker();
            this.innerOpenEngineAndTranslog(this.replicationTracker);
            this.getEngine().recoverFromTranslog(translogRecoveryRunner, Long.MAX_VALUE, listener);
        }
        catch (Exception e) {
            listener.onFailure(e);
        }
    }

    public void openEngineAndSkipTranslogRecovery() throws IOException {
        assert (this.routingEntry().recoverySource().getType() == RecoverySource.Type.PEER) : "not a peer recovery [" + String.valueOf(this.routingEntry()) + "]";
        this.recoveryState.validateCurrentStage(RecoveryState.Stage.TRANSLOG);
        this.loadGlobalCheckpointToReplicationTracker();
        this.innerOpenEngineAndTranslog(this.replicationTracker);
        this.getEngine().skipTranslogRecovery();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void innerOpenEngineAndTranslog(LongSupplier globalCheckpointSupplier) throws IOException {
        assert (!Thread.holdsLock(this.mutex)) : "opening engine under mutex";
        if (this.state != IndexShardState.RECOVERING) {
            throw new IndexShardNotRecoveringException(this.shardId, this.state);
        }
        EngineConfig config = this.newEngineConfig(globalCheckpointSupplier);
        config.setEnableGcDeletes(false);
        this.updateRetentionLeasesOnReplica(this.loadRetentionLeases());
        assert (!this.recoveryState.getRecoverySource().expectEmptyRetentionLeases() || this.getRetentionLeases().leases().isEmpty()) : "expected empty set of retention leases with recovery source [" + String.valueOf(this.recoveryState.getRecoverySource()) + "] but got " + String.valueOf(this.getRetentionLeases());
        Object object = this.engineMutex;
        synchronized (object) {
            assert (this.currentEngineReference.get() == null) : "engine is running";
            this.verifyNotClosed();
            Engine newEngine = this.createEngine(config);
            this.onNewEngine(newEngine);
            this.currentEngineReference.set(newEngine);
            this.active.set(true);
        }
        this.onSettingsChanged();
        assert (this.assertLastestCommitUserData());
        this.recoveryState.validateCurrentStage(RecoveryState.Stage.TRANSLOG);
        this.checkAndCallWaitForEngineOrClosedShardListeners();
    }

    private Engine createEngine(EngineConfig config) {
        if (suppressCreateEngineErrors) {
            try {
                return this.engineFactory.newReadWriteEngine(config);
            }
            catch (Error e) {
                ExceptionsHelper.maybeDieOnAnotherThread(e);
                throw new RuntimeException("rethrowing suppressed error", e);
            }
        }
        return this.engineFactory.newReadWriteEngine(config);
    }

    private boolean assertLastestCommitUserData() throws IOException {
        SegmentInfos segmentCommitInfos = this.store.readLastCommittedSegmentsInfo();
        Map<String, String> userData = segmentCommitInfos.getUserData();
        assert (userData.containsKey("local_checkpoint")) : "commit point doesn't contains a local checkpoint";
        assert (userData.containsKey("max_seq_no")) : "commit point doesn't contains a maximum sequence number";
        assert (userData.containsKey("history_uuid")) : "commit point doesn't contains a history uuid";
        assert (userData.get("history_uuid").equals(this.getHistoryUUID())) : "commit point history uuid [" + userData.get("history_uuid") + "] is different than engine [" + this.getHistoryUUID() + "]";
        assert (userData.containsKey("max_unsafe_auto_id_timestamp")) : "opening index which was created post 5.5.0 but max_unsafe_auto_id_timestamp is not found in commit";
        Version commitLuceneVersion = segmentCommitInfos.getCommitLuceneVersion();
        assert (!commitLuceneVersion.onOrAfter(RecoverySettings.SEQ_NO_SNAPSHOT_RECOVERIES_SUPPORTED_VERSION.luceneVersion()) || userData.containsKey("es_version") && Engine.readIndexVersion(userData.get("es_version")).onOrBefore(IndexVersion.current())) : "commit point has an invalid ES_VERSION value. commit point lucene version [" + String.valueOf(commitLuceneVersion) + "], ES_VERSION [" + userData.get("es_version") + "]";
        return true;
    }

    private void onNewEngine(Engine newEngine) {
        assert (Thread.holdsLock(this.engineMutex));
        this.refreshListeners.setCurrentRefreshLocationSupplier(newEngine::getTranslogLastWriteLocation);
        this.refreshListeners.setCurrentProcessedCheckpointSupplier(newEngine::getProcessedLocalCheckpoint);
        this.refreshListeners.setMaxIssuedSeqNoSupplier(newEngine::getMaxSeqNo);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void performRecoveryRestart() throws IOException {
        assert (!Thread.holdsLock(this.mutex)) : "restart recovery under mutex";
        Object object = this.engineMutex;
        synchronized (object) {
            assert (this.refreshListeners.pendingCount() == 0) : "we can't restart with pending listeners";
            IOUtils.close((Closeable)this.currentEngineReference.getAndSet(null));
            this.resetRecoveryStage();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void resetRecoveryStage() {
        assert (this.routingEntry().recoverySource().getType() == RecoverySource.Type.PEER) : "not a peer recovery [" + String.valueOf(this.routingEntry()) + "]";
        assert (this.currentEngineReference.get() == null);
        if (this.state != IndexShardState.RECOVERING) {
            throw new IndexShardNotRecoveringException(this.shardId, this.state);
        }
        Object object = this.mutex;
        synchronized (object) {
            this.recoveryState = this.recoveryState().reset();
        }
    }

    public RecoveryStats recoveryStats() {
        return this.recoveryStats;
    }

    @Override
    public RecoveryState recoveryState() {
        return this.recoveryState;
    }

    @Override
    public ShardLongFieldRange getTimestampRange() {
        return this.determineShardLongFieldRange("@timestamp");
    }

    @Override
    public ShardLongFieldRange getEventIngestedRange() {
        return this.determineShardLongFieldRange("event.ingested");
    }

    private ShardLongFieldRange determineShardLongFieldRange(String fieldName) {
        ShardLongFieldRange rawTimestampFieldRange;
        if (this.mapperService() == null) {
            return ShardLongFieldRange.UNKNOWN;
        }
        MappedFieldType mappedFieldType = this.mapperService().fieldType(fieldName);
        if (!(mappedFieldType instanceof DateFieldMapper.DateFieldType) || !mappedFieldType.name().equals(fieldName)) {
            return ShardLongFieldRange.UNKNOWN;
        }
        if (!mappedFieldType.isIndexed()) {
            return ShardLongFieldRange.UNKNOWN;
        }
        try {
            rawTimestampFieldRange = this.getEngine().getRawFieldRange(fieldName);
            assert (rawTimestampFieldRange != null);
        }
        catch (IOException | AlreadyClosedException e) {
            this.logger.debug("exception obtaining range for field " + fieldName, (Throwable)e);
            return ShardLongFieldRange.UNKNOWN;
        }
        if (rawTimestampFieldRange == ShardLongFieldRange.UNKNOWN) {
            return ShardLongFieldRange.UNKNOWN;
        }
        if (rawTimestampFieldRange == ShardLongFieldRange.EMPTY) {
            return ShardLongFieldRange.EMPTY;
        }
        return ShardLongFieldRange.of(rawTimestampFieldRange.getMin(), rawTimestampFieldRange.getMax());
    }

    public void finalizeRecovery() {
        this.recoveryState().setStage(RecoveryState.Stage.FINALIZE);
        Engine engine = this.getEngine();
        engine.refresh("recovery_finalization");
        engine.config().setEnableGcDeletes(true);
    }

    public boolean ignoreRecoveryAttempt() {
        IndexShardState state = this.state();
        return state == IndexShardState.POST_RECOVERY || state == IndexShardState.RECOVERING || state == IndexShardState.STARTED || state == IndexShardState.CLOSED;
    }

    public void readAllowed() throws IllegalIndexShardStateException {
        IndexShardState state = this.state;
        if (!readAllowedStates.contains((Object)state)) {
            throw new IllegalIndexShardStateException(this.shardId, state, "operations only allowed when shard state is one of " + readAllowedStates.toString(), new Object[0]);
        }
    }

    public boolean isReadAllowed() {
        return readAllowedStates.contains((Object)this.state);
    }

    private void ensureWriteAllowed(Engine.Operation.Origin origin) throws IllegalIndexShardStateException {
        IndexShardState state = this.state;
        if (origin.isRecovery()) {
            if (state != IndexShardState.RECOVERING) {
                throw new IllegalIndexShardStateException(this.shardId, state, "operation only allowed when recovering, origin [" + String.valueOf((Object)origin) + "]", new Object[0]);
            }
        } else {
            assert (this.assertWriteOriginInvariants(origin));
            if (!writeAllowedStates.contains((Object)state)) {
                throw new IllegalIndexShardStateException(this.shardId, state, "operation only allowed when shard state is one of " + String.valueOf(writeAllowedStates) + ", origin [" + String.valueOf((Object)origin) + "]", new Object[0]);
            }
        }
    }

    private boolean assertWriteOriginInvariants(Engine.Operation.Origin origin) {
        switch (origin) {
            case PRIMARY: {
                this.assertPrimaryMode();
                this.assertExpectedStateForPrimaryIndexing(this.state);
                break;
            }
            case REPLICA: {
                assert (this.assertReplicationTarget());
                break;
            }
            case LOCAL_RESET: {
                int activeOperationsCount = this.getActiveOperationsCount();
                assert (activeOperationsCount == -1) : "locally resetting without blocking operations, active operations [" + activeOperationsCount + "]";
                break;
            }
            default: {
                assert (false) : "unexpected origin: " + String.valueOf((Object)origin);
                break;
            }
        }
        return true;
    }

    private void assertExpectedStateForPrimaryIndexing(IndexShardState state) {
        assert (state == IndexShardState.STARTED || state == IndexShardState.CLOSED) : "primary indexing unexpected in state [" + String.valueOf((Object)state) + "]";
    }

    private boolean assertPrimaryMode() {
        assert (this.shardRouting.primary() && this.replicationTracker.isPrimaryMode()) : "shard " + String.valueOf(this.shardRouting) + " is not a primary shard in primary mode";
        return true;
    }

    private boolean assertReplicationTarget() {
        assert (!this.replicationTracker.isPrimaryMode()) : "shard " + String.valueOf(this.shardRouting) + " in primary mode cannot be a replication target";
        return true;
    }

    private void verifyNotClosed() throws IllegalIndexShardStateException {
        this.verifyNotClosed(null);
    }

    private void verifyNotClosed(Exception suppressed) throws IllegalIndexShardStateException {
        IndexShardState state = this.state;
        if (state == IndexShardState.CLOSED) {
            IndexShardClosedException exc = new IndexShardClosedException(this.shardId, "operation only allowed when not closed");
            if (suppressed != null) {
                exc.addSuppressed(suppressed);
            }
            throw exc;
        }
    }

    public long getIndexBufferRAMBytesUsed() {
        Engine engine = this.getEngineOrNull();
        if (engine == null) {
            return 0L;
        }
        try {
            return engine.getIndexBufferRAMBytesUsed();
        }
        catch (AlreadyClosedException ex) {
            return 0L;
        }
    }

    public void addShardFailureCallback(Consumer<ShardFailure> onShardFailure) {
        this.shardEventListener.delegates.add(onShardFailure);
    }

    public void flushOnIdle(long inactiveTimeNS) {
        boolean wasActive;
        Engine engineOrNull = this.getEngineOrNull();
        if (engineOrNull != null && System.nanoTime() - engineOrNull.getLastWriteNanos() >= inactiveTimeNS && (wasActive = this.active.getAndSet(false))) {
            this.logger.debug("flushing shard on inactive");
            this.threadPool.executor("flush").execute(() -> this.flush(new FlushRequest(new String[0]).waitIfOngoing(false).force(false), new ActionListener<Boolean>(){

                @Override
                public void onResponse(Boolean flushed) {
                    if (!flushed.booleanValue()) {
                        IndexShard.this.active.set(true);
                    }
                    IndexShard.this.periodicFlushMetric.inc();
                }

                @Override
                public void onFailure(Exception e) {
                    if (IndexShard.this.state != IndexShardState.CLOSED) {
                        IndexShard.this.active.set(true);
                        IndexShard.this.logger.warn("failed to flush shard on inactive", (Throwable)e);
                    }
                }
            }));
        }
    }

    public boolean isActive() {
        return this.active.get();
    }

    public ShardPath shardPath() {
        return this.path;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void recoverFromLocalShards(BiConsumer<MappingMetadata, ActionListener<Void>> mappingUpdateConsumer, List<IndexShard> localShards, ActionListener<Boolean> listener) throws IOException {
        assert (this.shardRouting.primary()) : "recover from local shards only makes sense if the shard is a primary shard";
        assert (this.recoveryState.getRecoverySource().getType() == RecoverySource.Type.LOCAL_SHARDS) : "invalid recovery type: " + String.valueOf(this.recoveryState.getRecoverySource());
        ArrayList<LocalShardSnapshot> snapshots = new ArrayList<LocalShardSnapshot>();
        ActionListener<Boolean> recoveryListener = ActionListener.runBefore(listener, () -> IOUtils.close(snapshots));
        boolean success = false;
        try {
            for (IndexShard shard : localShards) {
                snapshots.add(new LocalShardSnapshot(shard));
            }
            assert (this.shardRouting.primary()) : "recover from local shards only makes sense if the shard is a primary shard";
            StoreRecovery storeRecovery = new StoreRecovery(this.shardId, this.logger);
            storeRecovery.recoverFromLocalShards(mappingUpdateConsumer, this, snapshots, recoveryListener);
            success = true;
        }
        finally {
            if (!success) {
                IOUtils.close(snapshots);
            }
        }
    }

    public void recoverFromStore(ActionListener<Boolean> listener) {
        assert (this.shardRouting.primary()) : "recover from store only makes sense if the shard is a primary shard";
        assert (this.shardRouting.initializing()) : "can only start recovery on initializing shard";
        StoreRecovery storeRecovery = new StoreRecovery(this.shardId, this.logger);
        storeRecovery.recoverFromStore(this, listener);
    }

    public void restoreFromRepository(Repository repository, ActionListener<Boolean> listener) {
        try {
            assert (this.shardRouting.primary()) : "recover from store only makes sense if the shard is a primary shard";
            assert (this.recoveryState.getRecoverySource().getType() == RecoverySource.Type.SNAPSHOT) : "invalid recovery type: " + String.valueOf(this.recoveryState.getRecoverySource());
            StoreRecovery storeRecovery = new StoreRecovery(this.shardId, this.logger);
            storeRecovery.recoverFromRepository(this, repository, listener);
        }
        catch (Exception e) {
            listener.onFailure(e);
        }
    }

    boolean shouldPeriodicallyFlush() {
        Engine engine = this.getEngineOrNull();
        if (engine != null) {
            try {
                return engine.shouldPeriodicallyFlush();
            }
            catch (AlreadyClosedException alreadyClosedException) {
                // empty catch block
            }
        }
        return false;
    }

    boolean shouldRollTranslogGeneration() {
        Engine engine = this.getEngineOrNull();
        if (engine != null) {
            try {
                return engine.shouldRollTranslogGeneration();
            }
            catch (AlreadyClosedException alreadyClosedException) {
                // empty catch block
            }
        }
        return false;
    }

    public void onSettingsChanged() {
        Engine engineOrNull = this.getEngineOrNull();
        if (engineOrNull != null) {
            engineOrNull.onSettingsChanged();
        }
    }

    public Closeable acquireHistoryRetentionLock() {
        return this.getEngine().acquireHistoryRetentionLock();
    }

    public boolean hasCompleteHistoryOperations(String reason, long startingSeqNo) {
        return this.getEngine().hasCompleteOperationHistory(reason, startingSeqNo);
    }

    public long getMinRetainedSeqNo() {
        return this.getEngine().getMinRetainedSeqNo();
    }

    public int countChanges(String source, long fromSeqNo, long toSeqNo) throws IOException {
        return this.getEngine().countChanges(source, fromSeqNo, toSeqNo);
    }

    public Translog.Snapshot newChangesSnapshot(String source, long fromSeqNo, long toSeqNo, boolean requiredFullRange, boolean singleConsumer, boolean accessStats, long maxChunkSize) throws IOException {
        return this.getEngine().newChangesSnapshot(source, fromSeqNo, toSeqNo, requiredFullRange, singleConsumer, accessStats, maxChunkSize);
    }

    public List<Segment> segments() {
        return this.getEngine().segments();
    }

    public List<Segment> segments(boolean includeVectorFormatsInfo) {
        return this.getEngine().segments(includeVectorFormatsInfo);
    }

    public String getHistoryUUID() {
        return this.getEngine().getHistoryUUID();
    }

    public IndexEventListener getIndexEventListener() {
        return this.indexEventListener;
    }

    public void activateThrottling() {
        try {
            this.getEngine().activateThrottling();
        }
        catch (AlreadyClosedException alreadyClosedException) {
            // empty catch block
        }
    }

    public void deactivateThrottling() {
        try {
            this.getEngine().deactivateThrottling();
        }
        catch (AlreadyClosedException alreadyClosedException) {
            // empty catch block
        }
    }

    private void handleRefreshException(Exception e) {
        if (!(e instanceof AlreadyClosedException)) {
            if (e instanceof RefreshFailedEngineException) {
                RefreshFailedEngineException rfee = (RefreshFailedEngineException)e;
                if (!(rfee.getCause() instanceof InterruptedException || rfee.getCause() instanceof ClosedByInterruptException || rfee.getCause() instanceof ThreadInterruptedException || this.state == IndexShardState.CLOSED)) {
                    this.logger.warn("Failed to perform engine refresh", (Throwable)e);
                }
            } else if (this.state != IndexShardState.CLOSED) {
                this.logger.warn("Failed to perform engine refresh", (Throwable)e);
            }
        }
    }

    public void writeIndexingBuffer() {
        try {
            Engine engine = this.getEngine();
            engine.writeIndexingBuffer();
        }
        catch (Exception e) {
            this.handleRefreshException(e);
        }
    }

    public void updateLocalCheckpointForShard(String allocationId, long checkpoint) {
        assert (this.assertPrimaryMode());
        this.verifyNotClosed();
        this.replicationTracker.updateLocalCheckpoint(allocationId, checkpoint);
    }

    public void updateGlobalCheckpointForShard(String allocationId, long globalCheckpoint) {
        assert (this.assertPrimaryMode());
        this.verifyNotClosed();
        this.replicationTracker.updateGlobalCheckpointForShard(allocationId, globalCheckpoint);
    }

    public void addGlobalCheckpointListener(long waitingForGlobalCheckpoint, GlobalCheckpointListeners.GlobalCheckpointListener listener, TimeValue timeout) {
        this.globalCheckpointListeners.add(waitingForGlobalCheckpoint, listener, timeout);
    }

    private void ensureSoftDeletesEnabled() {
        if (!this.indexSettings.isSoftDeleteEnabled()) {
            String message = "retention leases requires soft deletes but " + String.valueOf(this.indexSettings.getIndex()) + " does not have soft deletes enabled";
            assert (false) : message;
            throw new IllegalStateException(message);
        }
    }

    public RetentionLeases getRetentionLeases() {
        return this.getRetentionLeases(false);
    }

    public RetentionLeases getRetentionLeases(boolean expireLeases) {
        assert (!expireLeases || this.assertPrimaryMode());
        this.verifyNotClosed();
        return this.replicationTracker.getRetentionLeases(expireLeases);
    }

    public RetentionLeaseStats getRetentionLeaseStats() {
        this.verifyNotClosed();
        return new RetentionLeaseStats(this.getRetentionLeases());
    }

    public RetentionLease addRetentionLease(String id, long retainingSequenceNumber, String source, ActionListener<ReplicationResponse> listener) {
        RetentionLease retentionLease;
        block9: {
            Objects.requireNonNull(listener);
            assert (this.assertPrimaryMode());
            this.verifyNotClosed();
            this.ensureSoftDeletesEnabled();
            Closeable ignore = this.acquireHistoryRetentionLock();
            try {
                long actualRetainingSequenceNumber = retainingSequenceNumber == -1L ? this.getMinRetainedSeqNo() : retainingSequenceNumber;
                retentionLease = this.replicationTracker.addRetentionLease(id, actualRetainingSequenceNumber, source, listener);
                if (ignore == null) break block9;
            }
            catch (Throwable throwable) {
                try {
                    if (ignore != null) {
                        try {
                            ignore.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    throw new AssertionError((Object)e);
                }
            }
            ignore.close();
        }
        return retentionLease;
    }

    public RetentionLease renewRetentionLease(String id, long retainingSequenceNumber, String source) {
        RetentionLease retentionLease;
        block9: {
            assert (this.assertPrimaryMode());
            this.verifyNotClosed();
            this.ensureSoftDeletesEnabled();
            Closeable ignore = this.acquireHistoryRetentionLock();
            try {
                long actualRetainingSequenceNumber = retainingSequenceNumber == -1L ? this.getMinRetainedSeqNo() : retainingSequenceNumber;
                retentionLease = this.replicationTracker.renewRetentionLease(id, actualRetainingSequenceNumber, source);
                if (ignore == null) break block9;
            }
            catch (Throwable throwable) {
                try {
                    if (ignore != null) {
                        try {
                            ignore.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    throw new AssertionError((Object)e);
                }
            }
            ignore.close();
        }
        return retentionLease;
    }

    public void removeRetentionLease(String id, ActionListener<ReplicationResponse> listener) {
        Objects.requireNonNull(listener);
        assert (this.assertPrimaryMode());
        this.verifyNotClosed();
        this.ensureSoftDeletesEnabled();
        this.replicationTracker.removeRetentionLease(id, listener);
    }

    public void updateRetentionLeasesOnReplica(RetentionLeases retentionLeases) {
        assert (this.assertReplicationTarget());
        this.verifyNotClosed();
        this.replicationTracker.updateRetentionLeasesOnReplica(retentionLeases);
    }

    public RetentionLeases loadRetentionLeases() throws IOException {
        this.verifyNotClosed();
        return this.replicationTracker.loadRetentionLeases(this.path.getShardStatePath());
    }

    public void persistRetentionLeases() throws WriteStateException {
        this.verifyNotClosed();
        this.replicationTracker.persistRetentionLeases(this.path.getShardStatePath());
    }

    public boolean assertRetentionLeasesPersisted() throws IOException {
        return this.replicationTracker.assertRetentionLeasesPersisted(this.path.getShardStatePath());
    }

    public void syncRetentionLeases() {
        assert (this.assertPrimaryMode());
        this.verifyNotClosed();
        this.replicationTracker.renewPeerRecoveryRetentionLeases();
        RetentionLeases retentionLeases = this.getRetentionLeases(true);
        this.logger.trace("background syncing retention leases [{}] after expiration check", (Object)retentionLeases);
        this.retentionLeaseSyncer.backgroundSync(this.shardId, this.shardRouting.allocationId().getId(), this.getPendingPrimaryTerm(), retentionLeases);
    }

    public void initiateTracking(String allocationId) {
        assert (this.assertPrimaryMode());
        this.replicationTracker.initiateTracking(allocationId);
    }

    public void markAllocationIdAsInSync(String allocationId, long localCheckpoint) throws InterruptedException {
        assert (this.assertPrimaryMode());
        this.replicationTracker.markAllocationIdAsInSync(allocationId, localCheckpoint);
    }

    public long getLocalCheckpoint() {
        return this.getEngine().getPersistedLocalCheckpoint();
    }

    public long getLastKnownGlobalCheckpoint() {
        return this.replicationTracker.getGlobalCheckpoint();
    }

    public long getLastSyncedGlobalCheckpoint() {
        return this.getEngine().getLastSyncedGlobalCheckpoint();
    }

    public Map<String, Long> getInSyncGlobalCheckpoints() {
        assert (this.assertPrimaryMode());
        this.verifyNotClosed();
        return this.replicationTracker.getInSyncGlobalCheckpoints();
    }

    public void maybeSyncGlobalCheckpoint(String reason) {
        boolean asyncDurability;
        this.verifyNotClosed();
        assert (this.shardRouting.primary()) : "only call maybeSyncGlobalCheckpoint on primary shard";
        if (!this.replicationTracker.isPrimaryMode()) {
            return;
        }
        assert (this.assertPrimaryMode());
        SeqNoStats stats = this.getEngine().getSeqNoStats(this.replicationTracker.getGlobalCheckpoint());
        boolean bl = asyncDurability = this.indexSettings().getTranslogDurability() == Translog.Durability.ASYNC;
        if (stats.getMaxSeqNo() == stats.getGlobalCheckpoint() || asyncDurability) {
            boolean syncNeeded;
            boolean trackedGlobalCheckpointsNeedSync = this.replicationTracker.trackedGlobalCheckpointsNeedSync();
            boolean bl2 = syncNeeded = asyncDurability && (stats.getGlobalCheckpoint() < stats.getMaxSeqNo() || this.replicationTracker.pendingInSync()) || trackedGlobalCheckpointsNeedSync;
            if (syncNeeded && this.indexSettings.getIndexMetadata().getState() == IndexMetadata.State.OPEN) {
                this.syncGlobalCheckpoints(reason);
            }
        }
    }

    private void syncGlobalCheckpoints(String reason) {
        this.logger.trace("syncing global checkpoint for [{}]", (Object)reason);
        this.globalCheckpointSyncer.syncGlobalCheckpoints(this.shardId);
    }

    GlobalCheckpointSyncer getGlobalCheckpointSyncer() {
        return this.globalCheckpointSyncer;
    }

    public ReplicationGroup getReplicationGroup() {
        assert (this.assertPrimaryMode());
        this.verifyNotClosed();
        ReplicationGroup replicationGroup = this.replicationTracker.getReplicationGroup();
        this.pendingReplicationActions.accept(replicationGroup);
        return replicationGroup;
    }

    public PendingReplicationActions getPendingReplicationActions() {
        assert (this.assertPrimaryMode());
        this.verifyNotClosed();
        return this.pendingReplicationActions;
    }

    public void updateGlobalCheckpointOnReplica(long globalCheckpoint, String reason) {
        assert (this.assertReplicationTarget());
        long localCheckpoint = this.getLocalCheckpoint();
        if (globalCheckpoint > localCheckpoint) {
            assert (this.state() != IndexShardState.POST_RECOVERY && this.state() != IndexShardState.STARTED) : "supposedly in-sync shard copy received a global checkpoint [" + globalCheckpoint + "] that is higher than its local checkpoint [" + localCheckpoint + "]";
            return;
        }
        this.replicationTracker.updateGlobalCheckpointOnReplica(globalCheckpoint, reason);
    }

    public Runnable addCleanFilesDependency() {
        this.logger.trace("adding clean files dependency for [{}]", (Object)this.shardRouting);
        this.outstandingCleanFilesConditions.incrementAndGet();
        return () -> {
            if (this.outstandingCleanFilesConditions.decrementAndGet() == 0) {
                this.runAfterCleanFilesActions();
            }
        };
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void afterCleanFiles(Runnable runnable) {
        if (this.outstandingCleanFilesConditions.get() == 0) {
            runnable.run();
        } else {
            Deque<Runnable> deque = this.afterCleanFilesActions;
            synchronized (deque) {
                this.afterCleanFilesActions.add(runnable);
            }
            if (this.outstandingCleanFilesConditions.get() == 0) {
                this.runAfterCleanFilesActions();
            }
        }
    }

    public int outstandingCleanFilesConditions() {
        return this.outstandingCleanFilesConditions.get();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void runAfterCleanFilesActions() {
        Deque<Runnable> deque = this.afterCleanFilesActions;
        synchronized (deque) {
            Runnable afterCleanFilesAction;
            ExecutorService executor = this.threadPool.generic();
            while ((afterCleanFilesAction = this.afterCleanFilesActions.poll()) != null) {
                executor.execute(afterCleanFilesAction);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void activateWithPrimaryContext(ReplicationTracker.PrimaryContext primaryContext) {
        assert (this.shardRouting.primary() && this.shardRouting.isRelocationTarget()) : "only primary relocation target can update allocation IDs from primary context: " + String.valueOf(this.shardRouting);
        assert (primaryContext.getCheckpointStates().containsKey(this.routingEntry().allocationId().getId())) : "primary context [" + String.valueOf(primaryContext) + "] does not contain relocation target [" + String.valueOf(this.routingEntry()) + "]";
        assert (this.getLocalCheckpoint() == primaryContext.getCheckpointStates().get(this.routingEntry().allocationId().getId()).getLocalCheckpoint() || this.indexSettings().getTranslogDurability() == Translog.Durability.ASYNC) : "local checkpoint [" + this.getLocalCheckpoint() + "] does not match checkpoint from primary context [" + String.valueOf(primaryContext) + "]";
        Object object = this.mutex;
        synchronized (object) {
            this.replicationTracker.activateWithPrimaryContext(primaryContext);
        }
        this.ensurePeerRecoveryRetentionLeasesExist();
    }

    private void ensurePeerRecoveryRetentionLeasesExist() {
        this.threadPool.generic().execute(() -> this.replicationTracker.createMissingPeerRecoveryRetentionLeases(ActionListener.wrap(r -> this.logger.trace("created missing peer recovery retention leases"), e -> this.logger.debug("failed creating missing peer recovery retention leases", (Throwable)e))));
    }

    public boolean pendingInSync() {
        assert (this.assertPrimaryMode());
        return this.replicationTracker.pendingInSync();
    }

    public void noopUpdate() {
        this.internalIndexingStats.noopUpdate();
    }

    public void maybeCheckIndex() {
        this.recoveryState.setStage(RecoveryState.Stage.VERIFY_INDEX);
        if (Booleans.isTrue(this.checkIndexOnStartup) || "checksum".equals(this.checkIndexOnStartup)) {
            this.logger.warn("performing expensive diagnostic checks during shard startup [{}={}]; these checks should only be enabled temporarily, you must remove this index setting as soon as possible", (Object)IndexSettings.INDEX_CHECK_ON_STARTUP.getKey(), (Object)this.checkIndexOnStartup);
            try {
                this.checkIndex();
            }
            catch (IOException ex) {
                throw new RecoveryFailedException(this.recoveryState, "check index failed", (Throwable)ex);
            }
        }
    }

    void checkIndex() throws IOException {
        if (this.store.tryIncRef()) {
            try {
                this.doCheckIndex();
            }
            catch (IOException e) {
                this.store.markStoreCorrupted(e);
                throw e;
            }
            finally {
                this.store.decRef();
            }
        }
    }

    private void doCheckIndex() throws IOException {
        long timeNS = System.nanoTime();
        if (!Lucene.indexExists(this.store.directory())) {
            return;
        }
        if ("checksum".equals(this.checkIndexOnStartup)) {
            Store.MetadataSnapshot metadata;
            IOException corrupt = null;
            try {
                metadata = this.snapshotStoreMetadata();
            }
            catch (IOException e) {
                this.logger.warn("check index [failure]", (Throwable)e);
                throw e;
            }
            ArrayList<String> checkedFiles = new ArrayList<String>(metadata.size());
            for (Map.Entry<String, StoreFileMetadata> entry : metadata.fileMetadataMap().entrySet()) {
                try {
                    Store.checkIntegrity(entry.getValue(), this.store.directory());
                    if (corrupt == null) {
                        checkedFiles.add(entry.getKey());
                        continue;
                    }
                    this.logger.info("check index [ok]: checksum check passed on [{}]", (Object)entry.getKey());
                }
                catch (IOException ioException) {
                    for (String checkedFile : checkedFiles) {
                        this.logger.info("check index [ok]: checksum check passed on [{}]", (Object)checkedFile);
                    }
                    checkedFiles.clear();
                    this.logger.warn(() -> "check index [failure]: checksum failed on [" + (String)entry.getKey() + "]", (Throwable)ioException);
                    corrupt = ioException;
                }
            }
            if (corrupt != null) {
                throw corrupt;
            }
            if (this.logger.isDebugEnabled()) {
                for (String checkedFile : checkedFiles) {
                    this.logger.debug("check index [ok]: checksum check passed on [{}]", (Object)checkedFile);
                }
            }
        } else {
            BytesStreamOutput os = new BytesStreamOutput();
            PrintStream out = new PrintStream((OutputStream)os, false, StandardCharsets.UTF_8.name());
            CheckIndex.Status status = this.store.checkIndex(out);
            out.flush();
            if (!status.clean) {
                if (this.state == IndexShardState.CLOSED) {
                    return;
                }
                this.logger.warn("check index [failure]");
                this.logger.warn("{}", (Object)os.bytes().utf8ToString());
                throw new IOException("index check failure");
            }
            if (this.logger.isDebugEnabled()) {
                this.logger.debug("check index [success]\n{}", (Object)os.bytes().utf8ToString());
            }
        }
        this.recoveryState.getVerifyIndex().checkIndexTime(Math.max(0L, TimeValue.nsecToMSec(System.nanoTime() - timeNS)));
    }

    Engine getEngine() {
        Engine engine = this.getEngineOrNull();
        if (engine == null) {
            throw new AlreadyClosedException("engine is closed");
        }
        return engine;
    }

    public Engine getEngineOrNull() {
        return this.currentEngineReference.get();
    }

    public void startRecovery(RecoveryState recoveryState, PeerRecoveryTargetService recoveryTargetService, PeerRecoveryTargetService.RecoveryListener recoveryListener, RepositoriesService repositoriesService, BiConsumer<MappingMetadata, ActionListener<Void>> mappingUpdateConsumer, IndicesService indicesService, long clusterStateVersion) {
        assert (recoveryState.getRecoverySource().equals(this.shardRouting.recoverySource()));
        switch (recoveryState.getRecoverySource().getType()) {
            case EMPTY_STORE: 
            case EXISTING_STORE: {
                this.executeRecovery("from store", recoveryState, recoveryListener, this::recoverFromStore);
                break;
            }
            case PEER: {
                try {
                    this.markAsRecovering("from " + String.valueOf(recoveryState.getSourceNode()), recoveryState);
                    recoveryTargetService.startRecovery(this, recoveryState.getSourceNode(), clusterStateVersion, recoveryListener);
                }
                catch (Exception e) {
                    this.failShard("corrupted preexisting index", e);
                    recoveryListener.onRecoveryFailure(new RecoveryFailedException(recoveryState, null, (Throwable)e), true);
                }
                break;
            }
            case SNAPSHOT: {
                String repo = ((RecoverySource.SnapshotRecoverySource)recoveryState.getRecoverySource()).snapshot().getRepository();
                this.executeRecovery("from snapshot", recoveryState, recoveryListener, l -> this.restoreFromRepository(repositoriesService.repository(repo), (ActionListener<Boolean>)l));
                break;
            }
            case LOCAL_SHARDS: {
                int numShards;
                Set<Object> requiredShards;
                IndexMetadata indexMetadata = this.indexSettings().getIndexMetadata();
                Index resizeSourceIndex = indexMetadata.getResizeSourceIndex();
                ArrayList<IndexShard> startedShards = new ArrayList<IndexShard>();
                IndexService sourceIndexService = indicesService.indexService(resizeSourceIndex);
                if (sourceIndexService != null) {
                    requiredShards = IndexMetadata.selectRecoverFromShards(this.shardId().id(), sourceIndexService.getMetadata(), indexMetadata.getNumberOfShards());
                    for (IndexShard shard : sourceIndexService) {
                        if (shard.state() != IndexShardState.STARTED || !requiredShards.contains(shard.shardId())) continue;
                        startedShards.add(shard);
                    }
                    numShards = requiredShards.size();
                } else {
                    numShards = -1;
                    requiredShards = Collections.emptySet();
                }
                if (numShards == startedShards.size()) {
                    assert (!requiredShards.isEmpty());
                    this.executeRecovery("from local shards", recoveryState, recoveryListener, l -> this.recoverFromLocalShards(mappingUpdateConsumer, startedShards.stream().filter(s -> requiredShards.contains(s.shardId())).toList(), (ActionListener<Boolean>)l));
                    break;
                }
                RuntimeException e = numShards == -1 ? new IndexNotFoundException(resizeSourceIndex) : new IllegalStateException("not all required shards of index " + String.valueOf(resizeSourceIndex) + " are started yet, expected " + numShards + " found " + startedShards.size() + " can't recover shard " + String.valueOf(this.shardId()));
                throw e;
            }
            default: {
                throw new IllegalArgumentException("Unknown recovery source " + String.valueOf(recoveryState.getRecoverySource()));
            }
        }
    }

    private void executeRecovery(String reason, RecoveryState recoveryState, PeerRecoveryTargetService.RecoveryListener recoveryListener, CheckedConsumer<ActionListener<Boolean>, Exception> action) {
        this.markAsRecovering(reason, recoveryState);
        this.threadPool.generic().execute(ActionRunnable.wrap(ActionListener.wrap(r -> {
            if (r.booleanValue()) {
                recoveryListener.onRecoveryDone(recoveryState, this.getTimestampRange(), this.getEventIngestedRange());
            }
        }, e -> recoveryListener.onRecoveryFailure(new RecoveryFailedException(recoveryState, null, (Throwable)e), true)), action));
    }

    public boolean isRelocatedPrimary() {
        assert (this.shardRouting.primary()) : "only call isRelocatedPrimary on primary shard";
        return this.replicationTracker.isRelocated();
    }

    public RetentionLease addPeerRecoveryRetentionLease(String nodeId, long globalCheckpoint, ActionListener<ReplicationResponse> listener) {
        assert (this.assertPrimaryMode());
        assert (this.indexSettings.getIndexVersionCreated().before(IndexVersions.V_7_4_0) || !this.indexSettings.isSoftDeleteEnabled());
        return this.replicationTracker.addPeerRecoveryRetentionLease(nodeId, globalCheckpoint, listener);
    }

    public RetentionLease cloneLocalPeerRecoveryRetentionLease(String nodeId, ActionListener<ReplicationResponse> listener) {
        assert (this.assertPrimaryMode());
        return this.replicationTracker.cloneLocalPeerRecoveryRetentionLease(nodeId, listener);
    }

    public void removePeerRecoveryRetentionLease(String nodeId, ActionListener<ReplicationResponse> listener) {
        assert (this.assertPrimaryMode());
        this.replicationTracker.removePeerRecoveryRetentionLease(nodeId, listener);
    }

    public List<RetentionLease> getPeerRecoveryRetentionLeases() {
        return this.replicationTracker.getPeerRecoveryRetentionLeases();
    }

    public boolean useRetentionLeasesInPeerRecovery() {
        return this.useRetentionLeasesInPeerRecovery;
    }

    private SafeCommitInfo getSafeCommitInfo() {
        Engine engine = this.getEngineOrNull();
        return engine == null ? SafeCommitInfo.EMPTY : engine.getSafeCommitInfo();
    }

    private static void persistMetadata(ShardPath shardPath, IndexSettings indexSettings, ShardRouting newRouting, @Nullable ShardRouting currentRouting, Logger logger) throws IOException {
        assert (newRouting != null) : "newRouting must not be null";
        ShardId shardId = newRouting.shardId();
        if (currentRouting == null || currentRouting.primary() != newRouting.primary() || !currentRouting.allocationId().equals(newRouting.allocationId())) {
            assert (currentRouting == null || currentRouting.isSameAllocation(newRouting));
            if (logger.isTraceEnabled()) {
                String writeReason = currentRouting == null ? "initial state with allocation id [" + String.valueOf(newRouting.allocationId()) + "]" : "routing changed from " + String.valueOf(currentRouting) + " to " + String.valueOf(newRouting);
                logger.trace("{} writing shard state, reason [{}]", (Object)shardId, (Object)writeReason);
            }
            ShardStateMetadata newShardStateMetadata = new ShardStateMetadata(newRouting.primary(), indexSettings.getUUID(), newRouting.allocationId());
            ShardStateMetadata.FORMAT.writeAndCleanup(newShardStateMetadata, shardPath.getShardStatePath());
        } else {
            logger.trace("{} skip writing shard state, has been written before", (Object)shardId);
        }
    }

    public static Analyzer buildIndexAnalyzer(final MapperService mapperService) {
        if (mapperService == null) {
            return null;
        }
        return new DelegatingAnalyzerWrapper(Analyzer.PER_FIELD_REUSE_STRATEGY){

            @Override
            protected Analyzer getWrappedAnalyzer(String fieldName) {
                return mapperService.indexAnalyzer(fieldName, f -> {
                    throw new IllegalArgumentException("Field [" + f + "] has no associated analyzer");
                });
            }
        };
    }

    private EngineConfig newEngineConfig(LongSupplier globalCheckpointSupplier) {
        Sort indexSort = this.indexSortSupplier.get();
        Engine.Warmer warmer = reader -> {
            assert (!Thread.holdsLock(this.mutex)) : "warming engine under mutex";
            assert (reader != null);
            if (this.warmer != null) {
                this.warmer.warm(reader);
            }
        };
        boolean isTimeBasedIndex = this.mapperService == null ? false : this.mapperService.mappingLookup().hasTimestampField();
        return new EngineConfig(this.shardId, this.threadPool, this.threadPoolMergeExecutorService, this.indexSettings, warmer, this.store, this.indexSettings.getMergePolicy(isTimeBasedIndex), IndexShard.buildIndexAnalyzer(this.mapperService), this.similarityService.similarity(this.mapperService == null ? null : this.mapperService::fieldType), this.codecService, this.shardEventListener, this.indexCache != null ? this.indexCache.query() : null, this.cachingPolicy, this.translogConfig, IndexingMemoryController.SHARD_INACTIVE_TIME_SETTING.get(this.indexSettings.getSettings()), List.of(this.refreshListeners, this.refreshPendingLocationListener, this.refreshFieldHasValueListener), List.of(new RefreshMetricUpdater(this.refreshMetric), new RefreshShardFieldStatsListener()), indexSort, this.circuitBreakerService, globalCheckpointSupplier, this.replicationTracker::getRetentionLeases, this::getOperationPrimaryTerm, this.snapshotCommitSupplier, isTimeBasedIndex ? DataStream.TIMESERIES_LEAF_READERS_SORTER : null, this.relativeTimeInNanosSupplier, this.indexCommitListener, this.routingEntry().isPromotableToPrimary(), this.mapperService());
    }

    public void acquirePrimaryOperationPermit(ActionListener<Releasable> onPermitAcquired, Executor executorOnDelay) {
        this.acquirePrimaryOperationPermit(onPermitAcquired, executorOnDelay, false);
    }

    public void acquirePrimaryOperationPermit(ActionListener<Releasable> onPermitAcquired, Executor executorOnDelay, boolean forceExecution) {
        this.verifyNotClosed();
        assert (this.shardRouting.primary()) : "acquirePrimaryOperationPermit should only be called on primary shard: " + String.valueOf(this.shardRouting);
        this.indexShardOperationPermits.acquire(this.wrapPrimaryOperationPermitListener(onPermitAcquired), executorOnDelay, forceExecution);
    }

    public boolean isPrimaryMode() {
        assert (this.indexShardOperationPermits.getActiveOperationsCount() != 0) : "must hold permit to check primary mode";
        return this.replicationTracker.isPrimaryMode();
    }

    public void acquireAllPrimaryOperationsPermits(ActionListener<Releasable> onPermitAcquired, TimeValue timeout) {
        this.verifyNotClosed();
        assert (this.shardRouting.primary()) : "acquireAllPrimaryOperationsPermits should only be called on primary shard: " + String.valueOf(this.shardRouting);
        this.asyncBlockOperations(this.wrapPrimaryOperationPermitListener(onPermitAcquired), timeout.duration(), timeout.timeUnit());
    }

    private ActionListener<Releasable> wrapPrimaryOperationPermitListener(ActionListener<Releasable> listener) {
        return listener.delegateFailure((l, r) -> {
            if (this.isPrimaryMode()) {
                l.onResponse(r);
            } else {
                r.close();
                l.onFailure(new ShardNotInPrimaryModeException(this.shardId, this.state));
            }
        });
    }

    private void asyncBlockOperations(ActionListener<Releasable> onPermitAcquired, long timeout, TimeUnit timeUnit) {
        Releasable forceRefreshes = this.refreshListeners.forceRefreshes();
        ActionListener<Releasable> wrappedListener = ActionListener.wrap(r -> {
            forceRefreshes.close();
            onPermitAcquired.onResponse((Releasable)r);
        }, e -> {
            forceRefreshes.close();
            onPermitAcquired.onFailure((Exception)e);
        });
        try {
            this.indexShardOperationPermits.blockOperations(wrappedListener, timeout, timeUnit, this.threadPool.generic());
        }
        catch (Exception e2) {
            forceRefreshes.close();
            throw e2;
        }
    }

    public void runUnderPrimaryPermit(Runnable runnable, Consumer<Exception> onFailure, Executor executorOnDelay) {
        this.verifyNotClosed();
        assert (this.shardRouting.primary()) : "runUnderPrimaryPermit should only be called on primary shard but was " + String.valueOf(this.shardRouting);
        ActionListener<Releasable> onPermitAcquired = ActionListener.wrap(releasable -> {
            try (Releasable ignore = releasable;){
                runnable.run();
            }
        }, onFailure);
        this.acquirePrimaryOperationPermit(onPermitAcquired, executorOnDelay);
    }

    private <E extends Exception> void bumpPrimaryTerm(final long newPrimaryTerm, final CheckedRunnable<E> onBlocked, final @Nullable ActionListener<Releasable> combineWithAction) {
        assert (Thread.holdsLock(this.mutex));
        assert (newPrimaryTerm > this.pendingPrimaryTerm || newPrimaryTerm >= this.pendingPrimaryTerm && combineWithAction != null);
        assert (this.getOperationPrimaryTerm() <= this.pendingPrimaryTerm);
        final CountDownLatch termUpdated = new CountDownLatch(1);
        this.asyncBlockOperations(new ActionListener<Releasable>(){

            @Override
            public void onFailure(Exception e) {
                try {
                    this.innerFail(e);
                }
                finally {
                    if (combineWithAction != null) {
                        combineWithAction.onFailure(e);
                    }
                }
            }

            private void innerFail(Exception e) {
                try {
                    IndexShard.this.failShard("exception during primary term transition", e);
                }
                catch (AlreadyClosedException alreadyClosedException) {
                    // empty catch block
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void onResponse(Releasable releasable) {
                Releasable releaseOnce = Releasables.releaseOnce(releasable);
                try {
                    assert (IndexShard.this.getOperationPrimaryTerm() <= IndexShard.this.pendingPrimaryTerm);
                    termUpdated.await();
                    if (IndexShard.this.getOperationPrimaryTerm() < newPrimaryTerm) {
                        IndexShard.this.replicationTracker.setOperationPrimaryTerm(newPrimaryTerm);
                        onBlocked.run();
                    }
                }
                catch (Exception e) {
                    if (combineWithAction == null) {
                        releaseOnce.close();
                    }
                    this.innerFail(e);
                }
                finally {
                    if (combineWithAction != null) {
                        combineWithAction.onResponse(releasable);
                    } else {
                        releaseOnce.close();
                    }
                }
            }
        }, 30L, TimeUnit.MINUTES);
        this.pendingPrimaryTerm = newPrimaryTerm;
        termUpdated.countDown();
    }

    public void acquireReplicaOperationPermit(long opPrimaryTerm, long globalCheckpoint, long maxSeqNoOfUpdatesOrDeletes, ActionListener<Releasable> onPermitAcquired, Executor executorOnDelay) {
        this.innerAcquireReplicaOperationPermit(opPrimaryTerm, globalCheckpoint, maxSeqNoOfUpdatesOrDeletes, onPermitAcquired, false, listener -> this.indexShardOperationPermits.acquire((ActionListener<Releasable>)listener, executorOnDelay, true));
    }

    public void acquireAllReplicaOperationsPermits(long opPrimaryTerm, long globalCheckpoint, long maxSeqNoOfUpdatesOrDeletes, ActionListener<Releasable> onPermitAcquired, TimeValue timeout) {
        this.innerAcquireReplicaOperationPermit(opPrimaryTerm, globalCheckpoint, maxSeqNoOfUpdatesOrDeletes, onPermitAcquired, true, listener -> this.asyncBlockOperations((ActionListener<Releasable>)listener, timeout.duration(), timeout.timeUnit()));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void innerAcquireReplicaOperationPermit(long opPrimaryTerm, long globalCheckpoint, long maxSeqNoOfUpdatesOrDeletes, ActionListener<Releasable> onPermitAcquired, boolean allowCombineOperationWithPrimaryTermUpdate, Consumer<ActionListener<Releasable>> operationExecutor) {
        this.verifyNotClosed();
        ActionListener<Releasable> operationListener = onPermitAcquired.delegateFailure((delegatedListener, releasable) -> {
            if (opPrimaryTerm < this.getOperationPrimaryTerm()) {
                releasable.close();
                String message = String.format(Locale.ROOT, "%s operation primary term [%d] is too old (current [%d])", this.shardId, opPrimaryTerm, this.getOperationPrimaryTerm());
                delegatedListener.onFailure(new IllegalStateException(message));
            } else {
                assert (this.assertReplicationTarget());
                try {
                    this.updateGlobalCheckpointOnReplica(globalCheckpoint, "operation");
                    this.advanceMaxSeqNoOfUpdatesOrDeletes(maxSeqNoOfUpdatesOrDeletes);
                }
                catch (Exception e) {
                    releasable.close();
                    delegatedListener.onFailure(e);
                    return;
                }
                delegatedListener.onResponse(releasable);
            }
        });
        if (this.requirePrimaryTermUpdate(opPrimaryTerm, allowCombineOperationWithPrimaryTermUpdate)) {
            Object object = this.mutex;
            synchronized (object) {
                if (this.requirePrimaryTermUpdate(opPrimaryTerm, allowCombineOperationWithPrimaryTermUpdate)) {
                    IndexShardState shardState = this.state();
                    if (shardState != IndexShardState.POST_RECOVERY && shardState != IndexShardState.STARTED) {
                        throw new IndexShardNotStartedException(this.shardId, shardState);
                    }
                    this.bumpPrimaryTerm(opPrimaryTerm, () -> {
                        this.updateGlobalCheckpointOnReplica(globalCheckpoint, "primary term transition");
                        long currentGlobalCheckpoint = this.getLastKnownGlobalCheckpoint();
                        long maxSeqNo = this.seqNoStats().getMaxSeqNo();
                        this.logger.info("detected new primary with primary term [{}], global checkpoint [{}], max_seq_no [{}]", (Object)opPrimaryTerm, (Object)currentGlobalCheckpoint, (Object)maxSeqNo);
                        if (currentGlobalCheckpoint < maxSeqNo) {
                            this.resetEngineToGlobalCheckpoint();
                        } else {
                            this.getEngine().rollTranslogGeneration();
                        }
                    }, allowCombineOperationWithPrimaryTermUpdate ? operationListener : null);
                    if (allowCombineOperationWithPrimaryTermUpdate) {
                        this.logger.debug("operation execution has been combined with primary term update");
                        return;
                    }
                }
            }
        }
        assert (opPrimaryTerm <= this.pendingPrimaryTerm) : "operation primary term [" + opPrimaryTerm + "] should be at most [" + this.pendingPrimaryTerm + "]";
        operationExecutor.accept(operationListener);
    }

    private boolean requirePrimaryTermUpdate(long opPrimaryTerm, boolean allPermits) {
        return opPrimaryTerm > this.pendingPrimaryTerm || allPermits && opPrimaryTerm > this.getOperationPrimaryTerm();
    }

    public int getActiveOperationsCount() {
        return this.indexShardOperationPermits.getActiveOperationsCount();
    }

    public final void syncAfterWrite(Translog.Location location, Consumer<Exception> syncListener) {
        assert (this.indexShardOperationPermits.getActiveOperationsCount() != 0);
        this.verifyNotClosed();
        this.getEngine().asyncEnsureTranslogSynced(location, syncListener);
    }

    public void syncGlobalCheckpoint(long globalCheckpoint, Consumer<Exception> syncListener) {
        this.verifyNotClosed();
        this.getEngine().asyncEnsureGlobalCheckpointSynced(globalCheckpoint, syncListener);
    }

    public void sync() throws IOException {
        this.verifyNotClosed();
        this.getEngine().syncTranslog();
    }

    public boolean isSyncNeeded() {
        return this.getEngine().isTranslogSyncNeeded();
    }

    public Translog.Durability getTranslogDurability() {
        return this.indexSettings.getTranslogDurability();
    }

    public void afterWriteOperation() {
        if ((this.shouldPeriodicallyFlush() || this.shouldRollTranslogGeneration()) && this.flushOrRollRunning.compareAndSet(false, true)) {
            if (this.shouldPeriodicallyFlush()) {
                this.logger.debug("submitting async flush request");
                this.threadPool.executor("flush").execute(() -> {
                    this.flush(new FlushRequest(new String[0]), new ActionListener<Boolean>(){

                        @Override
                        public void onResponse(Boolean flushed) {
                            IndexShard.this.periodicFlushMetric.inc();
                        }

                        @Override
                        public void onFailure(Exception e) {
                            if (IndexShard.this.state != IndexShardState.CLOSED) {
                                IndexShard.this.logger.warn("failed to flush index", (Throwable)e);
                            }
                        }
                    });
                    this.flushOrRollRunning.compareAndSet(true, false);
                    this.afterWriteOperation();
                });
            } else if (this.shouldRollTranslogGeneration()) {
                this.logger.debug("submitting async roll translog generation request");
                AbstractRunnable roll = new AbstractRunnable(){

                    @Override
                    public void onFailure(Exception e) {
                        if (IndexShard.this.state != IndexShardState.CLOSED) {
                            IndexShard.this.logger.warn("failed to roll translog generation", (Throwable)e);
                        }
                    }

                    @Override
                    protected void doRun() {
                        IndexShard.this.rollTranslogGeneration();
                    }

                    @Override
                    public void onAfter() {
                        IndexShard.this.flushOrRollRunning.compareAndSet(true, false);
                        IndexShard.this.afterWriteOperation();
                    }
                };
                this.threadPool.executor("flush").execute(roll);
            } else {
                this.flushOrRollRunning.compareAndSet(true, false);
            }
        }
    }

    EngineFactory getEngineFactory() {
        return this.engineFactory;
    }

    ReplicationTracker getReplicationTracker() {
        return this.replicationTracker;
    }

    public void scheduledRefresh(ActionListener<Boolean> listener) {
        ActionListener.run(listener, l -> {
            this.verifyNotClosed();
            boolean listenerNeedsRefresh = this.refreshListeners.refreshNeeded();
            Engine engine = this.getEngine();
            if (this.isReadAllowed() && (listenerNeedsRefresh || engine.refreshNeeded())) {
                if (!listenerNeedsRefresh && engine.allowSearchIdleOptimization() && this.isSearchIdle() && !this.indexSettings.isExplicitRefresh() && this.active.get()) {
                    this.logger.trace("scheduledRefresh: search-idle, skipping refresh");
                    engine.maybePruneDeletes();
                    this.setRefreshPending(engine);
                    l.onResponse(false);
                } else {
                    this.logger.trace("scheduledRefresh: refresh with source [schedule]");
                    engine.maybeRefresh("schedule", l.map(Engine.RefreshResult::refreshed));
                }
                return;
            }
            this.logger.trace("scheduledRefresh: no refresh needed");
            engine.maybePruneDeletes();
            l.onResponse(false);
        });
    }

    public final boolean isSearchIdle() {
        return this.threadPool.relativeTimeInMillis() - this.lastSearcherAccess.get() >= this.indexSettings.getSearchIdleAfter().getMillis();
    }

    public long searchIdleTime() {
        return this.threadPool.relativeTimeInMillis() - this.lastSearcherAccess.get();
    }

    final long getLastSearcherAccess() {
        return this.lastSearcherAccess.get();
    }

    public final boolean hasRefreshPending() {
        return this.pendingRefreshLocation.get() != null;
    }

    private void setRefreshPending(Engine engine) {
        Translog.Location lastWriteLocation = engine.getTranslogLastWriteLocation();
        this.pendingRefreshLocation.updateAndGet(curr -> {
            if (curr == null || curr.compareTo(lastWriteLocation) <= 0) {
                return lastWriteLocation;
            }
            return curr;
        });
    }

    private FieldInfos loadFieldInfos() {
        Engine.Searcher hasValueSearcher = this.getEngine().acquireSearcher("field_has_value");
        try {
            FieldInfos fieldInfos = FieldInfos.getMergedFieldInfos(hasValueSearcher.getIndexReader());
            if (hasValueSearcher != null) {
                hasValueSearcher.close();
            }
            return fieldInfos;
        }
        catch (Throwable throwable) {
            try {
                if (hasValueSearcher != null) {
                    try {
                        hasValueSearcher.close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                }
                throw throwable;
            }
            catch (AlreadyClosedException alreadyClosedException) {
                return FieldInfos.EMPTY;
            }
        }
    }

    public ShardFieldStats getShardFieldStats() {
        return this.shardFieldStats;
    }

    public final void ensureShardSearchActive(Consumer<Boolean> listener) {
        this.markSearcherAccessed();
        Translog.Location location = this.pendingRefreshLocation.get();
        if (location != null) {
            this.addRefreshListener(location, result -> {
                this.pendingRefreshLocation.compareAndSet(location, null);
                listener.accept(true);
            });
            if (location == this.pendingRefreshLocation.get()) {
                this.threadPool.executor("refresh").execute(() -> {
                    if (location == this.pendingRefreshLocation.get()) {
                        this.getEngine().maybeRefresh("ensure-shard-search-active", new PlainActionFuture<Engine.RefreshResult>());
                    }
                });
            }
        } else {
            listener.accept(false);
        }
    }

    public void addRefreshListener(final Translog.Location location, final Consumer<Boolean> listener) {
        SubscribableListener<Void> subscribableListener = this.postRecoveryComplete;
        if (this.postRecoveryComplete != null) {
            subscribableListener.addListener(new ActionListener<Void>(){

                @Override
                public void onResponse(Void unused) {
                    if (IndexShard.this.isReadAllowed()) {
                        IndexShard.this.refreshListeners.addOrNotify(location, listener);
                    } else {
                        listener.accept(false);
                    }
                }

                @Override
                public void onFailure(Exception e) {
                    listener.accept(false);
                }
            }, EsExecutors.DIRECT_EXECUTOR_SERVICE, this.threadPool.getThreadContext());
        } else {
            listener.accept(false);
        }
    }

    public void addRefreshListener(final long checkpoint, final boolean allowUnIssuedSequenceNumber, final ActionListener<Void> listener) {
        SubscribableListener<Void> subscribableListener = this.postRecoveryComplete;
        if (subscribableListener != null) {
            subscribableListener.addListener(new ActionListener<Void>(){

                @Override
                public void onResponse(Void unused) {
                    if (IndexShard.this.isReadAllowed()) {
                        IndexShard.this.refreshListeners.addOrNotify(checkpoint, allowUnIssuedSequenceNumber, listener);
                    } else {
                        listener.onFailure(new IllegalIndexShardStateException(IndexShard.this.shardId, IndexShard.this.state, "Read not allowed on IndexShard", new Object[0]));
                    }
                }

                @Override
                public void onFailure(Exception e) {
                    listener.onFailure(e);
                }
            }, EsExecutors.DIRECT_EXECUTOR_SERVICE, this.threadPool.getThreadContext());
        } else {
            listener.onFailure(new IllegalIndexShardStateException(this.shardId, this.state, "Read not allowed on IndexShard", new Object[0]));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void resetEngine() {
        assert (!Thread.holdsLock(this.mutex)) : "resetting engine under mutex";
        assert (this.waitForEngineOrClosedShardListeners.isDone());
        try {
            Object object = this.engineMutex;
            synchronized (object) {
                Engine currentEngine = this.getEngine();
                currentEngine.prepareForEngineReset();
                EngineConfig engineConfig = this.newEngineConfig(this.replicationTracker);
                this.verifyNotClosed();
                IOUtils.close((Closeable)currentEngine);
                Engine newEngine = this.createEngine(engineConfig);
                this.currentEngineReference.set(newEngine);
                this.onNewEngine(newEngine);
            }
            this.onSettingsChanged();
        }
        catch (Exception e) {
            this.failShard("unable to reset engine", e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void resetEngineToGlobalCheckpoint() throws IOException {
        assert (!Thread.holdsLock(this.mutex)) : "resetting engine under mutex";
        assert (this.getActiveOperationsCount() == -1) : "resetting engine without blocking operations; active operations are [" + this.getActiveOperationsCount() + "]";
        this.sync();
        SeqNoStats seqNoStats = this.seqNoStats();
        TranslogStats translogStats = this.translogStats();
        this.flush(new FlushRequest(new String[0]).waitIfOngoing(true));
        final SetOnce<Engine> newEngineReference = new SetOnce<Engine>();
        long globalCheckpoint = this.getLastKnownGlobalCheckpoint();
        assert (globalCheckpoint == this.getLastSyncedGlobalCheckpoint());
        Object object = this.engineMutex;
        synchronized (object) {
            this.verifyNotClosed();
            ReadOnlyEngine readOnlyEngine = new ReadOnlyEngine(this.newEngineConfig(this.replicationTracker), seqNoStats, translogStats, false, Function.identity(), true, false){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public Engine.IndexCommitRef acquireLastIndexCommit(boolean flushFirst) {
                    Object object = IndexShard.this.engineMutex;
                    synchronized (object) {
                        if (newEngineReference.get() == null) {
                            throw new AlreadyClosedException("engine was closed");
                        }
                        return ((Engine)newEngineReference.get()).acquireLastIndexCommit(false);
                    }
                }

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public Engine.IndexCommitRef acquireSafeIndexCommit() {
                    Object object = IndexShard.this.engineMutex;
                    synchronized (object) {
                        if (newEngineReference.get() == null) {
                            throw new AlreadyClosedException("engine was closed");
                        }
                        return ((Engine)newEngineReference.get()).acquireSafeIndexCommit();
                    }
                }

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void close() throws IOException {
                    Engine newEngine;
                    Object object = IndexShard.this.engineMutex;
                    synchronized (object) {
                        newEngine = (Engine)newEngineReference.get();
                        if (newEngine == IndexShard.this.currentEngineReference.get()) {
                            newEngine = null;
                        }
                    }
                    IOUtils.close(() -> super.close(), newEngine);
                }
            };
            IOUtils.close((Closeable)this.currentEngineReference.getAndSet(readOnlyEngine));
            newEngineReference.set(this.engineFactory.newReadWriteEngine(this.newEngineConfig(this.replicationTracker)));
            this.onNewEngine((Engine)newEngineReference.get());
        }
        Engine.TranslogRecoveryRunner translogRunner = (engine, snapshot) -> this.runTranslogRecovery(engine, snapshot, Engine.Operation.Origin.LOCAL_RESET, () -> {});
        ((Engine)newEngineReference.get()).recoverFromTranslog(translogRunner, globalCheckpoint);
        ((Engine)newEngineReference.get()).refresh("reset_engine");
        Object object2 = this.engineMutex;
        synchronized (object2) {
            this.verifyNotClosed();
            IOUtils.close((Closeable)this.currentEngineReference.getAndSet((Engine)newEngineReference.get()));
            this.active.set(true);
        }
        this.onSettingsChanged();
    }

    public long getMaxSeqNoOfUpdatesOrDeletes() {
        return this.getEngine().getMaxSeqNoOfUpdatesOrDeletes();
    }

    public void advanceMaxSeqNoOfUpdatesOrDeletes(long seqNo) {
        this.getEngine().advanceMaxSeqNoOfUpdatesOrDeletes(seqNo);
    }

    public void verifyShardBeforeIndexClosing() throws IllegalStateException {
        this.getEngine().verifyEngineBeforeIndexClosing();
    }

    RetentionLeaseSyncer getRetentionLeaseSyncer() {
        return this.retentionLeaseSyncer;
    }

    public long getRelativeTimeInNanos() {
        return this.relativeTimeInNanosSupplier.getAsLong();
    }

    public String toString() {
        return "IndexShard(shardRouting=" + String.valueOf(this.shardRouting) + ")";
    }

    @Deprecated
    public void waitForSegmentGeneration(long segmentGeneration, ActionListener<Long> listener) {
        this.waitForPrimaryTermAndGeneration(this.getOperationPrimaryTerm(), segmentGeneration, listener);
    }

    private void checkAndCallWaitForEngineOrClosedShardListeners() {
        if (this.getEngineOrNull() != null || this.state == IndexShardState.CLOSED) {
            this.waitForEngineOrClosedShardListeners.onResponse(null);
        }
    }

    public void waitForEngineOrClosedShard(ActionListener<Void> listener) {
        this.waitForEngineOrClosedShardListeners.addListener(listener);
    }

    public void waitForPrimaryTermAndGeneration(long primaryTerm, long segmentGeneration, ActionListener<Long> listener) {
        this.waitForEngineOrClosedShard(listener.delegateFailureAndWrap((l, ignored) -> this.getEngine().addPrimaryTermAndGenerationListener(primaryTerm, segmentGeneration, (ActionListener<Long>)l)));
    }

    static {
        try {
            FIELD_INFOS = MethodHandles.lookup().findVarHandle(IndexShard.class, "fieldInfos", FieldInfos.class);
        }
        catch (Exception e) {
            throw new ExceptionInInitializerError(e);
        }
    }

    class ShardEventListener
    implements Engine.EventListener {
        private final CopyOnWriteArrayList<Consumer<ShardFailure>> delegates = new CopyOnWriteArrayList();

        ShardEventListener() {
        }

        @Override
        public void onFailedEngine(String reason, @Nullable Exception failure) {
            ShardFailure shardFailure = new ShardFailure(IndexShard.this.shardRouting, reason, failure);
            for (Consumer<ShardFailure> listener : this.delegates) {
                try {
                    listener.accept(shardFailure);
                }
                catch (Exception inner) {
                    inner.addSuppressed(failure);
                    IndexShard.this.logger.warn("exception while notifying engine failure", (Throwable)inner);
                }
            }
        }
    }

    private class RefreshPendingLocationListener
    implements ReferenceManager.RefreshListener {
        Translog.Location lastWriteLocation;

        private RefreshPendingLocationListener() {
        }

        @Override
        public void beforeRefresh() {
            try {
                this.lastWriteLocation = IndexShard.this.getEngine().getTranslogLastWriteLocation();
            }
            catch (AlreadyClosedException exc) {
                this.lastWriteLocation = null;
            }
        }

        @Override
        public void afterRefresh(boolean didRefresh) {
            if (didRefresh && this.lastWriteLocation != null) {
                IndexShard.this.pendingRefreshLocation.updateAndGet(pendingLocation -> {
                    if (pendingLocation == null || pendingLocation.compareTo(this.lastWriteLocation) <= 0) {
                        return null;
                    }
                    return pendingLocation;
                });
            }
        }
    }

    private class RefreshFieldHasValueListener
    implements ReferenceManager.RefreshListener {
        private RefreshFieldHasValueListener() {
        }

        @Override
        public void beforeRefresh() {
        }

        @Override
        public void afterRefresh(boolean didRefresh) {
            if (enableFieldHasValue && (didRefresh || IndexShard.this.fieldInfos == null)) {
                FIELD_INFOS.setRelease(IndexShard.this, IndexShard.this.loadFieldInfos());
            }
        }
    }

    private static final class NonClosingReaderWrapper
    extends FilterDirectoryReader {
        private static final LeafReader[] EMPTY_LEAF_READERS = new LeafReader[0];
        private static final FilterDirectoryReader.SubReaderWrapper SUB_READER_WRAPPER = new FilterDirectoryReader.SubReaderWrapper(){

            @Override
            public LeafReader wrap(LeafReader reader) {
                return reader;
            }

            @Override
            protected LeafReader[] wrap(List<? extends LeafReader> readers) {
                return readers.toArray(EMPTY_LEAF_READERS);
            }
        };

        private NonClosingReaderWrapper(DirectoryReader in) throws IOException {
            super(in, SUB_READER_WRAPPER);
        }

        @Override
        protected DirectoryReader doWrapDirectoryReader(DirectoryReader in) throws IOException {
            return new NonClosingReaderWrapper(in);
        }

        @Override
        protected void doClose() {
        }

        @Override
        public IndexReader.CacheHelper getReaderCacheHelper() {
            return this.in.getReaderCacheHelper();
        }
    }

    private static class RefreshMetricUpdater
    implements ReferenceManager.RefreshListener {
        private final MeanMetric refreshMetric;
        private long currentRefreshStartTime;
        private Thread callingThread = null;

        private RefreshMetricUpdater(MeanMetric refreshMetric) {
            this.refreshMetric = refreshMetric;
        }

        @Override
        public void beforeRefresh() {
            if (Assertions.ENABLED) {
                assert (this.callingThread == null) : "beforeRefresh was called by " + this.callingThread.getName() + " without a corresponding call to afterRefresh";
                this.callingThread = Thread.currentThread();
            }
            this.currentRefreshStartTime = System.nanoTime();
        }

        @Override
        public void afterRefresh(boolean didRefresh) {
            if (Assertions.ENABLED) {
                assert (this.callingThread != null) : "afterRefresh called but not beforeRefresh";
                assert (this.callingThread == Thread.currentThread()) : "beforeRefreshed called by a different thread. current [" + Thread.currentThread().getName() + "], thread that called beforeRefresh [" + this.callingThread.getName() + "]";
                this.callingThread = null;
            }
            this.refreshMetric.inc(System.nanoTime() - this.currentRefreshStartTime);
        }
    }

    private class RefreshShardFieldStatsListener
    implements ReferenceManager.RefreshListener {
        private RefreshShardFieldStatsListener() {
        }

        @Override
        public void beforeRefresh() {
        }

        @Override
        public void afterRefresh(boolean didRefresh) {
            if (IndexShard.this.shardFieldStats == null || didRefresh) {
                try (Engine.Searcher searcher = IndexShard.this.getEngine().acquireSearcher("shard_field_stats", Engine.SearcherScope.INTERNAL);){
                    int numSegments = 0;
                    int totalFields = 0;
                    long usages = 0L;
                    for (LeafReaderContext leaf : searcher.getLeafContexts()) {
                        ++numSegments;
                        FieldInfos fieldInfos = leaf.reader().getFieldInfos();
                        totalFields += fieldInfos.size();
                        if (fieldInfos instanceof FieldInfosWithUsages) {
                            FieldInfosWithUsages ft = (FieldInfosWithUsages)fieldInfos;
                            if (usages == -1L) continue;
                            usages += (long)ft.getTotalUsages();
                            continue;
                        }
                        usages = -1L;
                    }
                    IndexShard.this.shardFieldStats = new ShardFieldStats(numSegments, totalFields, usages);
                }
                catch (AlreadyClosedException alreadyClosedException) {
                    // empty catch block
                }
            }
        }
    }

    public record ShardFailure(ShardRouting routing, String reason, @Nullable Exception cause) {
    }
}

