/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.mapper.vectors;

import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.analysis.TokenStream;
import org.apache.lucene.analysis.tokenattributes.CharTermAttribute;
import org.apache.lucene.analysis.tokenattributes.TermFrequencyAttribute;
import org.apache.lucene.document.Field;
import org.apache.lucene.document.FieldType;
import org.apache.lucene.index.IndexOptions;
import org.apache.lucene.index.IndexableFieldType;

public final class XFeatureField
extends Field {
    private static final FieldType FIELD_TYPE = new FieldType();
    private static final FieldType FIELD_TYPE_STORE_TERM_VECTORS = new FieldType();
    private float featureValue;
    static final int MAX_FREQ;

    public XFeatureField(String fieldName, String featureName, float featureValue) {
        this(fieldName, featureName, featureValue, false);
    }

    public XFeatureField(String fieldName, String featureName, float featureValue, boolean storeTermVectors) {
        super(fieldName, featureName, (IndexableFieldType)(storeTermVectors ? FIELD_TYPE_STORE_TERM_VECTORS : FIELD_TYPE));
        this.setFeatureValue(featureValue);
    }

    public void setFeatureValue(float featureValue) {
        if (!Float.isFinite(featureValue)) {
            throw new IllegalArgumentException("featureValue must be finite, got: " + featureValue + " for feature " + String.valueOf(this.fieldsData) + " on field " + this.name);
        }
        if (featureValue < Float.MIN_NORMAL) {
            throw new IllegalArgumentException("featureValue must be a positive normal float, got: " + featureValue + " for feature " + String.valueOf(this.fieldsData) + " on field " + this.name + " which is less than the minimum positive normal float: 1.1754944E-38");
        }
        this.featureValue = featureValue;
    }

    @Override
    public TokenStream tokenStream(Analyzer analyzer, TokenStream reuse) {
        FeatureTokenStream stream = reuse instanceof FeatureTokenStream ? (FeatureTokenStream)reuse : new FeatureTokenStream();
        int freqBits = Float.floatToIntBits(this.featureValue);
        stream.setValues((String)this.fieldsData, freqBits >>> 15);
        return stream;
    }

    public float getFeatureValue() {
        return this.featureValue;
    }

    static float decodeFeatureValue(float freq) {
        if (freq > (float)MAX_FREQ) {
            return Float.MAX_VALUE;
        }
        int tf = (int)freq;
        int featureBits = tf << 15;
        return Float.intBitsToFloat(featureBits);
    }

    static {
        FIELD_TYPE.setTokenized(false);
        FIELD_TYPE.setOmitNorms(true);
        FIELD_TYPE.setIndexOptions(IndexOptions.DOCS_AND_FREQS);
        FIELD_TYPE_STORE_TERM_VECTORS.setTokenized(false);
        FIELD_TYPE_STORE_TERM_VECTORS.setOmitNorms(true);
        FIELD_TYPE_STORE_TERM_VECTORS.setIndexOptions(IndexOptions.DOCS_AND_FREQS);
        FIELD_TYPE_STORE_TERM_VECTORS.setStoreTermVectors(true);
        MAX_FREQ = Float.floatToIntBits(Float.MAX_VALUE) >>> 15;
    }

    private static final class FeatureTokenStream
    extends TokenStream {
        private final CharTermAttribute termAttribute = this.addAttribute(CharTermAttribute.class);
        private final TermFrequencyAttribute freqAttribute = this.addAttribute(TermFrequencyAttribute.class);
        private boolean used = true;
        private String value = null;
        private int freq = 0;

        private FeatureTokenStream() {
        }

        void setValues(String value, int freq) {
            this.value = value;
            this.freq = freq;
        }

        @Override
        public boolean incrementToken() {
            if (this.used) {
                return false;
            }
            this.clearAttributes();
            this.termAttribute.append(this.value);
            this.freqAttribute.setTermFrequency(this.freq);
            this.used = true;
            return true;
        }

        @Override
        public void reset() {
            this.used = false;
        }

        @Override
        public void close() {
            this.value = null;
        }
    }
}

