/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.fielddata.plain;

import java.io.IOException;
import org.apache.lucene.index.BinaryDocValues;
import org.apache.lucene.util.BytesRef;
import org.elasticsearch.common.io.stream.ByteArrayStreamInput;
import org.elasticsearch.index.fielddata.LeafFieldData;
import org.elasticsearch.index.fielddata.SortedBinaryDocValues;

abstract class AbstractBinaryDVLeafFieldData
implements LeafFieldData {
    private final BinaryDocValues values;

    AbstractBinaryDVLeafFieldData(BinaryDocValues values) {
        this.values = values;
    }

    @Override
    public long ramBytesUsed() {
        return 0L;
    }

    @Override
    public SortedBinaryDocValues getBytesValues() {
        return new SortedBinaryDocValues(){
            int count;
            final ByteArrayStreamInput in = new ByteArrayStreamInput();
            final BytesRef scratch = new BytesRef();

            @Override
            public boolean advanceExact(int doc) throws IOException {
                if (AbstractBinaryDVLeafFieldData.this.values.advanceExact(doc)) {
                    BytesRef bytes = AbstractBinaryDVLeafFieldData.this.values.binaryValue();
                    assert (bytes.length > 0);
                    this.in.reset(bytes.bytes, bytes.offset, bytes.length);
                    this.count = this.in.readVInt();
                    this.scratch.bytes = bytes.bytes;
                    return true;
                }
                return false;
            }

            @Override
            public int docValueCount() {
                return this.count;
            }

            @Override
            public BytesRef nextValue() throws IOException {
                this.scratch.length = this.in.readVInt();
                this.scratch.offset = this.in.getPosition();
                this.in.setPosition(this.scratch.offset + this.scratch.length);
                return this.scratch;
            }
        };
    }
}

