/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.codec;

import java.util.ServiceLoader;
import org.apache.lucene.codecs.DocValuesFormat;
import org.apache.lucene.codecs.KnnVectorsFormat;
import org.apache.lucene.codecs.PostingsFormat;
import org.apache.lucene.codecs.lucene90.Lucene90DocValuesFormat;
import org.apache.lucene.codecs.lucene99.Lucene99HnswVectorsFormat;
import org.elasticsearch.common.util.BigArrays;
import org.elasticsearch.index.IndexMode;
import org.elasticsearch.index.IndexSettings;
import org.elasticsearch.index.codec.bloomfilter.ES87BloomFilterPostingsFormat;
import org.elasticsearch.index.codec.postings.ES812PostingsFormat;
import org.elasticsearch.index.codec.tsdb.ES87TSDBDocValuesFormat;
import org.elasticsearch.index.mapper.CompletionFieldMapper;
import org.elasticsearch.index.mapper.Mapper;
import org.elasticsearch.index.mapper.MapperService;
import org.elasticsearch.index.mapper.vectors.DenseVectorFieldMapper;
import org.elasticsearch.internal.CompletionsPostingsFormatExtension;
import org.elasticsearch.plugins.ExtensionLoader;

public class PerFieldFormatSupplier {
    private static final DocValuesFormat docValuesFormat = new Lucene90DocValuesFormat();
    private static final KnnVectorsFormat knnVectorsFormat = new Lucene99HnswVectorsFormat();
    private static final ES87TSDBDocValuesFormat tsdbDocValuesFormat = new ES87TSDBDocValuesFormat();
    private static final ES812PostingsFormat es812PostingsFormat = new ES812PostingsFormat();
    private final ES87BloomFilterPostingsFormat bloomFilterPostingsFormat;
    private final MapperService mapperService;

    public PerFieldFormatSupplier(MapperService mapperService, BigArrays bigArrays) {
        this.mapperService = mapperService;
        this.bloomFilterPostingsFormat = new ES87BloomFilterPostingsFormat(bigArrays, this::internalGetPostingsFormatForField);
    }

    public PostingsFormat getPostingsFormatForField(String field) {
        if (this.useBloomFilter(field)) {
            return this.bloomFilterPostingsFormat;
        }
        return this.internalGetPostingsFormatForField(field);
    }

    private PostingsFormat internalGetPostingsFormatForField(String field) {
        Mapper mapper;
        if (this.mapperService != null && (mapper = this.mapperService.mappingLookup().getMapper(field)) instanceof CompletionFieldMapper) {
            return CompletionPostingsFormatHolder.POSTINGS_FORMAT;
        }
        return es812PostingsFormat;
    }

    boolean useBloomFilter(String field) {
        if (this.mapperService == null) {
            return false;
        }
        IndexSettings indexSettings = this.mapperService.getIndexSettings();
        if (this.mapperService.mappingLookup().isDataStreamTimestampFieldEnabled()) {
            return indexSettings.getMode() == IndexMode.TIME_SERIES && "_id".equals(field) && IndexSettings.BLOOM_FILTER_ID_FIELD_ENABLED_SETTING.get(indexSettings.getSettings()) != false;
        }
        return "_id".equals(field) && IndexSettings.BLOOM_FILTER_ID_FIELD_ENABLED_SETTING.get(indexSettings.getSettings()) != false;
    }

    public KnnVectorsFormat getKnnVectorsFormatForField(String field) {
        Mapper mapper;
        if (this.mapperService != null && (mapper = this.mapperService.mappingLookup().getMapper(field)) instanceof DenseVectorFieldMapper) {
            DenseVectorFieldMapper vectorMapper = (DenseVectorFieldMapper)mapper;
            return vectorMapper.getKnnVectorsFormatForField(knnVectorsFormat);
        }
        return knnVectorsFormat;
    }

    public DocValuesFormat getDocValuesFormatForField(String field) {
        if (this.useTSDBDocValuesFormat(field)) {
            return tsdbDocValuesFormat;
        }
        return docValuesFormat;
    }

    boolean useTSDBDocValuesFormat(String field) {
        if (this.excludeFields(field)) {
            return false;
        }
        return this.mapperService != null && (this.isTimeSeriesModeIndex() || this.isLogsModeIndex()) && this.mapperService.getIndexSettings().isES87TSDBCodecEnabled();
    }

    private boolean excludeFields(String fieldName) {
        return fieldName.startsWith("_") && !fieldName.equals("_tsid") && !fieldName.equals("_ts_routing_hash");
    }

    private boolean isTimeSeriesModeIndex() {
        return this.mapperService != null && IndexMode.TIME_SERIES == this.mapperService.getIndexSettings().getMode();
    }

    private boolean isLogsModeIndex() {
        return this.mapperService != null && IndexMode.LOGSDB == this.mapperService.getIndexSettings().getMode();
    }

    private static class CompletionPostingsFormatHolder {
        private static final PostingsFormat POSTINGS_FORMAT = CompletionPostingsFormatHolder.getCompletionPostingsFormat();

        private CompletionPostingsFormatHolder() {
        }

        private static PostingsFormat getCompletionPostingsFormat() {
            String defaultName = "Completion101";
            String codecName = ExtensionLoader.loadSingleton(ServiceLoader.load(CompletionsPostingsFormatExtension.class)).map(CompletionsPostingsFormatExtension::getFormatName).orElse(defaultName);
            return PostingsFormat.forName(codecName);
        }
    }
}

