/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.common.util;

import com.carrotsearch.hppc.BitMixer;
import org.elasticsearch.common.util.AbstractHash;
import org.elasticsearch.common.util.BigArrays;
import org.elasticsearch.common.util.IntArray;
import org.elasticsearch.core.Releasables;

public final class Int3Hash
extends AbstractHash {
    private IntArray keys;

    public Int3Hash(long capacity, BigArrays bigArrays) {
        this(capacity, 0.6f, bigArrays);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Int3Hash(long capacity, float maxLoadFactor, BigArrays bigArrays) {
        super(capacity, maxLoadFactor, bigArrays);
        try {
            this.keys = bigArrays.newIntArray(3L * capacity, false);
        }
        finally {
            if (this.keys == null) {
                this.close();
            }
        }
    }

    public int getKey1(long id) {
        return this.keys.get(3L * id);
    }

    public int getKey2(long id) {
        return this.keys.get(3L * id + 1L);
    }

    public int getKey3(long id) {
        return this.keys.get(3L * id + 2L);
    }

    public long find(int key1, int key2, int key3) {
        long slot;
        long index = slot = Int3Hash.slot(Int3Hash.hash(key1, key2, key3), this.mask);
        long id;
        while ((id = this.id(index)) != -1L) {
            long keyOffset = 3L * id;
            if (this.keys.get(keyOffset) == key1 && this.keys.get(keyOffset + 1L) == key2 && this.keys.get(keyOffset + 2L) == key3) {
                return id;
            }
            index = Int3Hash.nextSlot(index, this.mask);
        }
        return id;
    }

    private long set(int key1, int key2, int key3, long id) {
        long slot;
        assert (this.size < this.maxSize);
        long index = slot = Int3Hash.slot(Int3Hash.hash(key1, key2, key3), this.mask);
        while (true) {
            long curId;
            if ((curId = this.id(index)) == -1L) {
                this.setId(index, id);
                this.append(id, key1, key2, key3);
                ++this.size;
                return id;
            }
            long keyOffset = 3L * curId;
            if (this.keys.get(keyOffset) == key1 && this.keys.get(keyOffset + 1L) == key2 && this.keys.get(keyOffset + 2L) == key3) {
                return -1L - curId;
            }
            index = Int3Hash.nextSlot(index, this.mask);
        }
    }

    private void append(long id, int key1, int key2, int key3) {
        long keyOffset = 3L * id;
        this.keys = this.bigArrays.grow(this.keys, keyOffset + 3L);
        this.keys.set(keyOffset, key1);
        this.keys.set(keyOffset + 1L, key2);
        this.keys.set(keyOffset + 2L, key3);
    }

    private void reset(long id) {
        long slot;
        IntArray keys = this.keys;
        long keyOffset = id * 3L;
        int key1 = keys.get(keyOffset);
        int key2 = keys.get(keyOffset + 1L);
        int key3 = keys.get(keyOffset + 2L);
        long index = slot = Int3Hash.slot(Int3Hash.hash(key1, key2, key3), this.mask);
        while (true) {
            long curId;
            if ((curId = this.id(index)) == -1L) break;
            index = Int3Hash.nextSlot(index, this.mask);
        }
        this.setId(index, id);
    }

    public long add(int key1, int key2, int key3) {
        if (this.size >= this.maxSize) {
            assert (this.size == this.maxSize);
            this.grow();
        }
        assert (this.size < this.maxSize);
        return this.set(key1, key2, key3, this.size);
    }

    @Override
    protected void removeAndAdd(long index) {
        long id = this.getAndSetId(index, -1L);
        assert (id >= 0L);
        this.reset(id);
    }

    @Override
    public void close() {
        Releasables.close(this.keys, () -> super.close());
    }

    static long hash(long key1, long key2, long key3) {
        return 31L * (31L * (long)BitMixer.mix((long)key1) + (long)BitMixer.mix((long)key2)) + (long)BitMixer.mix((long)key3);
    }
}

