/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.common.util;

import java.io.IOException;
import java.util.HashSet;
import java.util.Set;
import org.apache.lucene.util.SetOnce;
import org.apache.lucene.util.ThreadInterruptedException;
import org.elasticsearch.ElasticsearchException;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.core.Nullable;

public class CancellableThreads {
    private final Set<Thread> threads = new HashSet<Thread>();
    private volatile boolean cancelled = false;
    private final SetOnce<OnCancel> onCancel = new SetOnce();
    private String reason;

    public synchronized boolean isCancelled() {
        return this.cancelled;
    }

    public void checkForCancel() {
        this.checkForCancel(null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void checkForCancel(Exception beforeCancelException) {
        if (this.isCancelled()) {
            OnCancel onCancel;
            String reason;
            CancellableThreads cancellableThreads = this;
            synchronized (cancellableThreads) {
                reason = this.reason;
                onCancel = this.onCancel.get();
            }
            if (onCancel != null) {
                onCancel.onCancel(reason, beforeCancelException);
            }
            ExecutionCancelledException cancelExp = new ExecutionCancelledException("operation was cancelled reason [" + reason + "]");
            if (beforeCancelException != null) {
                cancelExp.addSuppressed(beforeCancelException);
            }
            throw cancelExp;
        }
    }

    private synchronized boolean add() {
        this.checkForCancel();
        this.threads.add(Thread.currentThread());
        return Thread.interrupted();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void execute(Interruptible interruptible) {
        boolean wasInterrupted = this.add();
        boolean cancelledByExternalInterrupt = false;
        RuntimeException runtimeException = null;
        try {
            interruptible.run();
        }
        catch (InterruptedException | ThreadInterruptedException e) {
            assert (this.cancelled) : "Interruption via Thread#interrupt() is unsupported. Use CancellableThreads#cancel() instead";
            cancelledByExternalInterrupt = !this.cancelled;
        }
        catch (RuntimeException t) {
            runtimeException = t;
        }
        finally {
            this.remove();
        }
        if (wasInterrupted) {
            Thread.currentThread().interrupt();
        } else {
            Thread.interrupted();
        }
        this.checkForCancel(runtimeException);
        if (runtimeException != null) {
            throw runtimeException;
        }
        if (cancelledByExternalInterrupt) {
            Thread.currentThread().interrupt();
            throw new RuntimeException("Interruption via Thread#interrupt() is unsupported. Use CancellableThreads#cancel() instead");
        }
    }

    private synchronized void remove() {
        this.threads.remove(Thread.currentThread());
    }

    public synchronized void cancel(String reason) {
        if (this.cancelled) {
            return;
        }
        this.cancelled = true;
        this.reason = reason;
        for (Thread thread : this.threads) {
            thread.interrupt();
        }
        this.threads.clear();
    }

    public synchronized void setOnCancel(OnCancel onCancel) {
        this.onCancel.set(onCancel);
    }

    @FunctionalInterface
    public static interface OnCancel {
        public void onCancel(String var1, @Nullable Exception var2);
    }

    public static class ExecutionCancelledException
    extends ElasticsearchException {
        public ExecutionCancelledException(String msg) {
            super(msg, new Object[0]);
        }

        public ExecutionCancelledException(StreamInput in) throws IOException {
            super(in);
        }
    }

    public static interface Interruptible {
        public void run() throws InterruptedException;
    }
}

