/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.common.io.stream;

import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;

public class CountingFilterInputStream
extends FilterInputStream {
    private int bytesRead = 0;

    public CountingFilterInputStream(InputStream in) {
        super(in);
    }

    @Override
    public int read() throws IOException {
        assert (this.assertInvariant());
        int result = super.read();
        if (result != -1) {
            ++this.bytesRead;
        }
        return result;
    }

    @Override
    public int read(byte[] b, int off, int len) throws IOException {
        assert (this.assertInvariant());
        int n = super.read(b, off, len);
        if (n != -1) {
            this.bytesRead += n;
        }
        return n;
    }

    @Override
    public long skip(long n) throws IOException {
        assert (this.assertInvariant());
        long skipped = super.skip(n);
        this.bytesRead += Math.toIntExact(skipped);
        return skipped;
    }

    public int getBytesRead() {
        return this.bytesRead;
    }

    protected boolean assertInvariant() {
        return true;
    }
}

