/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.cluster.metadata;

import java.io.IOException;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.TreeMap;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.elasticsearch.TransportVersion;
import org.elasticsearch.TransportVersions;
import org.elasticsearch.cluster.Diff;
import org.elasticsearch.cluster.DiffableUtils;
import org.elasticsearch.cluster.NamedDiff;
import org.elasticsearch.cluster.SimpleDiffable;
import org.elasticsearch.cluster.metadata.Metadata;
import org.elasticsearch.cluster.metadata.SingleNodeShutdownMetadata;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.xcontent.ChunkedToXContentHelper;
import org.elasticsearch.core.Nullable;
import org.elasticsearch.xcontent.ConstructingObjectParser;
import org.elasticsearch.xcontent.ParseField;
import org.elasticsearch.xcontent.ToXContent;
import org.elasticsearch.xcontent.XContentParser;

public class NodesShutdownMetadata
implements Metadata.Custom {
    public static final String TYPE = "node_shutdown";
    public static final TransportVersion NODE_SHUTDOWN_VERSION = TransportVersions.V_7_13_0;
    public static final NodesShutdownMetadata EMPTY = new NodesShutdownMetadata(Map.of());
    private static final ParseField NODES_FIELD = new ParseField("nodes", new String[0]);
    public static final ConstructingObjectParser<NodesShutdownMetadata, Void> PARSER = new ConstructingObjectParser("node_shutdown", a -> {
        Map<String, SingleNodeShutdownMetadata> nodes = ((List)a[0]).stream().collect(Collectors.toMap(SingleNodeShutdownMetadata::getNodeId, Function.identity()));
        return new NodesShutdownMetadata(nodes);
    });
    private final Map<String, SingleNodeShutdownMetadata> nodes;

    public static NodesShutdownMetadata fromXContent(XContentParser parser) {
        return PARSER.apply(parser, null);
    }

    public static NamedDiff<Metadata.Custom> readDiffFrom(StreamInput in) throws IOException {
        return new NodeShutdownMetadataDiff(in);
    }

    public NodesShutdownMetadata(Map<String, SingleNodeShutdownMetadata> nodes) {
        this.nodes = Map.copyOf(nodes);
    }

    public NodesShutdownMetadata(StreamInput in) throws IOException {
        this(in.readImmutableMap(SingleNodeShutdownMetadata::new));
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        out.writeMap(this.nodes, StreamOutput::writeWriteable);
    }

    public Map<String, SingleNodeShutdownMetadata> getAll() {
        return this.nodes;
    }

    public Set<String> getAllNodeIds() {
        return this.nodes.keySet();
    }

    @Nullable
    public SingleNodeShutdownMetadata get(String nodeId) {
        return this.nodes.get(nodeId);
    }

    public boolean contains(String nodeId) {
        return this.get(nodeId) != null;
    }

    @Nullable
    public SingleNodeShutdownMetadata get(String nodeId, SingleNodeShutdownMetadata.Type type) {
        SingleNodeShutdownMetadata shutdown = this.get(nodeId);
        return shutdown != null && shutdown.getType() == type ? shutdown : null;
    }

    public boolean contains(String nodeId, SingleNodeShutdownMetadata.Type type) {
        return this.get(nodeId, type) != null;
    }

    public boolean isNodeMarkedForRemoval(String nodeId) {
        SingleNodeShutdownMetadata singleNodeShutdownMetadata = this.get(nodeId);
        return singleNodeShutdownMetadata != null && singleNodeShutdownMetadata.getType().isRemovalType();
    }

    public NodesShutdownMetadata putSingleNodeMetadata(SingleNodeShutdownMetadata nodeShutdownMetadata) {
        HashMap<String, SingleNodeShutdownMetadata> newNodes = new HashMap<String, SingleNodeShutdownMetadata>(this.nodes);
        newNodes.put(nodeShutdownMetadata.getNodeId(), nodeShutdownMetadata);
        return new NodesShutdownMetadata(newNodes);
    }

    public NodesShutdownMetadata removeSingleNodeMetadata(String nodeId) {
        HashMap<String, SingleNodeShutdownMetadata> newNodes = new HashMap<String, SingleNodeShutdownMetadata>(this.nodes);
        newNodes.remove(nodeId);
        return new NodesShutdownMetadata(newNodes);
    }

    @Override
    public Diff<Metadata.Custom> diff(Metadata.Custom previousState) {
        return new NodeShutdownMetadataDiff((NodesShutdownMetadata)previousState, this);
    }

    @Override
    public EnumSet<Metadata.XContentContext> context() {
        return Metadata.ALL_CONTEXTS;
    }

    @Override
    public String getWriteableName() {
        return TYPE;
    }

    @Override
    public TransportVersion getMinimalSupportedVersion() {
        return NODE_SHUTDOWN_VERSION;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof NodesShutdownMetadata)) {
            return false;
        }
        NodesShutdownMetadata that = (NodesShutdownMetadata)o;
        return this.nodes.equals(that.nodes);
    }

    public int hashCode() {
        return Objects.hash(this.nodes);
    }

    @Override
    public Iterator<? extends ToXContent> toXContentChunked(ToXContent.Params params) {
        return ChunkedToXContentHelper.xContentObjectFields(NODES_FIELD.getPreferredName(), this.nodes);
    }

    static {
        PARSER.declareNamedObjects(ConstructingObjectParser.constructorArg(), (p, c, n) -> SingleNodeShutdownMetadata.parse(p), v -> {
            throw new IllegalArgumentException("ordered " + NODES_FIELD.getPreferredName() + " are not supported");
        }, NODES_FIELD);
    }

    public static class NodeShutdownMetadataDiff
    implements NamedDiff<Metadata.Custom> {
        private final Diff<Map<String, SingleNodeShutdownMetadata>> nodesDiff;

        NodeShutdownMetadataDiff(NodesShutdownMetadata before, NodesShutdownMetadata after) {
            this.nodesDiff = DiffableUtils.diff(before.nodes, after.nodes, DiffableUtils.getStringKeySerializer());
        }

        public NodeShutdownMetadataDiff(StreamInput in) throws IOException {
            this.nodesDiff = DiffableUtils.readJdkMapDiff(in, DiffableUtils.getStringKeySerializer(), SingleNodeShutdownMetadata::new, NodeShutdownMetadataDiff::readNodesDiffFrom);
        }

        @Override
        public Metadata.Custom apply(Metadata.Custom part) {
            TreeMap<String, SingleNodeShutdownMetadata> newNodes = new TreeMap<String, SingleNodeShutdownMetadata>(this.nodesDiff.apply(((NodesShutdownMetadata)part).nodes));
            return new NodesShutdownMetadata(newNodes);
        }

        @Override
        public String getWriteableName() {
            return NodesShutdownMetadata.TYPE;
        }

        @Override
        public void writeTo(StreamOutput out) throws IOException {
            this.nodesDiff.writeTo(out);
        }

        static Diff<SingleNodeShutdownMetadata> readNodesDiffFrom(StreamInput in) throws IOException {
            return SimpleDiffable.readDiffFrom(SingleNodeShutdownMetadata::new, in);
        }

        @Override
        public TransportVersion getMinimalSupportedVersion() {
            return NODE_SHUTDOWN_VERSION;
        }
    }
}

