/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.cluster.metadata;

import java.io.IOException;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.elasticsearch.gateway.MetadataStateFormat;
import org.elasticsearch.index.Index;
import org.elasticsearch.xcontent.ConstructingObjectParser;
import org.elasticsearch.xcontent.ObjectParser;
import org.elasticsearch.xcontent.ParseField;
import org.elasticsearch.xcontent.ToXContent;
import org.elasticsearch.xcontent.ToXContentFragment;
import org.elasticsearch.xcontent.XContentBuilder;
import org.elasticsearch.xcontent.XContentParser;

public record Manifest(long currentTerm, long clusterStateVersion, long globalGeneration, Map<Index, Long> indexGenerations) implements ToXContentFragment
{
    private static final long MISSING_GLOBAL_GENERATION = -1L;
    private static final long MISSING_CURRENT_TERM = 0L;
    private static final long UNKNOWN_CURRENT_TERM = 0L;
    private static final long MISSING_CLUSTER_STATE_VERSION = 0L;
    private static final long UNKNOWN_CLUSTER_STATE_VERSION = 0L;
    private static final String MANIFEST_FILE_PREFIX = "manifest-";
    private static final ToXContent.Params MANIFEST_FORMAT_PARAMS = new ToXContent.MapParams(Collections.singletonMap("binary", "true"));
    public static final MetadataStateFormat<Manifest> FORMAT = new MetadataStateFormat<Manifest>("manifest-"){

        @Override
        public void toXContent(XContentBuilder builder, Manifest state) throws IOException {
            state.toXContent(builder, MANIFEST_FORMAT_PARAMS);
        }

        @Override
        public Manifest fromXContent(XContentParser parser) throws IOException {
            return Manifest.fromXContent(parser);
        }
    };
    private static final ParseField CURRENT_TERM_PARSE_FIELD = new ParseField("current_term", new String[0]);
    private static final ParseField CLUSTER_STATE_VERSION_PARSE_FIELD = new ParseField("cluster_state_version", new String[0]);
    private static final ParseField GENERATION_PARSE_FIELD = new ParseField("generation", new String[0]);
    private static final ParseField INDEX_GENERATIONS_PARSE_FIELD = new ParseField("index_generations", new String[0]);
    private static final ConstructingObjectParser<Manifest, Void> PARSER = new ConstructingObjectParser("manifest", manifestFields -> new Manifest(Manifest.currentTerm(manifestFields), Manifest.clusterStateVersion(manifestFields), Manifest.generation(manifestFields), Manifest.indices(manifestFields)));

    public static Manifest unknownCurrentTermAndVersion(long globalGeneration, Map<Index, Long> indexGenerations) {
        return new Manifest(0L, 0L, globalGeneration, indexGenerations);
    }

    @Override
    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.field(CURRENT_TERM_PARSE_FIELD.getPreferredName(), this.currentTerm);
        builder.field(CLUSTER_STATE_VERSION_PARSE_FIELD.getPreferredName(), this.clusterStateVersion);
        builder.field(GENERATION_PARSE_FIELD.getPreferredName(), this.globalGeneration);
        builder.xContentList(INDEX_GENERATIONS_PARSE_FIELD.getPreferredName(), this.indexEntryList());
        return builder;
    }

    private static long requireNonNullElseDefault(Long value, long defaultValue) {
        return value != null ? value : defaultValue;
    }

    private List<IndexEntry> indexEntryList() {
        return this.indexGenerations.entrySet().stream().map(entry -> new IndexEntry((Index)entry.getKey(), (Long)entry.getValue())).toList();
    }

    private static long currentTerm(Object[] manifestFields) {
        return Manifest.requireNonNullElseDefault((Long)manifestFields[0], 0L);
    }

    private static long clusterStateVersion(Object[] manifestFields) {
        return Manifest.requireNonNullElseDefault((Long)manifestFields[1], 0L);
    }

    private static long generation(Object[] manifestFields) {
        return Manifest.requireNonNullElseDefault((Long)manifestFields[2], -1L);
    }

    private static Map<Index, Long> indices(Object[] manifestFields) {
        List listOfIndices = (List)manifestFields[3];
        return listOfIndices.stream().collect(Collectors.toMap(IndexEntry::index, IndexEntry::generation));
    }

    public static Manifest fromXContent(XContentParser parser) throws IOException {
        return PARSER.parse(parser, null);
    }

    public boolean isEmpty() {
        return this.currentTerm == 0L && this.clusterStateVersion == 0L && this.globalGeneration == -1L && this.indexGenerations.isEmpty();
    }

    public static Manifest empty() {
        return new Manifest(0L, 0L, -1L, Collections.emptyMap());
    }

    public boolean isGlobalGenerationMissing() {
        return this.globalGeneration == -1L;
    }

    static {
        PARSER.declareLong(ConstructingObjectParser.constructorArg(), CURRENT_TERM_PARSE_FIELD);
        PARSER.declareLong(ConstructingObjectParser.constructorArg(), CLUSTER_STATE_VERSION_PARSE_FIELD);
        PARSER.declareLong(ConstructingObjectParser.constructorArg(), GENERATION_PARSE_FIELD);
        PARSER.declareObjectArray(ConstructingObjectParser.constructorArg(), IndexEntry.INDEX_ENTRY_PARSER, INDEX_GENERATIONS_PARSE_FIELD);
    }

    private record IndexEntry(Index index, long generation) implements ToXContentFragment
    {
        private static final ParseField INDEX_GENERATION_PARSE_FIELD = new ParseField("generation", new String[0]);
        private static final ParseField INDEX_PARSE_FIELD = new ParseField("index", new String[0]);
        static final ConstructingObjectParser<IndexEntry, Void> INDEX_ENTRY_PARSER = new ConstructingObjectParser("indexEntry", indexAndGeneration -> new IndexEntry((Index)indexAndGeneration[0], (Long)indexAndGeneration[1]));

        @Override
        public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
            builder.startObject();
            builder.field(INDEX_PARSE_FIELD.getPreferredName(), this.index);
            builder.field(GENERATION_PARSE_FIELD.getPreferredName(), this.generation);
            builder.endObject();
            return builder;
        }

        static {
            INDEX_ENTRY_PARSER.declareField(ConstructingObjectParser.constructorArg(), Index::fromXContent, INDEX_PARSE_FIELD, ObjectParser.ValueType.OBJECT);
            INDEX_ENTRY_PARSER.declareLong(ConstructingObjectParser.constructorArg(), INDEX_GENERATION_PARSE_FIELD);
        }
    }
}

