/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.cluster.metadata;

import java.io.IOException;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import org.elasticsearch.TransportVersion;
import org.elasticsearch.TransportVersions;
import org.elasticsearch.action.admin.indices.rollover.RolloverConfiguration;
import org.elasticsearch.action.downsample.DownsampleConfig;
import org.elasticsearch.cluster.Diff;
import org.elasticsearch.cluster.SimpleDiffable;
import org.elasticsearch.cluster.metadata.DataStreamGlobalRetention;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.io.stream.Writeable;
import org.elasticsearch.common.logging.HeaderWarning;
import org.elasticsearch.common.settings.Setting;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.core.Nullable;
import org.elasticsearch.core.TimeValue;
import org.elasticsearch.core.Tuple;
import org.elasticsearch.search.aggregations.bucket.histogram.DateHistogramInterval;
import org.elasticsearch.xcontent.AbstractObjectParser;
import org.elasticsearch.xcontent.ConstructingObjectParser;
import org.elasticsearch.xcontent.ObjectParser;
import org.elasticsearch.xcontent.ParseField;
import org.elasticsearch.xcontent.ToXContent;
import org.elasticsearch.xcontent.ToXContentFragment;
import org.elasticsearch.xcontent.ToXContentObject;
import org.elasticsearch.xcontent.XContentBuilder;
import org.elasticsearch.xcontent.XContentParser;

public class DataStreamLifecycle
implements SimpleDiffable<DataStreamLifecycle>,
ToXContentObject {
    public static final TransportVersion ADDED_ENABLED_FLAG_VERSION = TransportVersions.V_8_10_X;
    public static final String EFFECTIVE_RETENTION_REST_API_CAPABILITY = "data_stream_lifecycle_effective_retention";
    public static final String DATA_STREAMS_LIFECYCLE_ONLY_SETTING_NAME = "data_streams.lifecycle_only.mode";
    public static final String INCLUDE_EFFECTIVE_RETENTION_PARAM_NAME = "include_effective_retention";
    public static final Map<String, String> INCLUDE_EFFECTIVE_RETENTION_PARAMS = Map.of("include_effective_retention", "true");
    public static final Tuple<TimeValue, RetentionSource> INFINITE_RETENTION = Tuple.tuple(null, RetentionSource.DATA_STREAM_CONFIGURATION);
    public static final Setting<RolloverConfiguration> CLUSTER_LIFECYCLE_DEFAULT_ROLLOVER_SETTING = new Setting<RolloverConfiguration>("cluster.lifecycle.default.rollover", "max_age=auto,max_primary_shard_size=50gb,min_docs=1,max_primary_shard_docs=200000000", s -> RolloverConfiguration.parseSetting(s, "cluster.lifecycle.default.rollover"), Setting.Property.Dynamic, Setting.Property.NodeScope);
    public static final DataStreamLifecycle DEFAULT = new DataStreamLifecycle();
    public static final String DATA_STREAM_LIFECYCLE_ORIGIN = "data_stream_lifecycle";
    public static final ParseField ENABLED_FIELD = new ParseField("enabled", new String[0]);
    public static final ParseField DATA_RETENTION_FIELD = new ParseField("data_retention", new String[0]);
    public static final ParseField EFFECTIVE_RETENTION_FIELD = new ParseField("effective_retention", new String[0]);
    public static final ParseField RETENTION_SOURCE_FIELD = new ParseField("retention_determined_by", new String[0]);
    public static final ParseField DOWNSAMPLING_FIELD = new ParseField("downsampling", new String[0]);
    private static final ParseField ROLLOVER_FIELD = new ParseField("rollover", new String[0]);
    public static final ConstructingObjectParser<DataStreamLifecycle, Void> PARSER = new ConstructingObjectParser<DataStreamLifecycle, Void>("lifecycle", false, (args, unused) -> new DataStreamLifecycle((Retention)args[0], (Downsampling)args[1], (Boolean)args[2]));
    @Nullable
    private final Retention dataRetention;
    @Nullable
    private final Downsampling downsampling;
    private final boolean enabled;

    public static boolean isDataStreamsLifecycleOnlyMode(Settings settings) {
        return settings.getAsBoolean(DATA_STREAMS_LIFECYCLE_ONLY_SETTING_NAME, false);
    }

    public DataStreamLifecycle() {
        this(null, null, null);
    }

    public DataStreamLifecycle(@Nullable Retention dataRetention, @Nullable Downsampling downsampling, @Nullable Boolean enabled) {
        this.enabled = enabled == null || enabled != false;
        this.dataRetention = dataRetention;
        this.downsampling = downsampling;
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    @Nullable
    public TimeValue getEffectiveDataRetention(@Nullable DataStreamGlobalRetention globalRetention, boolean isInternalDataStream) {
        return this.getEffectiveDataRetentionWithSource(globalRetention, isInternalDataStream).v1();
    }

    public Tuple<TimeValue, RetentionSource> getEffectiveDataRetentionWithSource(@Nullable DataStreamGlobalRetention globalRetention, boolean isInternalDataStream) {
        if (!this.enabled) {
            return INFINITE_RETENTION;
        }
        TimeValue dataStreamRetention = this.getDataStreamRetention();
        if (globalRetention == null || isInternalDataStream) {
            return Tuple.tuple(dataStreamRetention, RetentionSource.DATA_STREAM_CONFIGURATION);
        }
        if (dataStreamRetention == null) {
            return globalRetention.defaultRetention() != null ? Tuple.tuple(globalRetention.defaultRetention(), RetentionSource.DEFAULT_GLOBAL_RETENTION) : Tuple.tuple(globalRetention.maxRetention(), RetentionSource.MAX_GLOBAL_RETENTION);
        }
        if (globalRetention.maxRetention() != null && globalRetention.maxRetention().getMillis() < dataStreamRetention.getMillis()) {
            return Tuple.tuple(globalRetention.maxRetention(), RetentionSource.MAX_GLOBAL_RETENTION);
        }
        return Tuple.tuple(dataStreamRetention, RetentionSource.DATA_STREAM_CONFIGURATION);
    }

    @Nullable
    public TimeValue getDataStreamRetention() {
        return this.dataRetention == null ? null : this.dataRetention.value;
    }

    public void addWarningHeaderIfDataRetentionNotEffective(@Nullable DataStreamGlobalRetention globalRetention, boolean isInternalDataStream) {
        if (globalRetention == null || isInternalDataStream) {
            return;
        }
        Tuple<TimeValue, RetentionSource> effectiveDataRetentionWithSource = this.getEffectiveDataRetentionWithSource(globalRetention, isInternalDataStream);
        if (effectiveDataRetentionWithSource.v1() == null) {
            return;
        }
        String effectiveRetentionStringRep = effectiveDataRetentionWithSource.v1().getStringRep();
        switch (effectiveDataRetentionWithSource.v2().ordinal()) {
            case 1: {
                HeaderWarning.addWarning("Not providing a retention is not allowed for this project. The default retention of [" + effectiveRetentionStringRep + "] will be applied.", new Object[0]);
                break;
            }
            case 2: {
                String retentionProvidedPart = this.getDataStreamRetention() == null ? "Not providing a retention is not allowed for this project." : "The retention provided [" + (this.getDataStreamRetention() == null ? "infinite" : this.getDataStreamRetention().getStringRep()) + "] is exceeding the max allowed data retention of this project [" + effectiveRetentionStringRep + "].";
                HeaderWarning.addWarning(retentionProvidedPart + " The max retention of [" + effectiveRetentionStringRep + "] will be applied", new Object[0]);
                break;
            }
        }
    }

    @Nullable
    Retention getDataRetention() {
        return this.dataRetention;
    }

    @Nullable
    public List<Downsampling.Round> getDownsamplingRounds() {
        return this.downsampling == null ? null : this.downsampling.rounds();
    }

    @Nullable
    Downsampling getDownsampling() {
        return this.downsampling;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DataStreamLifecycle that = (DataStreamLifecycle)o;
        return Objects.equals(this.dataRetention, that.dataRetention) && Objects.equals(this.downsampling, that.downsampling) && this.enabled == that.enabled;
    }

    public int hashCode() {
        return Objects.hash(this.dataRetention, this.downsampling, this.enabled);
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        if (out.getTransportVersion().onOrAfter(TransportVersions.V_8_9_X)) {
            out.writeOptionalWriteable(this.dataRetention);
        }
        if (out.getTransportVersion().onOrAfter(ADDED_ENABLED_FLAG_VERSION)) {
            out.writeOptionalWriteable(this.downsampling);
            out.writeBoolean(this.enabled);
        }
    }

    public DataStreamLifecycle(StreamInput in) throws IOException {
        this.dataRetention = in.getTransportVersion().onOrAfter(TransportVersions.V_8_9_X) ? in.readOptionalWriteable(Retention::read) : null;
        if (in.getTransportVersion().onOrAfter(ADDED_ENABLED_FLAG_VERSION)) {
            this.downsampling = in.readOptionalWriteable(Downsampling::read);
            this.enabled = in.readBoolean();
        } else {
            this.downsampling = null;
            this.enabled = true;
        }
    }

    public static Diff<DataStreamLifecycle> readDiffFrom(StreamInput in) throws IOException {
        return SimpleDiffable.readDiffFrom(DataStreamLifecycle::new, in);
    }

    public String toString() {
        return Strings.toString(this, true, true);
    }

    @Override
    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        return this.toXContent(builder, params, null, null, false);
    }

    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params, @Nullable RolloverConfiguration rolloverConfiguration, @Nullable DataStreamGlobalRetention globalRetention, boolean isInternalDataStream) throws IOException {
        builder.startObject();
        builder.field(ENABLED_FIELD.getPreferredName(), this.enabled);
        if (this.dataRetention != null) {
            if (this.dataRetention.value() == null) {
                builder.nullField(DATA_RETENTION_FIELD.getPreferredName());
            } else {
                builder.field(DATA_RETENTION_FIELD.getPreferredName(), this.dataRetention.value().getStringRep());
            }
        }
        Tuple<TimeValue, RetentionSource> effectiveDataRetentionWithSource = this.getEffectiveDataRetentionWithSource(globalRetention, isInternalDataStream);
        if (params.paramAsBoolean(INCLUDE_EFFECTIVE_RETENTION_PARAM_NAME, false) && effectiveDataRetentionWithSource.v1() != null) {
            builder.field(EFFECTIVE_RETENTION_FIELD.getPreferredName(), effectiveDataRetentionWithSource.v1().getStringRep());
            builder.field(RETENTION_SOURCE_FIELD.getPreferredName(), effectiveDataRetentionWithSource.v2().displayName());
        }
        if (this.downsampling != null) {
            builder.field(DOWNSAMPLING_FIELD.getPreferredName());
            this.downsampling.toXContent(builder, params);
        }
        if (rolloverConfiguration != null) {
            builder.field(ROLLOVER_FIELD.getPreferredName());
            rolloverConfiguration.evaluateAndConvertToXContent(builder, params, effectiveDataRetentionWithSource.v1());
        }
        builder.endObject();
        return builder;
    }

    public static DataStreamLifecycle fromXContent(XContentParser parser) throws IOException {
        return PARSER.parse(parser, null);
    }

    public static ToXContent.Params addEffectiveRetentionParams(ToXContent.Params params) {
        return new ToXContent.DelegatingMapParams(INCLUDE_EFFECTIVE_RETENTION_PARAMS, params);
    }

    public static Builder newBuilder(DataStreamLifecycle lifecycle) {
        return new Builder().dataRetention(lifecycle.getDataRetention()).downsampling(lifecycle.getDownsampling()).enabled(lifecycle.isEnabled());
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    static {
        PARSER.declareField(ConstructingObjectParser.optionalConstructorArg(), (p, c) -> {
            String value = p.textOrNull();
            if (value == null) {
                return Retention.NULL;
            }
            return new Retention(TimeValue.parseTimeValue(value, DATA_RETENTION_FIELD.getPreferredName()));
        }, DATA_RETENTION_FIELD, ObjectParser.ValueType.STRING_OR_NULL);
        PARSER.declareField(ConstructingObjectParser.optionalConstructorArg(), (p, c) -> {
            if (p.currentToken() == XContentParser.Token.VALUE_NULL) {
                return Downsampling.NULL;
            }
            return new Downsampling(AbstractObjectParser.parseArray(p, c, Downsampling.Round::fromXContent));
        }, DOWNSAMPLING_FIELD, ObjectParser.ValueType.OBJECT_ARRAY_OR_NULL);
        PARSER.declareBoolean(ConstructingObjectParser.optionalConstructorArg(), ENABLED_FIELD);
    }

    public record Retention(@Nullable TimeValue value) implements Writeable
    {
        public static final Retention NULL = new Retention(null);

        public static Retention read(StreamInput in) throws IOException {
            return new Retention(in.readOptionalTimeValue());
        }

        @Override
        public void writeTo(StreamOutput out) throws IOException {
            out.writeOptionalTimeValue(this.value);
        }
    }

    public record Downsampling(@Nullable List<Round> rounds) implements Writeable,
    ToXContentFragment
    {
        public static final long FIVE_MINUTES_MILLIS = TimeValue.timeValueMinutes(5L).getMillis();
        public static final Downsampling NULL = new Downsampling(null);

        public Downsampling {
            if (rounds != null) {
                if (rounds.isEmpty()) {
                    throw new IllegalArgumentException("Downsampling configuration should have at least one round configured.");
                }
                if (rounds.size() > 10) {
                    throw new IllegalArgumentException("Downsampling configuration supports maximum 10 configured rounds. Found: " + rounds.size());
                }
                Round previous = null;
                for (Round round : rounds) {
                    if (previous == null) {
                        previous = round;
                        continue;
                    }
                    if (round.after.compareTo(previous.after) < 0) {
                        throw new IllegalArgumentException("A downsampling round must have a later 'after' value than the proceeding, " + round.after.getStringRep() + " is not after " + previous.after.getStringRep() + ".");
                    }
                    DownsampleConfig.validateSourceAndTargetIntervals(previous.config(), round.config());
                }
            }
        }

        public static Downsampling read(StreamInput in) throws IOException {
            return new Downsampling(in.readOptionalCollectionAsList(Round::read));
        }

        @Override
        public void writeTo(StreamOutput out) throws IOException {
            out.writeOptionalCollection(this.rounds, StreamOutput::writeWriteable);
        }

        @Override
        public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
            if (this.rounds == null) {
                builder.nullValue();
            } else {
                builder.startArray();
                for (Round round : this.rounds) {
                    round.toXContent(builder, params);
                }
                builder.endArray();
            }
            return builder;
        }

        public record Round(TimeValue after, DownsampleConfig config) implements Writeable,
        ToXContentObject
        {
            public static final ParseField AFTER_FIELD = new ParseField("after", new String[0]);
            public static final ParseField FIXED_INTERVAL_FIELD = new ParseField("fixed_interval", new String[0]);
            private static final ConstructingObjectParser<Round, Void> PARSER = new ConstructingObjectParser<Round, Void>("downsampling_round", false, (args, unused) -> new Round((TimeValue)args[0], new DownsampleConfig((DateHistogramInterval)args[1])));

            public Round {
                if (config.getFixedInterval().estimateMillis() < FIVE_MINUTES_MILLIS) {
                    throw new IllegalArgumentException("A downsampling round must have a fixed interval of at least five minutes but found: " + String.valueOf(config.getFixedInterval()));
                }
            }

            public static Round read(StreamInput in) throws IOException {
                return new Round(in.readTimeValue(), new DownsampleConfig(in));
            }

            @Override
            public void writeTo(StreamOutput out) throws IOException {
                out.writeTimeValue(this.after);
                out.writeWriteable(this.config);
            }

            @Override
            public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
                builder.startObject();
                builder.field(AFTER_FIELD.getPreferredName(), this.after.getStringRep());
                this.config.toXContentFragment(builder);
                builder.endObject();
                return builder;
            }

            public static Round fromXContent(XContentParser parser, Void context) throws IOException {
                return PARSER.parse(parser, context);
            }

            @Override
            public String toString() {
                return Strings.toString(this, true, true);
            }

            static {
                PARSER.declareString(ConstructingObjectParser.optionalConstructorArg(), value -> TimeValue.parseTimeValue(value, AFTER_FIELD.getPreferredName()), AFTER_FIELD);
                PARSER.declareField(ConstructingObjectParser.constructorArg(), p -> new DateHistogramInterval(p.text()), new ParseField(FIXED_INTERVAL_FIELD.getPreferredName(), new String[0]), ObjectParser.ValueType.STRING);
            }
        }
    }

    public static enum RetentionSource {
        DATA_STREAM_CONFIGURATION,
        DEFAULT_GLOBAL_RETENTION,
        MAX_GLOBAL_RETENTION;


        public String displayName() {
            return this.toString().toLowerCase(Locale.ROOT);
        }
    }

    public static class Builder {
        @Nullable
        private Retention dataRetention = null;
        @Nullable
        private Downsampling downsampling = null;
        private boolean enabled = true;

        public Builder enabled(boolean value) {
            this.enabled = value;
            return this;
        }

        public Builder dataRetention(@Nullable Retention value) {
            this.dataRetention = value;
            return this;
        }

        public Builder dataRetention(@Nullable TimeValue value) {
            this.dataRetention = value == null ? null : new Retention(value);
            return this;
        }

        public Builder dataRetention(long value) {
            this.dataRetention = new Retention(TimeValue.timeValueMillis(value));
            return this;
        }

        public Builder downsampling(@Nullable Downsampling value) {
            this.downsampling = value;
            return this;
        }

        public DataStreamLifecycle build() {
            return new DataStreamLifecycle(this.dataRetention, this.downsampling, this.enabled);
        }
    }
}

