/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.action.support.single.instance;

import java.io.IOException;
import org.elasticsearch.action.ActionRequest;
import org.elasticsearch.action.ActionRequestValidationException;
import org.elasticsearch.action.IndicesRequest;
import org.elasticsearch.action.ValidateActions;
import org.elasticsearch.action.support.IndicesOptions;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.core.Nullable;
import org.elasticsearch.core.TimeValue;
import org.elasticsearch.index.shard.ShardId;

public abstract class InstanceShardOperationRequest<Request extends InstanceShardOperationRequest<Request>>
extends ActionRequest
implements IndicesRequest {
    public static final TimeValue DEFAULT_TIMEOUT = TimeValue.timeValueMinutes(1L);
    protected TimeValue timeout = DEFAULT_TIMEOUT;
    protected String index;
    protected ShardId shardId = null;
    private String concreteIndex;

    protected InstanceShardOperationRequest() {
    }

    protected InstanceShardOperationRequest(@Nullable ShardId shardId, StreamInput in) throws IOException {
        super(in);
        if (shardId == null) {
            this.index = in.readString();
            this.shardId = in.readOptionalWriteable(ShardId::new);
        } else {
            this.shardId = shardId;
            this.index = in.readBoolean() ? in.readString() : shardId.getIndexName();
        }
        this.timeout = in.readTimeValue();
        this.concreteIndex = in.readOptionalString();
    }

    public InstanceShardOperationRequest(String index) {
        this.index = index;
    }

    @Override
    public ActionRequestValidationException validate() {
        ActionRequestValidationException validationException = null;
        if (this.index == null) {
            validationException = ValidateActions.addValidationError("index is missing", validationException);
        }
        return validationException;
    }

    public String index() {
        return this.index;
    }

    @Override
    public String[] indices() {
        return new String[]{this.index};
    }

    @Override
    public IndicesOptions indicesOptions() {
        return IndicesOptions.strictSingleIndexNoExpandForbidClosed();
    }

    public final Request index(String index) {
        this.index = index;
        return (Request)this;
    }

    public TimeValue timeout() {
        return this.timeout;
    }

    public final Request timeout(TimeValue timeout) {
        this.timeout = timeout;
        return (Request)this;
    }

    public String concreteIndex() {
        return this.concreteIndex;
    }

    void concreteIndex(String concreteIndex) {
        this.concreteIndex = concreteIndex;
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        super.writeTo(out);
        out.writeString(this.index);
        out.writeOptionalWriteable(this.shardId);
        out.writeTimeValue(this.timeout);
        out.writeOptionalString(this.concreteIndex);
    }

    public void writeThin(StreamOutput out) throws IOException {
        super.writeTo(out);
        if (this.shardId != null && this.index.equals(this.shardId.getIndexName())) {
            out.writeBoolean(false);
        } else {
            out.writeBoolean(true);
            out.writeString(this.index);
        }
        out.writeTimeValue(this.timeout);
        out.writeOptionalString(this.concreteIndex);
    }
}

