/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.action.support.replication;

import java.util.concurrent.Executor;
import org.apache.lucene.store.AlreadyClosedException;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.ActionListenerResponseHandler;
import org.elasticsearch.action.ActionResponse;
import org.elasticsearch.action.admin.indices.refresh.UnpromotableShardRefreshRequest;
import org.elasticsearch.action.support.WriteRequest;
import org.elasticsearch.common.util.concurrent.ThreadContext;
import org.elasticsearch.core.Nullable;
import org.elasticsearch.core.TimeValue;
import org.elasticsearch.index.engine.Engine;
import org.elasticsearch.index.shard.IndexShard;
import org.elasticsearch.index.translog.Translog;
import org.elasticsearch.transport.TransportRequest;
import org.elasticsearch.transport.TransportRequestOptions;
import org.elasticsearch.transport.TransportService;

public class PostWriteRefresh {
    public static final String POST_WRITE_REFRESH_ORIGIN = "post_write_refresh";
    public static final String FORCED_REFRESH_AFTER_INDEX = "refresh_flag_index";
    private final TransportService transportService;
    private final Executor refreshExecutor;

    public PostWriteRefresh(TransportService transportService) {
        this.transportService = transportService;
        this.refreshExecutor = transportService.getThreadPool().executor("refresh");
    }

    public void refreshShard(WriteRequest.RefreshPolicy policy, final IndexShard indexShard, final @Nullable Translog.Location location, final ActionListener<Boolean> listener, final @Nullable TimeValue postWriteRefreshTimeout) {
        switch (policy) {
            case NONE: {
                listener.onResponse(false);
                break;
            }
            case WAIT_UNTIL: {
                PostWriteRefresh.waitUntil(indexShard, location, new ActionListener<Boolean>(){

                    @Override
                    public void onResponse(Boolean forced) {
                        if (location != null && !indexShard.routingEntry().isSearchable()) {
                            PostWriteRefresh.this.refreshUnpromotables(indexShard, location, listener, forced, postWriteRefreshTimeout);
                        } else {
                            listener.onResponse(forced);
                        }
                    }

                    @Override
                    public void onFailure(Exception e) {
                        listener.onFailure(e);
                    }
                });
                break;
            }
            case IMMEDIATE: {
                PostWriteRefresh.immediate(indexShard, listener.delegateFailureAndWrap((l, r) -> {
                    if (indexShard.getReplicationGroup().getRoutingTable().allUnpromotableShards().size() > 0) {
                        this.sendUnpromotableRequests(indexShard, r.generation(), true, (ActionListener<Boolean>)l, postWriteRefreshTimeout);
                    } else {
                        l.onResponse(true);
                    }
                }));
                break;
            }
            default: {
                throw new IllegalArgumentException("unknown refresh policy: " + String.valueOf(policy));
            }
        }
    }

    public static void refreshReplicaShard(WriteRequest.RefreshPolicy policy, IndexShard indexShard, @Nullable Translog.Location location, ActionListener<Boolean> listener) {
        switch (policy) {
            case NONE: {
                listener.onResponse(false);
                break;
            }
            case WAIT_UNTIL: {
                PostWriteRefresh.waitUntil(indexShard, location, listener);
                break;
            }
            case IMMEDIATE: {
                PostWriteRefresh.immediate(indexShard, listener.map(r -> true));
                break;
            }
            default: {
                throw new IllegalArgumentException("unknown refresh policy: " + String.valueOf(policy));
            }
        }
    }

    private static void immediate(IndexShard indexShard, ActionListener<Engine.RefreshResult> listener) {
        indexShard.externalRefresh(FORCED_REFRESH_AFTER_INDEX, listener);
    }

    private static void waitUntil(IndexShard indexShard, Translog.Location location, ActionListener<Boolean> listener) {
        if (location != null) {
            indexShard.addRefreshListener(location, listener::onResponse);
        } else {
            listener.onResponse(false);
        }
    }

    private void refreshUnpromotables(IndexShard indexShard, Translog.Location location, ActionListener<Boolean> listener, boolean forced, @Nullable TimeValue postWriteRefreshTimeout) {
        Engine engineOrNull = indexShard.getEngineOrNull();
        if (engineOrNull == null) {
            listener.onFailure(new AlreadyClosedException("Engine closed during refresh."));
            return;
        }
        engineOrNull.addFlushListener(location, listener.delegateFailureAndWrap((l, generation) -> {
            try (ThreadContext.StoredContext ignore = this.transportService.getThreadPool().getThreadContext().stashWithOrigin(POST_WRITE_REFRESH_ORIGIN);){
                this.sendUnpromotableRequests(indexShard, (long)generation, forced, (ActionListener<Boolean>)l, postWriteRefreshTimeout);
            }
        }));
    }

    private void sendUnpromotableRequests(IndexShard indexShard, long generation, boolean wasForced, ActionListener<Boolean> listener, @Nullable TimeValue postWriteRefreshTimeout) {
        UnpromotableShardRefreshRequest unpromotableReplicaRequest = new UnpromotableShardRefreshRequest(indexShard.getReplicationGroup().getRoutingTable(), indexShard.getOperationPrimaryTerm(), generation, true, postWriteRefreshTimeout);
        this.transportService.sendRequest(this.transportService.getLocalNode(), "indices:admin/refresh/unpromotable", (TransportRequest)unpromotableReplicaRequest, TransportRequestOptions.timeout(postWriteRefreshTimeout), new ActionListenerResponseHandler<ActionResponse.Empty>(listener.safeMap(r -> wasForced), in -> ActionResponse.Empty.INSTANCE, this.refreshExecutor));
    }
}

