/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.action.support;

import java.util.ArrayList;
import java.util.List;
import org.elasticsearch.cluster.ClusterState;
import org.elasticsearch.cluster.metadata.ComposableIndexTemplate;
import org.elasticsearch.cluster.metadata.IndexNameExpressionResolver;
import org.elasticsearch.cluster.metadata.Metadata;
import org.elasticsearch.cluster.metadata.MetadataIndexTemplateService;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.regex.Regex;
import org.elasticsearch.common.settings.ClusterSettings;
import org.elasticsearch.common.settings.Setting;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.core.Booleans;
import org.elasticsearch.core.Tuple;
import org.elasticsearch.index.IndexNotFoundException;
import org.elasticsearch.indices.SystemIndices;

public final class AutoCreateIndex {
    public static final Setting<AutoCreate> AUTO_CREATE_INDEX_SETTING = new Setting<AutoCreate>("action.auto_create_index", "true", AutoCreate::new, Setting.Property.NodeScope, Setting.Property.Dynamic);
    private final IndexNameExpressionResolver resolver;
    private final SystemIndices systemIndices;
    private volatile AutoCreate autoCreate;

    public AutoCreateIndex(Settings settings, ClusterSettings clusterSettings, IndexNameExpressionResolver resolver, SystemIndices systemIndices) {
        this.resolver = resolver;
        this.systemIndices = systemIndices;
        this.autoCreate = AUTO_CREATE_INDEX_SETTING.get(settings);
        clusterSettings.addSettingsUpdateConsumer(AUTO_CREATE_INDEX_SETTING, this::setAutoCreate);
    }

    public boolean shouldAutoCreate(String index, ClusterState state) {
        if (this.resolver.hasIndexAbstraction(index, state)) {
            return false;
        }
        if (this.systemIndices.isSystemName(index)) {
            return true;
        }
        ComposableIndexTemplate template = AutoCreateIndex.findTemplate(index, state.metadata());
        if (template != null && template.getAllowAutoCreate() != null) {
            if (template.getAllowAutoCreate().booleanValue()) {
                return true;
            }
            throw new IndexNotFoundException("composable template " + String.valueOf(template.indexPatterns()) + " forbids index auto creation");
        }
        AutoCreate autoCreate = this.autoCreate;
        if (!autoCreate.autoCreateIndex) {
            throw new IndexNotFoundException("[" + AUTO_CREATE_INDEX_SETTING.getKey() + "] is [false]", index);
        }
        if (autoCreate.expressions.isEmpty()) {
            return true;
        }
        for (Tuple<String, Boolean> expression : autoCreate.expressions) {
            String indexExpression = expression.v1();
            boolean include = expression.v2();
            if (!Regex.simpleMatch(indexExpression, index)) continue;
            if (include) {
                return true;
            }
            throw new IndexNotFoundException("[" + AUTO_CREATE_INDEX_SETTING.getKey() + "] contains [-" + indexExpression + "] which forbids automatic creation of the index", index);
        }
        throw new IndexNotFoundException("[" + AUTO_CREATE_INDEX_SETTING.getKey() + "] ([" + String.valueOf(autoCreate) + "]) doesn't match", index);
    }

    AutoCreate getAutoCreate() {
        return this.autoCreate;
    }

    void setAutoCreate(AutoCreate autoCreate) {
        this.autoCreate = autoCreate;
    }

    private static ComposableIndexTemplate findTemplate(String indexName, Metadata metadata) {
        String templateName = MetadataIndexTemplateService.findV2Template(metadata, indexName, false);
        return metadata.templatesV2().get(templateName);
    }

    static class AutoCreate {
        private final boolean autoCreateIndex;
        private final List<Tuple<String, Boolean>> expressions;
        private final String string;

        private AutoCreate(String value) {
            boolean autoCreateIndex;
            ArrayList<Tuple<String, Boolean>> expressions = new ArrayList<Tuple<String, Boolean>>();
            try {
                autoCreateIndex = Booleans.parseBoolean(value);
            }
            catch (IllegalArgumentException ex) {
                try {
                    String[] patterns;
                    for (String pattern : patterns = Strings.commaDelimitedListToStringArray(value)) {
                        Tuple<String, Boolean> expression;
                        if (pattern == null || pattern.trim().length() == 0) {
                            throw new IllegalArgumentException("Can't parse [" + value + "] for setting [action.auto_create_index] must be either [true, false, or a comma separated list of index patterns]");
                        }
                        if ((pattern = pattern.trim()).startsWith("-")) {
                            if (pattern.length() == 1) {
                                throw new IllegalArgumentException("Can't parse [" + value + "] for setting [action.auto_create_index] must contain an index name after [-]");
                            }
                            expression = new Tuple<String, Boolean>(pattern.substring(1), false);
                        } else if (pattern.startsWith("+")) {
                            if (pattern.length() == 1) {
                                throw new IllegalArgumentException("Can't parse [" + value + "] for setting [action.auto_create_index] must contain an index name after [+]");
                            }
                            expression = new Tuple<String, Boolean>(pattern.substring(1), true);
                        } else {
                            expression = new Tuple<String, Boolean>(pattern, true);
                        }
                        expressions.add(expression);
                    }
                    autoCreateIndex = true;
                }
                catch (IllegalArgumentException ex1) {
                    ex1.addSuppressed(ex);
                    throw ex1;
                }
            }
            this.expressions = expressions;
            this.autoCreateIndex = autoCreateIndex;
            this.string = value;
        }

        boolean isAutoCreateIndex() {
            return this.autoCreateIndex;
        }

        List<Tuple<String, Boolean>> getExpressions() {
            return this.expressions;
        }

        public String toString() {
            return this.string;
        }
    }
}

