/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.action.search;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Executor;
import java.util.function.BiFunction;
import org.apache.logging.log4j.Logger;
import org.apache.lucene.index.Term;
import org.apache.lucene.search.CollectionStatistics;
import org.apache.lucene.search.ScoreDoc;
import org.apache.lucene.search.TermStatistics;
import org.apache.lucene.search.TopDocs;
import org.apache.lucene.search.TotalHits;
import org.apache.lucene.util.SetOnce;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.search.AbstractSearchAsyncAction;
import org.elasticsearch.action.search.ArraySearchPhaseResults;
import org.elasticsearch.action.search.DfsQueryPhase;
import org.elasticsearch.action.search.SearchActionListener;
import org.elasticsearch.action.search.SearchPhase;
import org.elasticsearch.action.search.SearchPhaseController;
import org.elasticsearch.action.search.SearchPhaseResults;
import org.elasticsearch.action.search.SearchProgressListener;
import org.elasticsearch.action.search.SearchQueryThenFetchAsyncAction;
import org.elasticsearch.action.search.SearchRequest;
import org.elasticsearch.action.search.SearchResponse;
import org.elasticsearch.action.search.SearchShardIterator;
import org.elasticsearch.action.search.SearchTask;
import org.elasticsearch.action.search.SearchTransportService;
import org.elasticsearch.action.search.TransportSearchAction;
import org.elasticsearch.client.internal.Client;
import org.elasticsearch.cluster.ClusterState;
import org.elasticsearch.cluster.routing.GroupShardsIterator;
import org.elasticsearch.common.io.stream.NamedWriteableRegistry;
import org.elasticsearch.search.SearchPhaseResult;
import org.elasticsearch.search.SearchShardTarget;
import org.elasticsearch.search.builder.SearchSourceBuilder;
import org.elasticsearch.search.dfs.AggregatedDfs;
import org.elasticsearch.search.dfs.DfsKnnResults;
import org.elasticsearch.search.dfs.DfsSearchResult;
import org.elasticsearch.search.internal.AliasFilter;
import org.elasticsearch.transport.Transport;

final class SearchDfsQueryThenFetchAsyncAction
extends AbstractSearchAsyncAction<DfsSearchResult> {
    private final SearchPhaseResults<SearchPhaseResult> queryPhaseResultConsumer;
    private final SearchProgressListener progressListener;
    private final Client client;

    SearchDfsQueryThenFetchAsyncAction(Logger logger, NamedWriteableRegistry namedWriteableRegistry, SearchTransportService searchTransportService, BiFunction<String, String, Transport.Connection> nodeIdToConnection, Map<String, AliasFilter> aliasFilter, Map<String, Float> concreteIndexBoosts, Executor executor, SearchPhaseResults<SearchPhaseResult> queryPhaseResultConsumer, SearchRequest request, ActionListener<SearchResponse> listener, GroupShardsIterator<SearchShardIterator> shardsIts, TransportSearchAction.SearchTimeProvider timeProvider, ClusterState clusterState, SearchTask task, SearchResponse.Clusters clusters, Client client) {
        super("dfs", logger, namedWriteableRegistry, searchTransportService, nodeIdToConnection, aliasFilter, concreteIndexBoosts, executor, request, listener, shardsIts, timeProvider, clusterState, task, new ArraySearchPhaseResults(shardsIts.size()), request.getMaxConcurrentShardRequests(), clusters);
        this.queryPhaseResultConsumer = queryPhaseResultConsumer;
        this.addReleasable(queryPhaseResultConsumer);
        this.progressListener = task.getProgressListener();
        if (this.progressListener != SearchProgressListener.NOOP) {
            this.notifyListShards(this.progressListener, clusters, request.source());
        }
        this.client = client;
    }

    @Override
    protected void executePhaseOnShard(SearchShardIterator shardIt, Transport.Connection connection, SearchActionListener<DfsSearchResult> listener) {
        this.getSearchTransport().sendExecuteDfs(connection, this.buildShardSearchRequest(shardIt, listener.requestIndex), this.getTask(), listener);
    }

    @Override
    protected SearchPhase getNextPhase() {
        List<DfsSearchResult> dfsSearchResults = this.results.getAtomicArray().asList();
        AggregatedDfs aggregatedDfs = SearchDfsQueryThenFetchAsyncAction.aggregateDfs(dfsSearchResults);
        return new DfsQueryPhase(dfsSearchResults, aggregatedDfs, SearchDfsQueryThenFetchAsyncAction.mergeKnnResults(this.getRequest(), dfsSearchResults), this.queryPhaseResultConsumer, queryResults -> SearchQueryThenFetchAsyncAction.nextPhase(this.client, this, queryResults, aggregatedDfs), this);
    }

    @Override
    protected void onShardGroupFailure(int shardIndex, SearchShardTarget shardTarget, Exception exc) {
        this.progressListener.notifyQueryFailure(shardIndex, shardTarget, exc);
    }

    private static List<DfsKnnResults> mergeKnnResults(SearchRequest request, List<DfsSearchResult> dfsSearchResults) {
        if (!request.hasKnnSearch()) {
            return null;
        }
        SearchSourceBuilder source = request.source();
        ArrayList topDocsLists = new ArrayList(source.knnSearch().size());
        ArrayList nestedPath = new ArrayList(source.knnSearch().size());
        for (int i = 0; i < source.knnSearch().size(); ++i) {
            topDocsLists.add(new ArrayList());
            nestedPath.add(new SetOnce());
        }
        for (DfsSearchResult dfsSearchResult : dfsSearchResults) {
            if (dfsSearchResult.knnResults() == null) continue;
            for (int i = 0; i < dfsSearchResult.knnResults().size(); ++i) {
                DfsKnnResults knnResults = dfsSearchResult.knnResults().get(i);
                ScoreDoc[] scoreDocs = knnResults.scoreDocs();
                TotalHits totalHits = new TotalHits(scoreDocs.length, TotalHits.Relation.EQUAL_TO);
                TopDocs shardTopDocs = new TopDocs(totalHits, scoreDocs);
                SearchPhaseController.setShardIndex(shardTopDocs, dfsSearchResult.getShardIndex());
                ((List)topDocsLists.get(i)).add(shardTopDocs);
                ((SetOnce)nestedPath.get(i)).trySet(knnResults.getNestedPath());
            }
        }
        ArrayList<DfsKnnResults> mergedResults = new ArrayList<DfsKnnResults>(source.knnSearch().size());
        for (int i = 0; i < source.knnSearch().size(); ++i) {
            TopDocs mergedTopDocs = TopDocs.merge(source.knnSearch().get(i).k(), ((List)topDocsLists.get(i)).toArray(new TopDocs[0]));
            mergedResults.add(new DfsKnnResults((String)((SetOnce)nestedPath.get(i)).get(), mergedTopDocs.scoreDocs));
        }
        return mergedResults;
    }

    private static AggregatedDfs aggregateDfs(Collection<DfsSearchResult> results) {
        HashMap<Term, TermStatistics> termStatistics = new HashMap<Term, TermStatistics>();
        HashMap<String, CollectionStatistics> fieldStatistics = new HashMap<String, CollectionStatistics>();
        long aggMaxDoc = 0L;
        for (DfsSearchResult lEntry : results) {
            Term[] terms = lEntry.terms();
            TermStatistics[] stats = lEntry.termStatistics();
            assert (terms.length == stats.length);
            for (int i = 0; i < terms.length; ++i) {
                assert (terms[i] != null);
                if (stats[i] == null) continue;
                TermStatistics existing = (TermStatistics)termStatistics.get(terms[i]);
                if (existing != null) {
                    assert (terms[i].bytes().equals(existing.term()));
                    termStatistics.put(terms[i], new TermStatistics(existing.term(), existing.docFreq() + stats[i].docFreq(), existing.totalTermFreq() + stats[i].totalTermFreq()));
                    continue;
                }
                termStatistics.put(terms[i], stats[i]);
            }
            assert (!lEntry.fieldStatistics().containsKey(null));
            for (Map.Entry<String, CollectionStatistics> entry : lEntry.fieldStatistics().entrySet()) {
                String key = entry.getKey();
                CollectionStatistics value = entry.getValue();
                if (value == null) continue;
                assert (key != null);
                CollectionStatistics existing = (CollectionStatistics)fieldStatistics.get(key);
                if (existing != null) {
                    CollectionStatistics merged = new CollectionStatistics(key, existing.maxDoc() + value.maxDoc(), existing.docCount() + value.docCount(), existing.sumTotalTermFreq() + value.sumTotalTermFreq(), existing.sumDocFreq() + value.sumDocFreq());
                    fieldStatistics.put(key, merged);
                    continue;
                }
                fieldStatistics.put(key, value);
            }
            aggMaxDoc += (long)lEntry.maxDoc();
        }
        return new AggregatedDfs(termStatistics, fieldStatistics, aggMaxDoc);
    }
}

