/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.action.admin.cluster.node.tasks.get;

import java.io.IOException;
import java.util.Objects;
import org.elasticsearch.ElasticsearchException;
import org.elasticsearch.ExceptionsHelper;
import org.elasticsearch.ResourceNotFoundException;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.ActionListenerResponseHandler;
import org.elasticsearch.action.ActionType;
import org.elasticsearch.action.admin.cluster.node.tasks.get.GetTaskRequest;
import org.elasticsearch.action.admin.cluster.node.tasks.get.GetTaskResponse;
import org.elasticsearch.action.get.GetRequest;
import org.elasticsearch.action.get.GetResponse;
import org.elasticsearch.action.support.ActionFilters;
import org.elasticsearch.action.support.ContextPreservingActionListener;
import org.elasticsearch.action.support.HandledTransportAction;
import org.elasticsearch.action.support.ListenableActionFuture;
import org.elasticsearch.client.internal.Client;
import org.elasticsearch.client.internal.OriginSettingClient;
import org.elasticsearch.cluster.node.DiscoveryNode;
import org.elasticsearch.cluster.service.ClusterService;
import org.elasticsearch.common.util.concurrent.EsExecutors;
import org.elasticsearch.common.xcontent.LoggingDeprecationHandler;
import org.elasticsearch.common.xcontent.XContentHelper;
import org.elasticsearch.core.TimeValue;
import org.elasticsearch.index.IndexNotFoundException;
import org.elasticsearch.injection.guice.Inject;
import org.elasticsearch.tasks.RemovedTaskListener;
import org.elasticsearch.tasks.Task;
import org.elasticsearch.tasks.TaskInfo;
import org.elasticsearch.tasks.TaskResult;
import org.elasticsearch.threadpool.ThreadPool;
import org.elasticsearch.transport.TransportRequest;
import org.elasticsearch.transport.TransportRequestOptions;
import org.elasticsearch.transport.TransportService;
import org.elasticsearch.xcontent.NamedXContentRegistry;
import org.elasticsearch.xcontent.XContentParser;

public class TransportGetTaskAction
extends HandledTransportAction<GetTaskRequest, GetTaskResponse> {
    public static final String TASKS_ORIGIN = "tasks";
    public static final ActionType<GetTaskResponse> TYPE = new ActionType("cluster:monitor/task/get");
    private static final TimeValue DEFAULT_WAIT_FOR_COMPLETION_TIMEOUT = TimeValue.timeValueSeconds(30L);
    private final ThreadPool threadPool;
    private final ClusterService clusterService;
    private final TransportService transportService;
    private final Client client;
    private final NamedXContentRegistry xContentRegistry;

    @Inject
    public TransportGetTaskAction(ThreadPool threadPool, TransportService transportService, ActionFilters actionFilters, ClusterService clusterService, Client client, NamedXContentRegistry xContentRegistry) {
        super(TYPE.name(), transportService, actionFilters, GetTaskRequest::new, EsExecutors.DIRECT_EXECUTOR_SERVICE);
        this.threadPool = threadPool;
        this.clusterService = clusterService;
        this.transportService = transportService;
        this.client = new OriginSettingClient(client, TASKS_ORIGIN);
        this.xContentRegistry = xContentRegistry;
    }

    @Override
    protected void doExecute(Task thisTask, GetTaskRequest request, ActionListener<GetTaskResponse> listener) {
        if (this.clusterService.localNode().getId().equals(request.getTaskId().getNodeId())) {
            this.getRunningTaskFromNode(thisTask, request, listener);
        } else {
            this.runOnNodeWithTaskIfPossible(thisTask, request, listener);
        }
    }

    private void runOnNodeWithTaskIfPossible(Task thisTask, GetTaskRequest request, ActionListener<GetTaskResponse> listener) {
        DiscoveryNode node = this.clusterService.state().nodes().get(request.getTaskId().getNodeId());
        if (node == null) {
            this.getFinishedTaskFromIndex(thisTask, request, ActionListener.wrap(listener::onResponse, e -> {
                if (e instanceof ResourceNotFoundException) {
                    e = new ResourceNotFoundException("task [" + String.valueOf(request.getTaskId()) + "] belongs to the node [" + request.getTaskId().getNodeId() + "] which isn't part of the cluster and there is no record of the task", (Throwable)e, new Object[0]);
                }
                listener.onFailure((Exception)e);
            }));
            return;
        }
        GetTaskRequest nodeRequest = request.nodeRequest(this.clusterService.localNode().getId(), thisTask.getId());
        this.transportService.sendRequest(node, TYPE.name(), (TransportRequest)nodeRequest, TransportRequestOptions.timeout(request.getTimeout()), new ActionListenerResponseHandler<GetTaskResponse>(listener, GetTaskResponse::new, EsExecutors.DIRECT_EXECUTOR_SERVICE));
    }

    void getRunningTaskFromNode(Task thisTask, GetTaskRequest request, ActionListener<GetTaskResponse> listener) {
        final Task runningTask = this.taskManager.getTask(request.getTaskId().getId());
        if (runningTask == null) {
            this.getFinishedTaskFromIndex(thisTask, request, listener);
        } else if (request.getWaitForCompletion()) {
            final ListenableActionFuture<Void> future = new ListenableActionFuture<Void>();
            RemovedTaskListener removedTaskListener = new RemovedTaskListener(){

                @Override
                public void onRemoved(Task task) {
                    if (task.equals(runningTask)) {
                        future.onResponse(null);
                    }
                }

                public String toString() {
                    return "Waiting for task completion " + String.valueOf(runningTask);
                }
            };
            this.taskManager.registerRemovedTaskListener(removedTaskListener);
            if (this.taskManager.getTask(request.getTaskId().getId()) == null) {
                future.onResponse(null);
            }
            ActionListener<Void> waitedForCompletionListener = ActionListener.runBefore(listener.delegateFailureAndWrap((l, v) -> this.waitedForCompletion(thisTask, request, runningTask.taskInfo(this.clusterService.localNode().getId(), true), (ActionListener<GetTaskResponse>)l)), () -> this.taskManager.unregisterRemovedTaskListener(removedTaskListener));
            future.addListener(new ContextPreservingActionListener<Void>(this.threadPool.getThreadContext().newRestorableContext(false), waitedForCompletionListener));
            future.addTimeout(Objects.requireNonNullElse(request.getTimeout(), DEFAULT_WAIT_FOR_COMPLETION_TIMEOUT), this.threadPool, EsExecutors.DIRECT_EXECUTOR_SERVICE);
        } else {
            TaskInfo info = runningTask.taskInfo(this.clusterService.localNode().getId(), true);
            listener.onResponse(new GetTaskResponse(new TaskResult(false, info)));
        }
    }

    void waitedForCompletion(Task thisTask, GetTaskRequest request, TaskInfo snapshotOfRunningTask, ActionListener<GetTaskResponse> listener) {
        this.getFinishedTaskFromIndex(thisTask, request, listener.delegateResponse((delegatedListener, e) -> {
            if (ExceptionsHelper.unwrap(e, ResourceNotFoundException.class) != null) {
                delegatedListener.onResponse(new GetTaskResponse(new TaskResult(true, snapshotOfRunningTask)));
            } else {
                delegatedListener.onFailure((Exception)e);
            }
        }));
    }

    void getFinishedTaskFromIndex(Task thisTask, GetTaskRequest request, ActionListener<GetTaskResponse> listener) {
        GetRequest get = new GetRequest(".tasks", request.getTaskId().toString());
        get.setParentTask(this.clusterService.localNode().getId(), thisTask.getId());
        this.client.get(get, ActionListener.wrap(r -> this.onGetFinishedTaskFromIndex((GetResponse)r, listener), e -> {
            if (ExceptionsHelper.unwrap(e, IndexNotFoundException.class) != null) {
                listener.onFailure(new ResourceNotFoundException("task [{}] isn't running and hasn't stored its results", (Throwable)e, request.getTaskId()));
            } else {
                listener.onFailure((Exception)e);
            }
        }));
    }

    void onGetFinishedTaskFromIndex(GetResponse response, ActionListener<GetTaskResponse> listener) throws IOException {
        if (!response.isExists()) {
            listener.onFailure(new ResourceNotFoundException("task [{}] isn't running and hasn't stored its results", response.getId()));
            return;
        }
        if (response.isSourceEmpty()) {
            listener.onFailure(new ElasticsearchException("Stored task status for [{}] didn't contain any source!", response.getId()));
            return;
        }
        try (XContentParser parser = XContentHelper.createParser(this.xContentRegistry, LoggingDeprecationHandler.INSTANCE, response.getSourceAsBytesRef());){
            TaskResult result = TaskResult.PARSER.apply(parser, null);
            listener.onResponse(new GetTaskResponse(result));
        }
    }
}

