/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.action.admin.cluster.node.shutdown;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.elasticsearch.ResourceNotFoundException;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.FailedNodeException;
import org.elasticsearch.action.admin.cluster.node.shutdown.NodePrevalidateShardPathResponse;
import org.elasticsearch.action.admin.cluster.node.shutdown.NodesRemovalPrevalidation;
import org.elasticsearch.action.admin.cluster.node.shutdown.PrevalidateNodeRemovalRequest;
import org.elasticsearch.action.admin.cluster.node.shutdown.PrevalidateNodeRemovalResponse;
import org.elasticsearch.action.admin.cluster.node.shutdown.PrevalidateShardPathRequest;
import org.elasticsearch.action.admin.cluster.node.shutdown.PrevalidateShardPathResponse;
import org.elasticsearch.action.admin.cluster.node.shutdown.TransportPrevalidateShardPathAction;
import org.elasticsearch.action.support.ActionFilters;
import org.elasticsearch.action.support.master.TransportMasterNodeReadAction;
import org.elasticsearch.client.internal.node.NodeClient;
import org.elasticsearch.cluster.ClusterState;
import org.elasticsearch.cluster.block.ClusterBlockException;
import org.elasticsearch.cluster.health.ClusterHealthStatus;
import org.elasticsearch.cluster.health.ClusterIndexHealth;
import org.elasticsearch.cluster.health.ClusterShardHealth;
import org.elasticsearch.cluster.health.ClusterStateHealth;
import org.elasticsearch.cluster.metadata.Metadata;
import org.elasticsearch.cluster.node.DiscoveryNode;
import org.elasticsearch.cluster.node.DiscoveryNodes;
import org.elasticsearch.cluster.service.ClusterService;
import org.elasticsearch.common.util.concurrent.EsExecutors;
import org.elasticsearch.core.Strings;
import org.elasticsearch.core.Tuple;
import org.elasticsearch.index.shard.ShardId;
import org.elasticsearch.injection.guice.Inject;
import org.elasticsearch.logging.LogManager;
import org.elasticsearch.logging.Logger;
import org.elasticsearch.tasks.Task;
import org.elasticsearch.threadpool.ThreadPool;
import org.elasticsearch.transport.TransportService;

public class TransportPrevalidateNodeRemovalAction
extends TransportMasterNodeReadAction<PrevalidateNodeRemovalRequest, PrevalidateNodeRemovalResponse> {
    private static final Logger logger = LogManager.getLogger(TransportPrevalidateNodeRemovalAction.class);
    private final NodeClient client;

    @Inject
    public TransportPrevalidateNodeRemovalAction(TransportService transportService, ClusterService clusterService, ThreadPool threadPool, ActionFilters actionFilters, NodeClient client) {
        super("cluster:admin/shutdown/prevalidate_removal", false, transportService, clusterService, threadPool, actionFilters, PrevalidateNodeRemovalRequest::new, PrevalidateNodeRemovalResponse::new, EsExecutors.DIRECT_EXECUTOR_SERVICE);
        this.client = client;
    }

    @Override
    protected void masterOperation(Task task, PrevalidateNodeRemovalRequest request, ClusterState state, ActionListener<PrevalidateNodeRemovalResponse> responseListener) {
        ActionListener.run(responseListener, listener -> {
            Set<DiscoveryNode> requestNodes = TransportPrevalidateNodeRemovalAction.resolveNodes(request, state.nodes());
            this.doPrevalidation(request, requestNodes, state, (ActionListener<PrevalidateNodeRemovalResponse>)listener);
        });
    }

    public static Set<DiscoveryNode> resolveNodes(PrevalidateNodeRemovalRequest request, DiscoveryNodes discoveryNodes) {
        assert (Stream.of(request.getNames(), request.getIds(), request.getExternalIds()).filter(TransportPrevalidateNodeRemovalAction::notEmpty).toList().size() == 1);
        if (TransportPrevalidateNodeRemovalAction.notEmpty(request.getNames())) {
            logger.debug("resolving nodes for prevalidation using name");
            HashSet<String> names = new HashSet<String>(Arrays.asList(request.getNames()));
            Set<DiscoveryNode> resolvedNodes = discoveryNodes.stream().filter(n -> names.contains(n.getName())).collect(Collectors.toSet());
            if (resolvedNodes.size() < names.size()) {
                Set existingNodeNames = discoveryNodes.stream().map(DiscoveryNode::getName).collect(Collectors.toSet());
                names.removeAll(existingNodeNames);
                throw new ResourceNotFoundException("could not resolve node names {}", names);
            }
            assert (resolvedNodes.size() == request.getNames().length);
            return resolvedNodes;
        }
        if (TransportPrevalidateNodeRemovalAction.notEmpty(request.getIds())) {
            logger.debug("resolving nodes for prevalidation using ID");
            String[] ids = request.getIds();
            Set<DiscoveryNode> resolvedNode = Arrays.stream(ids).map(discoveryNodes::get).filter(Objects::nonNull).collect(Collectors.toSet());
            if (resolvedNode.size() < ids.length) {
                Set existingNodeIds = discoveryNodes.stream().map(DiscoveryNode::getId).collect(Collectors.toSet());
                Set idsNotFound = Arrays.stream(ids).filter(id -> !existingNodeIds.contains(id)).collect(Collectors.toSet());
                throw new ResourceNotFoundException("could not resolve node IDs {}", idsNotFound);
            }
            return resolvedNode;
        }
        logger.debug("resolving nodes for prevalidation using external ID");
        HashSet<String> externalIds = new HashSet<String>(Arrays.asList(request.getExternalIds()));
        Set<DiscoveryNode> resolvedNodes = discoveryNodes.stream().filter(n -> externalIds.contains(n.getExternalId())).collect(Collectors.toSet());
        if (resolvedNodes.size() < externalIds.size()) {
            Set existingExternalIds = discoveryNodes.stream().map(DiscoveryNode::getExternalId).collect(Collectors.toSet());
            externalIds.removeAll(existingExternalIds);
            throw new ResourceNotFoundException("could not resolve node external IDs {}", externalIds);
        }
        assert (resolvedNodes.size() == request.getExternalIds().length);
        return resolvedNodes;
    }

    private static boolean notEmpty(String[] a) {
        return a != null && a.length > 0;
    }

    @Override
    protected ClusterBlockException checkBlock(PrevalidateNodeRemovalRequest request, ClusterState state) {
        return null;
    }

    private void doPrevalidation(PrevalidateNodeRemovalRequest request, Set<DiscoveryNode> requestNodes, ClusterState clusterState, final ActionListener<PrevalidateNodeRemovalResponse> listener) {
        assert (requestNodes != null && !requestNodes.isEmpty());
        logger.debug(() -> "prevalidate node removal for nodes " + String.valueOf(requestNodes));
        ClusterStateHealth clusterStateHealth = new ClusterStateHealth(clusterState);
        Metadata metadata = clusterState.metadata();
        final DiscoveryNodes clusterNodes = clusterState.getNodes();
        if (clusterStateHealth.getStatus() == ClusterHealthStatus.GREEN || clusterStateHealth.getStatus() == ClusterHealthStatus.YELLOW) {
            List<NodesRemovalPrevalidation.NodeResult> nodesResults = requestNodes.stream().map(dn -> new NodesRemovalPrevalidation.NodeResult(dn.getName(), dn.getId(), dn.getExternalId(), new NodesRemovalPrevalidation.Result(true, NodesRemovalPrevalidation.Reason.NO_PROBLEMS, ""))).toList();
            listener.onResponse(new PrevalidateNodeRemovalResponse(new NodesRemovalPrevalidation(true, "cluster status is not RED", nodesResults)));
            return;
        }
        Set redIndices = clusterStateHealth.getIndices().entrySet().stream().filter(entry -> ((ClusterIndexHealth)entry.getValue()).getStatus() == ClusterHealthStatus.RED).map(Map.Entry::getKey).collect(Collectors.toSet());
        Set redNonSSIndices = redIndices.stream().map(metadata::index).filter(i -> !i.isSearchableSnapshot()).map(im -> im.getIndex().getName()).collect(Collectors.toSet());
        if (redNonSSIndices.isEmpty()) {
            List<NodesRemovalPrevalidation.NodeResult> nodeResults = requestNodes.stream().map(dn -> new NodesRemovalPrevalidation.NodeResult(dn.getName(), dn.getId(), dn.getExternalId(), new NodesRemovalPrevalidation.Result(true, NodesRemovalPrevalidation.Reason.NO_RED_SHARDS_EXCEPT_SEARCHABLE_SNAPSHOTS, ""))).toList();
            listener.onResponse(new PrevalidateNodeRemovalResponse(new NodesRemovalPrevalidation(true, "all red indices are searchable snapshot indices", nodeResults)));
        } else {
            Set<ShardId> redShards = clusterStateHealth.getIndices().entrySet().stream().filter(indexHealthEntry -> redNonSSIndices.contains(indexHealthEntry.getKey())).map(Map.Entry::getValue).flatMap(redIndexHealth -> redIndexHealth.getShards().values().stream().filter(shardHealth -> shardHealth.getStatus() == ClusterHealthStatus.RED).map(redShardHealth -> Tuple.tuple(redIndexHealth.getIndex(), redShardHealth))).map(redIndexShardHealthTuple -> new ShardId(metadata.index((String)redIndexShardHealthTuple.v1()).getIndex(), ((ClusterShardHealth)redIndexShardHealthTuple.v2()).getShardId())).collect(Collectors.toSet());
            String[] nodeIds = requestNodes.stream().map(DiscoveryNode::getId).toList().toArray(new String[0]);
            PrevalidateShardPathRequest checkShardsRequest = new PrevalidateShardPathRequest(redShards, nodeIds);
            checkShardsRequest.setTimeout(request.timeout());
            this.client.execute(TransportPrevalidateShardPathAction.TYPE, checkShardsRequest, new ActionListener<PrevalidateShardPathResponse>(this){

                @Override
                public void onResponse(PrevalidateShardPathResponse response) {
                    listener.onResponse(new PrevalidateNodeRemovalResponse(TransportPrevalidateNodeRemovalAction.createPrevalidationResult(clusterNodes, response)));
                }

                @Override
                public void onFailure(Exception e) {
                    listener.onFailure(e);
                }
            });
        }
    }

    private static NodesRemovalPrevalidation createPrevalidationResult(DiscoveryNodes nodes, PrevalidateShardPathResponse response) {
        ArrayList<NodesRemovalPrevalidation.NodeResult> nodeResults = new ArrayList<NodesRemovalPrevalidation.NodeResult>(response.getNodes().size() + response.failures().size());
        for (NodePrevalidateShardPathResponse nodeResponse : response.getNodes()) {
            NodesRemovalPrevalidation.Result result = nodeResponse.getShardIds().isEmpty() ? new NodesRemovalPrevalidation.Result(true, NodesRemovalPrevalidation.Reason.NO_RED_SHARDS_ON_NODE, "") : new NodesRemovalPrevalidation.Result(false, NodesRemovalPrevalidation.Reason.RED_SHARDS_ON_NODE, Strings.format("node contains copies of the following red shards: %s", nodeResponse.getShardIds()));
            nodeResults.add(new NodesRemovalPrevalidation.NodeResult(nodeResponse.getNode().getName(), nodeResponse.getNode().getId(), nodeResponse.getNode().getExternalId(), result));
        }
        for (FailedNodeException failedResponse : response.failures()) {
            DiscoveryNode node = nodes.get(failedResponse.nodeId());
            nodeResults.add(new NodesRemovalPrevalidation.NodeResult(node.getName(), node.getId(), node.getExternalId(), new NodesRemovalPrevalidation.Result(false, NodesRemovalPrevalidation.Reason.UNABLE_TO_VERIFY, Strings.format("failed contacting the node: %s", failedResponse.getDetailedMessage()))));
        }
        Set unsafeNodeRemovals = response.getNodes().stream().filter(r -> !r.getShardIds().isEmpty()).map(r -> r.getNode().getId()).collect(Collectors.toSet());
        if (!unsafeNodeRemovals.isEmpty()) {
            return new NodesRemovalPrevalidation(false, Strings.format("removal of the following nodes might not be safe: %s", unsafeNodeRemovals), nodeResults);
        }
        if (!response.failures().isEmpty()) {
            Set unknownNodeRemovals = response.failures().stream().map(FailedNodeException::nodeId).collect(Collectors.toSet());
            return new NodesRemovalPrevalidation(false, Strings.format("cannot prevalidate removal of nodes with the following IDs: %s", unknownNodeRemovals), nodeResults);
        }
        return new NodesRemovalPrevalidation(true, "", nodeResults);
    }
}

