/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.logstash.filters.elasticintegration.ingest;

import java.io.Closeable;
import java.io.IOException;
import java.util.Map;
import java.util.function.Supplier;
import org.elasticsearch.core.IOUtils;
import org.elasticsearch.ingest.Processor;
import org.elasticsearch.plugins.IngestPlugin;

public class SingleProcessorIngestPlugin
implements IngestPlugin,
Closeable {
    private final String type;
    private final Processor.Factory processorFactory;

    public static Supplier<IngestPlugin> of(String type, Supplier<Processor.Factory> factorySupplier) {
        return () -> new SingleProcessorIngestPlugin(type, (Processor.Factory)factorySupplier.get());
    }

    public SingleProcessorIngestPlugin(String type, Processor.Factory processorFactory) {
        this.type = type;
        this.processorFactory = processorFactory;
    }

    @Override
    public Map<String, Processor.Factory> getProcessors(Processor.Parameters parameters) {
        return Map.of(this.type, this.processorFactory);
    }

    @Override
    public void close() throws IOException {
        if (this.processorFactory instanceof Closeable) {
            IOUtils.closeWhileHandlingException((Closeable)((Object)this.processorFactory));
        }
    }
}

