/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.logstash.filters.elasticintegration;

import java.util.Objects;
import java.util.function.BiConsumer;
import org.elasticsearch.ingest.IngestDocument;
import org.elasticsearch.ingest.Pipeline;
import org.elasticsearch.ingest.PipelineConfiguration;

public class IngestPipeline {
    private final PipelineConfiguration pipelineConfiguration;
    private final Pipeline innerPipeline;

    IngestPipeline(PipelineConfiguration pipelineConfiguration, Pipeline innerPipeline) {
        this.pipelineConfiguration = pipelineConfiguration;
        this.innerPipeline = innerPipeline;
    }

    public String getId() {
        return this.innerPipeline.getId();
    }

    public void execute(IngestDocument ingestDocument, BiConsumer<IngestDocument, Exception> handler) {
        ingestDocument.executePipeline(this.innerPipeline, handler);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        IngestPipeline that = (IngestPipeline)o;
        return this.pipelineConfiguration.equals(that.pipelineConfiguration);
    }

    public int hashCode() {
        return Objects.hash(this.pipelineConfiguration);
    }

    public String toString() {
        return "IngestPipeline{id=" + this.getId() + "pipelineConfiguration=" + String.valueOf(this.pipelineConfiguration) + "}";
    }
}

