/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch.shutdown;

import co.elastic.clients.ApiClient;
import co.elastic.clients.elasticsearch.shutdown.DeleteNodeRequest;
import co.elastic.clients.elasticsearch.shutdown.DeleteNodeResponse;
import co.elastic.clients.elasticsearch.shutdown.GetNodeRequest;
import co.elastic.clients.elasticsearch.shutdown.GetNodeResponse;
import co.elastic.clients.elasticsearch.shutdown.PutNodeRequest;
import co.elastic.clients.elasticsearch.shutdown.PutNodeResponse;
import co.elastic.clients.transport.ElasticsearchTransport;
import co.elastic.clients.transport.JsonEndpoint;
import co.elastic.clients.transport.TransportOptions;
import co.elastic.clients.util.ObjectBuilder;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import javax.annotation.Nullable;

public class ElasticsearchShutdownAsyncClient
extends ApiClient<ElasticsearchTransport, ElasticsearchShutdownAsyncClient> {
    public ElasticsearchShutdownAsyncClient(ElasticsearchTransport transport) {
        super(transport, null);
    }

    public ElasticsearchShutdownAsyncClient(ElasticsearchTransport transport, @Nullable TransportOptions transportOptions) {
        super(transport, transportOptions);
    }

    @Override
    public ElasticsearchShutdownAsyncClient withTransportOptions(@Nullable TransportOptions transportOptions) {
        return new ElasticsearchShutdownAsyncClient((ElasticsearchTransport)this.transport, transportOptions);
    }

    public CompletableFuture<DeleteNodeResponse> deleteNode(DeleteNodeRequest request) {
        JsonEndpoint endpoint = (JsonEndpoint)DeleteNodeRequest._ENDPOINT;
        return ((ElasticsearchTransport)this.transport).performRequestAsync(request, endpoint, this.transportOptions);
    }

    public final CompletableFuture<DeleteNodeResponse> deleteNode(Function<DeleteNodeRequest.Builder, ObjectBuilder<DeleteNodeRequest>> fn) {
        return this.deleteNode(fn.apply(new DeleteNodeRequest.Builder()).build());
    }

    public CompletableFuture<GetNodeResponse> getNode(GetNodeRequest request) {
        JsonEndpoint endpoint = (JsonEndpoint)GetNodeRequest._ENDPOINT;
        return ((ElasticsearchTransport)this.transport).performRequestAsync(request, endpoint, this.transportOptions);
    }

    public final CompletableFuture<GetNodeResponse> getNode(Function<GetNodeRequest.Builder, ObjectBuilder<GetNodeRequest>> fn) {
        return this.getNode(fn.apply(new GetNodeRequest.Builder()).build());
    }

    public CompletableFuture<GetNodeResponse> getNode() {
        return ((ElasticsearchTransport)this.transport).performRequestAsync(new GetNodeRequest.Builder().build(), GetNodeRequest._ENDPOINT, this.transportOptions);
    }

    public CompletableFuture<PutNodeResponse> putNode(PutNodeRequest request) {
        JsonEndpoint endpoint = (JsonEndpoint)PutNodeRequest._ENDPOINT;
        return ((ElasticsearchTransport)this.transport).performRequestAsync(request, endpoint, this.transportOptions);
    }

    public final CompletableFuture<PutNodeResponse> putNode(Function<PutNodeRequest.Builder, ObjectBuilder<PutNodeRequest>> fn) {
        return this.putNode(fn.apply(new PutNodeRequest.Builder()).build());
    }
}

