/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch.security;

import co.elastic.clients.elasticsearch._types.ErrorCause;
import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.JsonpSerializable;
import co.elastic.clients.json.JsonpUtils;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.json.ObjectDeserializer;
import co.elastic.clients.util.ApiTypeHelper;
import co.elastic.clients.util.ObjectBuilder;
import co.elastic.clients.util.WithJsonObjectBuilderBase;
import jakarta.json.stream.JsonGenerator;
import java.util.List;
import java.util.function.Function;
import javax.annotation.Nullable;

@JsonpDeserializable
public class InvalidateTokenResponse
implements JsonpSerializable {
    private final long errorCount;
    private final List<ErrorCause> errorDetails;
    private final long invalidatedTokens;
    private final long previouslyInvalidatedTokens;
    public static final JsonpDeserializer<InvalidateTokenResponse> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, InvalidateTokenResponse::setupInvalidateTokenResponseDeserializer);

    private InvalidateTokenResponse(Builder builder) {
        this.errorCount = ApiTypeHelper.requireNonNull(builder.errorCount, (Object)this, "errorCount", 0L);
        this.errorDetails = ApiTypeHelper.unmodifiable(builder.errorDetails);
        this.invalidatedTokens = ApiTypeHelper.requireNonNull(builder.invalidatedTokens, (Object)this, "invalidatedTokens", 0L);
        this.previouslyInvalidatedTokens = ApiTypeHelper.requireNonNull(builder.previouslyInvalidatedTokens, (Object)this, "previouslyInvalidatedTokens", 0L);
    }

    public static InvalidateTokenResponse of(Function<Builder, ObjectBuilder<InvalidateTokenResponse>> fn) {
        return fn.apply(new Builder()).build();
    }

    public final long errorCount() {
        return this.errorCount;
    }

    public final List<ErrorCause> errorDetails() {
        return this.errorDetails;
    }

    public final long invalidatedTokens() {
        return this.invalidatedTokens;
    }

    public final long previouslyInvalidatedTokens() {
        return this.previouslyInvalidatedTokens;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeKey("error_count");
        generator.write(this.errorCount);
        if (ApiTypeHelper.isDefined(this.errorDetails)) {
            generator.writeKey("error_details");
            generator.writeStartArray();
            for (ErrorCause item0 : this.errorDetails) {
                item0.serialize(generator, mapper);
            }
            generator.writeEnd();
        }
        generator.writeKey("invalidated_tokens");
        generator.write(this.invalidatedTokens);
        generator.writeKey("previously_invalidated_tokens");
        generator.write(this.previouslyInvalidatedTokens);
    }

    public String toString() {
        return JsonpUtils.toString(this);
    }

    protected static void setupInvalidateTokenResponseDeserializer(ObjectDeserializer<Builder> op) {
        op.add(Builder::errorCount, JsonpDeserializer.longDeserializer(), "error_count");
        op.add(Builder::errorDetails, JsonpDeserializer.arrayDeserializer(ErrorCause._DESERIALIZER), "error_details");
        op.add(Builder::invalidatedTokens, JsonpDeserializer.longDeserializer(), "invalidated_tokens");
        op.add(Builder::previouslyInvalidatedTokens, JsonpDeserializer.longDeserializer(), "previously_invalidated_tokens");
    }

    public static class Builder
    extends WithJsonObjectBuilderBase<Builder>
    implements ObjectBuilder<InvalidateTokenResponse> {
        private Long errorCount;
        @Nullable
        private List<ErrorCause> errorDetails;
        private Long invalidatedTokens;
        private Long previouslyInvalidatedTokens;

        public final Builder errorCount(long value) {
            this.errorCount = value;
            return this;
        }

        public final Builder errorDetails(List<ErrorCause> list) {
            this.errorDetails = Builder._listAddAll(this.errorDetails, list);
            return this;
        }

        public final Builder errorDetails(ErrorCause value, ErrorCause ... values) {
            this.errorDetails = Builder._listAdd(this.errorDetails, value, values);
            return this;
        }

        public final Builder errorDetails(Function<ErrorCause.Builder, ObjectBuilder<ErrorCause>> fn) {
            return this.errorDetails(fn.apply(new ErrorCause.Builder()).build(), new ErrorCause[0]);
        }

        public final Builder invalidatedTokens(long value) {
            this.invalidatedTokens = value;
            return this;
        }

        public final Builder previouslyInvalidatedTokens(long value) {
            this.previouslyInvalidatedTokens = value;
            return this;
        }

        @Override
        protected Builder self() {
            return this;
        }

        @Override
        public InvalidateTokenResponse build() {
            this._checkSingleUse();
            return new InvalidateTokenResponse(this);
        }
    }
}

