/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch.nodes;

import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.JsonpSerializable;
import co.elastic.clients.json.JsonpUtils;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.json.ObjectDeserializer;
import co.elastic.clients.util.ObjectBuilder;
import co.elastic.clients.util.WithJsonObjectBuilderBase;
import jakarta.json.stream.JsonGenerator;
import java.util.function.Function;
import javax.annotation.Nullable;

@JsonpDeserializable
public class IoStatDevice
implements JsonpSerializable {
    @Nullable
    private final String deviceName;
    @Nullable
    private final Long operations;
    @Nullable
    private final Long readKilobytes;
    @Nullable
    private final Long readOperations;
    @Nullable
    private final Long writeKilobytes;
    @Nullable
    private final Long writeOperations;
    public static final JsonpDeserializer<IoStatDevice> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, IoStatDevice::setupIoStatDeviceDeserializer);

    private IoStatDevice(Builder builder) {
        this.deviceName = builder.deviceName;
        this.operations = builder.operations;
        this.readKilobytes = builder.readKilobytes;
        this.readOperations = builder.readOperations;
        this.writeKilobytes = builder.writeKilobytes;
        this.writeOperations = builder.writeOperations;
    }

    public static IoStatDevice of(Function<Builder, ObjectBuilder<IoStatDevice>> fn) {
        return fn.apply(new Builder()).build();
    }

    @Nullable
    public final String deviceName() {
        return this.deviceName;
    }

    @Nullable
    public final Long operations() {
        return this.operations;
    }

    @Nullable
    public final Long readKilobytes() {
        return this.readKilobytes;
    }

    @Nullable
    public final Long readOperations() {
        return this.readOperations;
    }

    @Nullable
    public final Long writeKilobytes() {
        return this.writeKilobytes;
    }

    @Nullable
    public final Long writeOperations() {
        return this.writeOperations;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        if (this.deviceName != null) {
            generator.writeKey("device_name");
            generator.write(this.deviceName);
        }
        if (this.operations != null) {
            generator.writeKey("operations");
            generator.write(this.operations);
        }
        if (this.readKilobytes != null) {
            generator.writeKey("read_kilobytes");
            generator.write(this.readKilobytes);
        }
        if (this.readOperations != null) {
            generator.writeKey("read_operations");
            generator.write(this.readOperations);
        }
        if (this.writeKilobytes != null) {
            generator.writeKey("write_kilobytes");
            generator.write(this.writeKilobytes);
        }
        if (this.writeOperations != null) {
            generator.writeKey("write_operations");
            generator.write(this.writeOperations);
        }
    }

    public String toString() {
        return JsonpUtils.toString(this);
    }

    protected static void setupIoStatDeviceDeserializer(ObjectDeserializer<Builder> op) {
        op.add(Builder::deviceName, JsonpDeserializer.stringDeserializer(), "device_name");
        op.add(Builder::operations, JsonpDeserializer.longDeserializer(), "operations");
        op.add(Builder::readKilobytes, JsonpDeserializer.longDeserializer(), "read_kilobytes");
        op.add(Builder::readOperations, JsonpDeserializer.longDeserializer(), "read_operations");
        op.add(Builder::writeKilobytes, JsonpDeserializer.longDeserializer(), "write_kilobytes");
        op.add(Builder::writeOperations, JsonpDeserializer.longDeserializer(), "write_operations");
    }

    public static class Builder
    extends WithJsonObjectBuilderBase<Builder>
    implements ObjectBuilder<IoStatDevice> {
        @Nullable
        private String deviceName;
        @Nullable
        private Long operations;
        @Nullable
        private Long readKilobytes;
        @Nullable
        private Long readOperations;
        @Nullable
        private Long writeKilobytes;
        @Nullable
        private Long writeOperations;

        public final Builder deviceName(@Nullable String value) {
            this.deviceName = value;
            return this;
        }

        public final Builder operations(@Nullable Long value) {
            this.operations = value;
            return this;
        }

        public final Builder readKilobytes(@Nullable Long value) {
            this.readKilobytes = value;
            return this;
        }

        public final Builder readOperations(@Nullable Long value) {
            this.readOperations = value;
            return this;
        }

        public final Builder writeKilobytes(@Nullable Long value) {
            this.writeKilobytes = value;
            return this;
        }

        public final Builder writeOperations(@Nullable Long value) {
            this.writeOperations = value;
            return this;
        }

        @Override
        protected Builder self() {
            return this;
        }

        @Override
        public IoStatDevice build() {
            this._checkSingleUse();
            return new IoStatDevice(this);
        }
    }
}

