/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch.ml;

import co.elastic.clients.elasticsearch.ml.RoutingState;
import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.JsonpSerializable;
import co.elastic.clients.json.JsonpUtils;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.json.ObjectDeserializer;
import co.elastic.clients.util.ApiTypeHelper;
import co.elastic.clients.util.ObjectBuilder;
import co.elastic.clients.util.WithJsonObjectBuilderBase;
import jakarta.json.stream.JsonGenerator;
import java.util.function.Function;
import javax.annotation.Nullable;

@JsonpDeserializable
public class TrainedModelAssignmentRoutingTable
implements JsonpSerializable {
    @Nullable
    private final String reason;
    private final RoutingState routingState;
    private final int currentAllocations;
    private final int targetAllocations;
    public static final JsonpDeserializer<TrainedModelAssignmentRoutingTable> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, TrainedModelAssignmentRoutingTable::setupTrainedModelAssignmentRoutingTableDeserializer);

    private TrainedModelAssignmentRoutingTable(Builder builder) {
        this.reason = builder.reason;
        this.routingState = ApiTypeHelper.requireNonNull(builder.routingState, this, "routingState");
        this.currentAllocations = ApiTypeHelper.requireNonNull(builder.currentAllocations, (Object)this, "currentAllocations", 0);
        this.targetAllocations = ApiTypeHelper.requireNonNull(builder.targetAllocations, (Object)this, "targetAllocations", 0);
    }

    public static TrainedModelAssignmentRoutingTable of(Function<Builder, ObjectBuilder<TrainedModelAssignmentRoutingTable>> fn) {
        return fn.apply(new Builder()).build();
    }

    @Nullable
    public final String reason() {
        return this.reason;
    }

    public final RoutingState routingState() {
        return this.routingState;
    }

    public final int currentAllocations() {
        return this.currentAllocations;
    }

    public final int targetAllocations() {
        return this.targetAllocations;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        if (this.reason != null) {
            generator.writeKey("reason");
            generator.write(this.reason);
        }
        generator.writeKey("routing_state");
        this.routingState.serialize(generator, mapper);
        generator.writeKey("current_allocations");
        generator.write(this.currentAllocations);
        generator.writeKey("target_allocations");
        generator.write(this.targetAllocations);
    }

    public String toString() {
        return JsonpUtils.toString(this);
    }

    protected static void setupTrainedModelAssignmentRoutingTableDeserializer(ObjectDeserializer<Builder> op) {
        op.add(Builder::reason, JsonpDeserializer.stringDeserializer(), "reason");
        op.add(Builder::routingState, RoutingState._DESERIALIZER, "routing_state");
        op.add(Builder::currentAllocations, JsonpDeserializer.integerDeserializer(), "current_allocations");
        op.add(Builder::targetAllocations, JsonpDeserializer.integerDeserializer(), "target_allocations");
    }

    public static class Builder
    extends WithJsonObjectBuilderBase<Builder>
    implements ObjectBuilder<TrainedModelAssignmentRoutingTable> {
        @Nullable
        private String reason;
        private RoutingState routingState;
        private Integer currentAllocations;
        private Integer targetAllocations;

        public final Builder reason(@Nullable String value) {
            this.reason = value;
            return this;
        }

        public final Builder routingState(RoutingState value) {
            this.routingState = value;
            return this;
        }

        public final Builder currentAllocations(int value) {
            this.currentAllocations = value;
            return this;
        }

        public final Builder targetAllocations(int value) {
            this.targetAllocations = value;
            return this;
        }

        @Override
        protected Builder self() {
            return this;
        }

        @Override
        public TrainedModelAssignmentRoutingTable build() {
            this._checkSingleUse();
            return new TrainedModelAssignmentRoutingTable(this);
        }
    }
}

